/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.hawk;

import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.utils.HmacAlgorithm;
import org.apache.cxf.rs.security.oauth2.utils.HmacUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class HawkAccessToken
extends ServerAccessToken {
    private static final long serialVersionUID = -4331703769692080818L;

    public HawkAccessToken(Client client, long lifetime) {
        this(client, HmacAlgorithm.HmacSHA256, lifetime);
    }

    public HawkAccessToken(Client client, String macAuthAlgo, long lifetime) {
        this(client, HmacAlgorithm.toHmacAlgorithm(macAuthAlgo), lifetime);
    }

    public HawkAccessToken(Client client, HmacAlgorithm macAlgo, long lifetime) {
        this(client, macAlgo, OAuthUtils.generateRandomTokenKey(), lifetime, OAuthUtils.getIssuedAt());
    }

    public HawkAccessToken(Client client, HmacAlgorithm algo, String tokenKey, long lifetime, long issuedAt) {
        super(client, "hawk", tokenKey, lifetime, issuedAt);
        this.setExtraParameters(algo, null);
    }

    public HawkAccessToken(Client client, HmacAlgorithm algo, String tokenKey, String macKey, long lifetime, long issuedAt) {
        super(client, "hawk", tokenKey, lifetime, issuedAt);
        this.setExtraParameters(algo, macKey);
    }

    public HawkAccessToken(ServerAccessToken token, String newKey) {
        super(HawkAccessToken.validateTokenType(token, "hawk"), newKey);
    }

    private void setExtraParameters(HmacAlgorithm algo, String macKey) {
        String theKey = macKey == null ? HmacUtils.generateSecret(algo) : macKey;
        super.getParameters().put("secret", theKey);
        super.getParameters().put("algorithm", algo.getOAuthName());
    }

    public String getMacId() {
        return super.getTokenKey();
    }

    public String getMacKey() {
        return super.getParameters().get("secret");
    }

    public String getMacAlgorithm() {
        return super.getParameters().get("algorithm");
    }
}

