/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.runtime;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.types.CorbaAnyHandler;
import org.apache.cxf.binding.corba.types.CorbaArrayHandler;
import org.apache.cxf.binding.corba.types.CorbaEnumHandler;
import org.apache.cxf.binding.corba.types.CorbaExceptionHandler;
import org.apache.cxf.binding.corba.types.CorbaFixedHandler;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaObjectReferenceHandler;
import org.apache.cxf.binding.corba.types.CorbaOctetSequenceHandler;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveHandler;
import org.apache.cxf.binding.corba.types.CorbaSequenceHandler;
import org.apache.cxf.binding.corba.types.CorbaStructHandler;
import org.apache.cxf.binding.corba.types.CorbaUnionHandler;
import org.apache.cxf.binding.corba.wsdl.Enum;
import org.apache.cxf.binding.corba.wsdl.Enumerator;
import org.apache.cxf.binding.corba.wsdl.Exception;
import org.apache.cxf.binding.corba.wsdl.Union;
import org.apache.cxf.binding.corba.wsdl.Unionbranch;
import org.omg.CORBA.Any;
import org.omg.CORBA.portable.OutputStream;

public class CorbaObjectWriter {
    private OutputStream stream;

    public CorbaObjectWriter(OutputStream outStream) {
        this.stream = outStream;
    }

    public void write(CorbaObjectHandler obj) {
        assert (obj != null);
        switch (obj.getTypeCode().kind().value()) {
            case 8: {
                this.writeBoolean((Boolean)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 9: {
                this.writeChar((Character)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 26: {
                this.writeWChar((Character)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 10: {
                this.writeOctet((Byte)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 2: {
                this.writeShort((Short)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 4: {
                this.writeUShort((Integer)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 3: {
                this.writeLong((Integer)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 5: {
                this.writeULong((Long)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 23: {
                this.writeLongLong((Long)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 24: {
                this.writeULongLong((BigInteger)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 6: {
                this.writeFloat((Float)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 7: {
                this.writeDouble((Double)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 18: {
                this.writeString((String)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 27: {
                this.writeWString((String)((CorbaPrimitiveHandler)obj).getValue());
                break;
            }
            case 11: {
                this.writeAny((CorbaAnyHandler)obj);
                break;
            }
            case 20: {
                this.writeArray((CorbaArrayHandler)obj);
                break;
            }
            case 19: {
                this.writeSequence(obj);
                break;
            }
            case 15: {
                this.writeStruct((CorbaStructHandler)obj);
                break;
            }
            case 17: {
                this.writeEnum((CorbaEnumHandler)obj);
                break;
            }
            case 22: {
                this.writeException((CorbaExceptionHandler)obj);
                break;
            }
            case 28: {
                this.writeFixed((CorbaFixedHandler)obj);
                break;
            }
            case 16: {
                this.writeUnion(obj);
                break;
            }
            case 14: {
                this.writeObjectReference((CorbaObjectReferenceHandler)obj);
                break;
            }
        }
    }

    public void writeBoolean(Boolean b) throws CorbaBindingException {
        if (b == null) {
            this.stream.write_boolean(false);
        } else {
            this.stream.write_boolean(b.booleanValue());
        }
    }

    public void writeChar(Character c) throws CorbaBindingException {
        if (c == null) {
            this.stream.write_char('\u0000');
        } else {
            this.stream.write_char(c.charValue());
        }
    }

    public void writeWChar(Character c) throws CorbaBindingException {
        if (c == null) {
            this.stream.write_wchar('\u0000');
        } else {
            this.stream.write_wchar(c.charValue());
        }
    }

    public void writeOctet(Byte b) throws CorbaBindingException {
        if (b == null) {
            this.stream.write_octet((byte)0);
        } else {
            this.stream.write_octet(b.byteValue());
        }
    }

    public void writeShort(Short s) throws CorbaBindingException {
        if (s == null) {
            this.stream.write_short((short)0);
        } else {
            this.stream.write_short(s.shortValue());
        }
    }

    public void writeUShort(Integer s) throws CorbaBindingException {
        if (s == null) {
            this.stream.write_ushort((short)0);
        } else {
            this.stream.write_ushort(s.shortValue());
        }
    }

    public void writeLong(Integer l) throws CorbaBindingException {
        if (l == null) {
            this.stream.write_long(0);
        } else {
            this.stream.write_long(l.intValue());
        }
    }

    public void writeULong(Long l) throws CorbaBindingException {
        if (l == null) {
            this.stream.write_ulong(0);
        } else {
            this.stream.write_ulong(l.intValue());
        }
    }

    public void writeLongLong(Long l) throws CorbaBindingException {
        if (l == null) {
            this.stream.write_longlong(0L);
        } else {
            this.stream.write_longlong(l.longValue());
        }
    }

    public void writeULongLong(BigInteger l) throws CorbaBindingException {
        if (l == null) {
            this.stream.write_ulonglong(0L);
        } else {
            this.stream.write_ulonglong(l.longValue());
        }
    }

    public void writeFloat(Float f) throws CorbaBindingException {
        if (f == null) {
            this.stream.write_float(0.0f);
        } else {
            this.stream.write_float(f.floatValue());
        }
    }

    public void writeDouble(Double d) throws CorbaBindingException {
        if (d == null) {
            this.stream.write_double(0.0);
        } else {
            this.stream.write_double(d.doubleValue());
        }
    }

    public void writeString(String s) throws CorbaBindingException {
        if (s == null) {
            this.stream.write_string("");
        } else {
            this.stream.write_string(s);
        }
    }

    public void writeWString(String s) throws CorbaBindingException {
        if (s == null) {
            this.stream.write_wstring("");
        } else {
            this.stream.write_wstring(s);
        }
    }

    public void writeAny(CorbaAnyHandler anyHandler) throws CorbaBindingException {
        CorbaObjectHandler containedType = anyHandler.getAnyContainedType();
        Any a = anyHandler.getValue();
        if (containedType != null) {
            a.type(containedType.getTypeCode());
            OutputStream os = a.create_output_stream();
            CorbaObjectWriter writer = new CorbaObjectWriter(os);
            writer.write(containedType);
            a.read_value(os.create_input_stream(), containedType.getTypeCode());
        }
        this.stream.write_any(a);
    }

    public void writeEnum(CorbaEnumHandler enumHandler) throws CorbaBindingException {
        Enum enumType = (Enum)enumHandler.getType();
        String enumLabel = enumHandler.getValue();
        List<Enumerator> enumerators = enumType.getEnumerator();
        for (int i = 0; i < enumerators.size(); ++i) {
            if (!enumerators.get(i).getValue().equals(enumLabel)) continue;
            this.stream.write_long(i);
            return;
        }
        throw new CorbaBindingException("CorbaObjectWriter: unable to find enumeration label");
    }

    public void writeStruct(CorbaStructHandler structHandler) throws CorbaBindingException {
        List<CorbaObjectHandler> structElements = structHandler.getMembers();
        for (int i = 0; i < structElements.size(); ++i) {
            this.write(structElements.get(i));
        }
    }

    public void writeException(CorbaExceptionHandler exHandler) throws CorbaBindingException {
        Exception exType = (Exception)exHandler.getType();
        List<CorbaObjectHandler> exMembers = exHandler.getMembers();
        this.stream.write_string(exType.getRepositoryID());
        for (int i = 0; i < exMembers.size(); ++i) {
            this.write(exMembers.get(i));
        }
    }

    public void writeFixed(CorbaFixedHandler fixedHandler) throws CorbaBindingException {
        short scale = (short)fixedHandler.getScale();
        short fixed = (short)fixedHandler.getDigits();
        try {
            Method m = this.stream.getClass().getMethod("write_fixed", BigDecimal.class, Short.TYPE, Short.TYPE);
            m.invoke((Object)this.stream, fixedHandler.getValue(), fixed, scale);
        }
        catch (Throwable e1) {
            this.stream.write_fixed(fixedHandler.getValue().movePointRight(scale));
        }
    }

    public void writeUnion(CorbaObjectHandler obj) throws CorbaBindingException {
        Union unionType = (Union)obj.getType();
        List<Unionbranch> branches = unionType.getUnionbranch();
        if (branches.size() > 0) {
            CorbaObjectHandler discriminator = ((CorbaUnionHandler)obj).getDiscriminator();
            this.write(discriminator);
            CorbaObjectHandler unionValue = ((CorbaUnionHandler)obj).getValue();
            if (unionValue != null) {
                this.write(unionValue);
            }
        }
    }

    public void writeArray(CorbaArrayHandler arrayHandler) throws CorbaBindingException {
        List<CorbaObjectHandler> arrayElements = arrayHandler.getElements();
        for (int i = 0; i < arrayElements.size(); ++i) {
            this.write(arrayElements.get(i));
        }
    }

    public void writeSequence(CorbaObjectHandler obj) throws CorbaBindingException {
        if (obj instanceof CorbaOctetSequenceHandler) {
            byte[] value = ((CorbaOctetSequenceHandler)obj).getValue();
            this.stream.write_ulong(value.length);
            this.stream.write_octet_array(value, 0, value.length);
        } else {
            CorbaSequenceHandler seqHandler = (CorbaSequenceHandler)obj;
            List<CorbaObjectHandler> seqElements = seqHandler.getElements();
            int length = seqElements.size();
            this.stream.write_ulong(length);
            for (int i = 0; i < length; ++i) {
                this.write(seqElements.get(i));
            }
        }
    }

    public void writeObjectReference(CorbaObjectReferenceHandler objHandler) throws CorbaBindingException {
        this.stream.write_Object(objHandler.getReference());
    }
}

