/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JStaxInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.policy.WSSPolicyException;
import org.apache.wss4j.stax.ConfigurationConverter;
import org.apache.wss4j.stax.WSSec;
import org.apache.wss4j.stax.ext.OutboundWSSec;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.OutboundSecurityContext;
import org.apache.xml.security.stax.impl.OutboundSecurityContextImpl;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventListener;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;

public class WSS4JStaxOutInterceptor
extends AbstractWSS4JStaxInterceptor {
    public static final String WSS4J_ACTION_MAP = "wss4j.action.map";
    public static final String OUTPUT_STREAM_HOLDER = WSS4JStaxOutInterceptor.class.getName() + ".outputstream";
    private WSS4JStaxOutInterceptorInternal ending;
    private boolean mtomEnabled;

    public WSS4JStaxOutInterceptor(WSSSecurityProperties securityProperties) {
        this.setPhase("pre-stream");
        this.getBefore().add(StaxOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
        this.setSecurityProperties(securityProperties);
    }

    public WSS4JStaxOutInterceptor(Map<String, Object> props) {
        super(props);
        this.setPhase("pre-stream");
        this.getBefore().add(StaxOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    public boolean isAllowMTOM() {
        return this.mtomEnabled;
    }

    public void setAllowMTOM(boolean allowMTOM) {
        this.mtomEnabled = allowMTOM;
    }

    @Override
    public Object getProperty(Object msgContext, String key) {
        return super.getProperty(msgContext, key);
    }

    @Override
    public void handleMessage(SoapMessage mc) throws Fault {
        XMLStreamWriter newXMLStreamWriter;
        if (!this.mtomEnabled) {
            mc.put("mtom-enabled", (Object)false);
        }
        OutputStream os = mc.getContent(OutputStream.class);
        String encoding = this.getEncoding(mc);
        try {
            List requestSecurityEvents = (List)mc.getExchange().get(SecurityEvent.class.getName() + ".in");
            this.translateProperties(mc);
            HashMap<String, SecurityTokenProvider<OutboundSecurityToken>> outboundTokens = new HashMap<String, SecurityTokenProvider<OutboundSecurityToken>>();
            this.configureCallbackHandler(mc);
            this.configureProperties(mc, outboundTokens);
            OutboundWSSec outboundWSSec = null;
            WSSSecurityProperties secProps = null;
            secProps = this.getSecurityProperties() != null ? this.getSecurityProperties() : ConfigurationConverter.convert(this.getProperties());
            if ((secProps.getOutAction() == null || secProps.getOutAction().length == 0) && mc.get(AssertionInfoMap.class) != null) {
                return;
            }
            SecurityEventListener securityEventListener = this.configureSecurityEventListener(mc, secProps);
            outboundWSSec = WSSec.getOutboundWSSec((WSSSecurityProperties)secProps);
            OutboundSecurityContextImpl outboundSecurityContext = new OutboundSecurityContextImpl();
            outboundSecurityContext.putList(SecurityEvent.class, requestSecurityEvents);
            outboundSecurityContext.addSecurityEventListener(securityEventListener);
            for (String key : outboundTokens.keySet()) {
                SecurityTokenProvider provider = (SecurityTokenProvider)outboundTokens.get(key);
                outboundSecurityContext.registerSecurityTokenProvider(provider.getId(), provider);
                outboundSecurityContext.put(key, (Object)provider.getId());
            }
            newXMLStreamWriter = outboundWSSec.processOutMessage((Object)os, encoding, (OutboundSecurityContext)outboundSecurityContext);
            mc.setContent(XMLStreamWriter.class, newXMLStreamWriter);
        }
        catch (WSSecurityException e) {
            throw new Fault(e);
        }
        catch (WSSPolicyException e) {
            throw new Fault(e);
        }
        mc.put("disable.outputstream.optimization", (Object)Boolean.TRUE);
        mc.put("org.apache.cxf.stax.force-start-document", (Object)Boolean.TRUE);
        if (MessageUtils.getContextualBoolean(mc, "org.apache.cxf.stax.force-start-document", false)) {
            try {
                newXMLStreamWriter.writeStartDocument(encoding, "1.0");
            }
            catch (XMLStreamException e) {
                throw new Fault(e);
            }
            mc.removeContent(OutputStream.class);
            mc.put(OUTPUT_STREAM_HOLDER, (Object)os);
        }
        mc.getInterceptorChain().add(this.ending);
    }

    protected SecurityEventListener configureSecurityEventListener(final SoapMessage msg, WSSSecurityProperties securityProperties) throws WSSPolicyException {
        final LinkedList outgoingSecurityEventList = new LinkedList();
        SecurityEventListener securityEventListener = new SecurityEventListener(){

            public void registerSecurityEvent(SecurityEvent securityEvent) throws XMLSecurityException {
                if (securityEvent.getSecurityEventType() == WSSecurityEventConstants.SamlToken && securityEvent instanceof TokenSecurityEvent) {
                    TokenSecurityEvent tokenSecurityEvent = (TokenSecurityEvent)securityEvent;
                    WSS4JUtils.parseAndStoreStreamingSecurityToken(tokenSecurityEvent.getSecurityToken(), msg);
                } else {
                    outgoingSecurityEventList.add(securityEvent);
                }
            }
        };
        msg.getExchange().put(SecurityEvent.class.getName() + ".out", outgoingSecurityEventList);
        msg.put(SecurityEvent.class.getName() + ".out", (Object)outgoingSecurityEventList);
        return securityEventListener;
    }

    protected void configureProperties(SoapMessage msg, Map<String, SecurityTokenProvider<OutboundSecurityToken>> outboundTokens) throws WSSecurityException {
        Map<String, Object> config = this.getProperties();
        if (config != null) {
            Crypto encCrypto;
            Crypto sigCrypto;
            String encUser;
            String sigUser;
            String user = (String)msg.getContextualProperty("ws-security.username");
            if (user != null) {
                config.put("user", user);
            }
            if ((sigUser = (String)msg.getContextualProperty("ws-security.signature.username")) != null) {
                config.put("signatureUser", sigUser);
            }
            if ((encUser = (String)msg.getContextualProperty("ws-security.encryption.username")) != null) {
                config.put("encryptionUser", encUser);
            }
            if ((sigCrypto = this.loadCrypto(msg, "signaturePropFile", "signaturePropRefId")) != null) {
                config.put("signaturePropRefId", "RefId-" + sigCrypto.hashCode());
                config.put("RefId-" + sigCrypto.hashCode(), sigCrypto);
                if (sigUser == null && sigCrypto.getDefaultX509Identifier() != null) {
                    config.put("signatureUser", sigCrypto.getDefaultX509Identifier());
                }
            }
            if ((encCrypto = this.loadCrypto(msg, "encryptionPropFile", "encryptionPropRefId")) != null) {
                config.put("encryptionPropRefId", "RefId-" + encCrypto.hashCode());
                config.put("RefId-" + encCrypto.hashCode(), encCrypto);
                if (encUser == null && encCrypto.getDefaultX509Identifier() != null) {
                    config.put("encryptionUser", encCrypto.getDefaultX509Identifier());
                }
            }
        }
    }

    public final WSS4JStaxOutInterceptorInternal createEndingInterceptor() {
        return new WSS4JStaxOutInterceptorInternal();
    }

    private String getEncoding(Message message) {
        Exchange ex = message.getExchange();
        String encoding = (String)message.get(Message.ENCODING);
        if (encoding == null && ex.getInMessage() != null) {
            encoding = (String)ex.getInMessage().get(Message.ENCODING);
            message.put(Message.ENCODING, encoding);
        }
        if (encoding == null) {
            encoding = "UTF-8";
            message.put(Message.ENCODING, encoding);
        }
        return encoding;
    }

    final class WSS4JStaxOutInterceptorInternal
    extends AbstractPhaseInterceptor<Message> {
        public WSS4JStaxOutInterceptorInternal() {
            super("pre-stream-ending");
            this.getAfter().add(AttachmentOutInterceptor.AttachmentOutEndingInterceptor.class.getName());
        }

        @Override
        public void handleMessage(Message mc) throws Fault {
            try {
                OutputStream os;
                XMLStreamWriter xtw = mc.getContent(XMLStreamWriter.class);
                if (xtw != null) {
                    xtw.writeEndDocument();
                    xtw.flush();
                    xtw.close();
                }
                if ((os = (OutputStream)mc.get(OUTPUT_STREAM_HOLDER)) != null) {
                    mc.setContent(OutputStream.class, os);
                }
                mc.removeContent(XMLStreamWriter.class);
            }
            catch (XMLStreamException e) {
                throw new Fault(e);
            }
        }
    }
}

