/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.StaxSecurityContextInInterceptor;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;

public class PolicyStaxActionInInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public PolicyStaxActionInInterceptor() {
        super("pre-protocol");
        this.getBefore().add(StaxSecurityContextInInterceptor.class.getName());
    }

    @Override
    public void handleMessage(SoapMessage soapMessage) throws Fault {
        AssertionInfoMap aim = soapMessage.get(AssertionInfoMap.class);
        List incomingSecurityEventList = (List)soapMessage.get(SecurityEvent.class.getName() + ".in");
        if (aim == null || incomingSecurityEventList == null) {
            return;
        }
        this.assertAllSecurityAssertions(aim);
        this.assertAllAlgorithmSuites("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", aim);
        this.assertAllAlgorithmSuites("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", aim);
    }

    private void assertAllSecurityAssertions(AssertionInfoMap aim) {
        for (QName key : aim.keySet()) {
            Collection ais;
            if (!"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(key.getNamespaceURI()) && !"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702".equals(key.getNamespaceURI()) && !"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200802".equals(key.getNamespaceURI()) || (ais = (Collection)aim.get(key)) == null || ais.isEmpty()) continue;
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
    }

    private void assertAllAlgorithmSuites(String spNamespace, AssertionInfoMap aim) {
        Collection sp11Ais = (Collection)aim.get(new QName(spNamespace, "AlgorithmSuite"));
        if (sp11Ais != null) {
            for (AssertionInfo ai : sp11Ais) {
                Collection algAis;
                ai.setAsserted(true);
                AlgorithmSuite algorithmSuite = (AlgorithmSuite)ai.getAssertion();
                AlgorithmSuite.AlgorithmSuiteType algorithmSuiteType = algorithmSuite.getAlgorithmSuiteType();
                String namespace = algorithmSuiteType.getNamespace();
                if (namespace == null) {
                    namespace = spNamespace;
                }
                if ((algAis = (Collection)aim.get(new QName(namespace, algorithmSuiteType.getName()))) == null) continue;
                for (AssertionInfo algAi : algAis) {
                    algAi.setAsserted(true);
                }
            }
        }
    }
}

