/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.io.Writer;
import java.util.List;
import javax.jws.HandlerChain;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HandlerConfigGenerator
extends AbstractJAXWSGenerator {
    private static final String HANDLER_CHAIN_NAME = "";
    private JavaInterface intf;
    private JAnnotation handlerChainAnnotation;

    public HandlerConfigGenerator() {
        this.name = "handler.generator";
    }

    public JAnnotation getHandlerAnnotation() {
        return this.handlerChainAnnotation;
    }

    @Override
    public boolean passthrough() {
        return false;
    }

    public void setJavaInterface(JavaInterface javaInterface) {
        this.intf = javaInterface;
    }

    @Override
    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        if (this.passthrough()) {
            return;
        }
        Element e = this.intf.getHandlerChains();
        List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(e, "http://java.sun.com/xml/ns/javaee", "handler-chain");
        if (elemList.size() > 0) {
            String fName = ProcessorUtil.getHandlerConfigFileName(this.intf.getName());
            this.handlerChainAnnotation = new JAnnotation(HandlerChain.class);
            this.handlerChainAnnotation.addElement(new JAnnotationElement("name", HANDLER_CHAIN_NAME));
            this.handlerChainAnnotation.addElement(new JAnnotationElement("file", fName + ".xml"));
            this.generateHandlerChainFile(e, this.parseOutputName(this.intf.getPackageName(), fName, ".xml"));
        }
    }

    private void generateHandlerChainFile(Element hChains, Writer writer) throws ToolException {
        try {
            StaxUtils.writeTo((Node)hChains, writer, 2);
            writer.close();
        }
        catch (Exception ex) {
            throw new ToolException(ex);
        }
    }
}

