/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.wsdl;

import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.service.model.ServiceSchemaInfo;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.corba.common.ProcessorEnvironment;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;

public class WSDLToProcessor
implements Processor {
    protected static final Logger LOG = LogUtils.getL7dLogger(WSDLToProcessor.class);
    protected Definition wsdlDefinition;
    protected ServiceSchemaInfo schemas;
    protected ToolContext toolContext;
    private ProcessorEnvironment env;

    @Override
    public void setEnvironment(ToolContext toolCtx) {
        this.toolContext = toolCtx;
    }

    public void parseWSDL(String wsdlUrl) {
        try {
            Bus bus = BusFactory.getThreadDefaultBus();
            WSDLManager mgr = bus.getExtension(WSDLManager.class);
            this.wsdlDefinition = mgr.getDefinition(wsdlUrl);
            WSDLServiceBuilder builder = new WSDLServiceBuilder(bus);
            builder.buildMockServices(this.wsdlDefinition);
            this.schemas = mgr.getSchemasForDefinition(this.wsdlDefinition);
            mgr.removeDefinition(this.wsdlDefinition);
        }
        catch (WSDLException we) {
            Message msg = new Message("FAIL_TO_CREATE_WSDL_DEFINITION", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)we);
        }
    }

    @Override
    public void process() throws ToolException {
        if (this.env == null) {
            this.env = new ProcessorEnvironment();
            this.env.put("wsdlurl", this.wsdlDefinition.getDocumentBaseURI());
        }
    }

    public Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    public void setWSDLDefinition(Definition definition) {
        this.wsdlDefinition = definition;
    }

    public SchemaCollection getXmlSchemaTypes() {
        return this.schemas.getSchemaCollection();
    }

    public void setEnvironment(ProcessorEnvironment environement) {
        this.env = environement;
    }

    public ProcessorEnvironment getEnvironment() {
        return this.env;
    }
}

