/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ReaderInterceptorMBR;
import org.apache.cxf.jaxrs.impl.WriterInterceptorMBW;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.FilterProviderInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.DataSourceProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.provider.MultipartProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public abstract class ProviderFactory {
    public static final String DEFAULT_FILTER_NAME_BINDING = "org.apache.cxf.filter.binding";
    public static final String PROVIDER_SELECTION_PROPERTY_CHANGED = "provider.selection.property.changed";
    protected static final String SERVER_FACTORY_NAME = "org.apache.cxf.jaxrs.provider.ServerProviderFactory";
    protected static final String CLIENT_FACTORY_NAME = "org.apache.cxf.jaxrs.client.ClientProviderFactory";
    protected static final String IGNORE_TYPE_VARIABLES = "org.apache.cxf.jaxrs.providers.ignore.typevars";
    private static final String ACTIVE_JAXRS_PROVIDER_KEY = "active.jaxrs.provider";
    private static final Logger LOG = LogUtils.getL7dLogger(ProviderFactory.class);
    private static final String JAXB_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.JAXBElementProvider";
    private static final String JSON_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.json.JSONProvider";
    private static final String BUS_PROVIDERS_ALL = "org.apache.cxf.jaxrs.bus.providers";
    protected Map<NameKey, ProviderInfo<ReaderInterceptor>> readerInterceptors = new NameKeyMap<ProviderInfo<ReaderInterceptor>>(true);
    protected Map<NameKey, ProviderInfo<WriterInterceptor>> writerInterceptors = new NameKeyMap<ProviderInfo<WriterInterceptor>>(true);
    private Configuration dynamicConfiguration;
    private List<ProviderInfo<MessageBodyReader<?>>> messageReaders = new ArrayList();
    private List<ProviderInfo<MessageBodyWriter<?>>> messageWriters = new ArrayList();
    private List<ProviderInfo<ContextResolver<?>>> contextResolvers = new ArrayList(1);
    private List<ProviderInfo<ContextProvider<?>>> contextProviders = new ArrayList(1);
    private Set<ParamConverterProvider> newParamConverters;
    private Collection<ProviderInfo<?>> injectedProviders = new LinkedList();
    private Bus bus;
    private ProviderFactory baseFactory;

    protected ProviderFactory(ProviderFactory baseFactory, Bus bus) {
        this.baseFactory = baseFactory;
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus;
    }

    protected ProviderFactory getBaseFactory() {
        return this.baseFactory;
    }

    protected boolean isBaseFactory() {
        return this.baseFactory == null;
    }

    protected static void initBaseFactory(ProviderFactory factory) {
        factory.setProviders(new BinaryDataProvider(), new SourceProvider(), new DataSourceProvider(), new FormEncodingProvider(), new PrimitiveTextProvider(), ProviderFactory.createProvider(JAXB_PROVIDER_NAME), ProviderFactory.createProvider(JSON_PROVIDER_NAME), new MultipartProvider());
    }

    protected static Object createProvider(String className) {
        try {
            return ClassLoaderUtils.loadClass(className, ProviderFactory.class).newInstance();
        }
        catch (Throwable ex) {
            String message = "Problem with creating the default provider " + className;
            message = ex.getMessage() != null ? message + ": " + ex.getMessage() : message + ", exception class : " + ex.getClass().getName();
            LOG.fine(message);
            return null;
        }
    }

    public void setDynamicConfiguration(Configuration config) {
        this.dynamicConfiguration = config;
    }

    public Configuration getDynamicConfiguration() {
        return this.dynamicConfiguration;
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m) {
        Message responseMessage;
        boolean isRequestor = MessageUtils.isRequestor(m);
        Message requestMessage = isRequestor ? m.getExchange().getOutMessage() : m.getExchange().getInMessage();
        HttpHeadersImpl requestHeaders = new HttpHeadersImpl(requestMessage);
        MediaType mt = null;
        Message message = responseMessage = isRequestor ? m.getExchange().getInMessage() : m.getExchange().getOutMessage();
        if (responseMessage != null) {
            Object ctProperty = responseMessage.get("Content-Type");
            if (ctProperty == null) {
                List accepts = requestHeaders.getAcceptableMediaTypes();
                if (accepts.size() > 0) {
                    mt = (MediaType)accepts.get(0);
                }
            } else {
                mt = JAXRSUtils.toMediaType(ctProperty.toString());
            }
        } else {
            mt = requestHeaders.getMediaType();
        }
        return this.createContextResolver(contextType, m, mt == null ? MediaType.WILDCARD_TYPE : mt);
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m, MediaType type) {
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            return null;
        }
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ContextResolver<?>> cr : this.contextResolvers) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                List<MediaType> mTypes;
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls) || JAXRSUtils.intersectMimeTypes(mTypes = JAXRSUtils.getProduceTypes(cr.getProvider().getClass().getAnnotation(Produces.class)), type).size() <= 0) continue;
                this.injectContextValues(cr, m);
                candidates.add(cr.getProvider());
            }
        }
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return (ContextResolver)candidates.get(0);
        }
        Collections.sort(candidates, new ClassComparator());
        return new ContextResolverProxy(candidates);
    }

    public <T> ContextProvider<T> createContextProvider(Type contextType, Message m) {
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            return null;
        }
        for (ProviderInfo<ContextProvider<?>> cr : this.contextProviders) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls)) continue;
                return cr.getProvider();
            }
        }
        return null;
    }

    public <T> ParamConverter<T> createParameterHandler(Class<T> paramType) {
        if (this.newParamConverters != null) {
            for (ParamConverterProvider newParamConverter : this.newParamConverters) {
                ParamConverter converter = newParamConverter.getConverter(paramType, null, null);
                if (converter == null) continue;
                return converter;
            }
        }
        return null;
    }

    protected <T> void handleMapper(List<T> candidates, ProviderInfo<T> em, Class<?> expectedType, Message m, Class<?> providerClass, boolean injectContext) {
        Class<?> mapperClass = ClassHelper.getRealClass(em.getProvider());
        Type[] types = null;
        types = m != null && MessageUtils.isTrue(m.getContextualProperty(IGNORE_TYPE_VARIABLES)) ? new Type[]{mapperClass} : ProviderFactory.getGenericInterfaces(mapperClass, expectedType);
        for (Type t : types) {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type arg = args[i];
                    if (arg instanceof TypeVariable) {
                        TypeVariable var = (TypeVariable)arg;
                        Type[] bounds = var.getBounds();
                        boolean isResolved = false;
                        for (int j = 0; j < bounds.length; ++j) {
                            Class<?> cls = InjectionUtils.getRawType(bounds[j]);
                            if (cls == null || !cls.isAssignableFrom(expectedType)) continue;
                            isResolved = true;
                            break;
                        }
                        if (!isResolved) {
                            return;
                        }
                        if (injectContext) {
                            this.injectContextValues(em, m);
                        }
                        candidates.add(em.getProvider());
                        return;
                    }
                    Class<?> actualClass = InjectionUtils.getRawType(arg);
                    if (actualClass == null) continue;
                    if (expectedType.isArray() && !actualClass.isArray()) {
                        expectedType = expectedType.getComponentType();
                    }
                    if (!actualClass.isAssignableFrom(expectedType) && actualClass != Object.class) continue;
                    if (injectContext) {
                        this.injectContextValues(em, m);
                    }
                    candidates.add(em.getProvider());
                    return;
                }
                continue;
            }
            if (!(t instanceof Class) || !providerClass.isAssignableFrom((Class)t)) continue;
            if (injectContext) {
                this.injectContextValues(em, m);
            }
            candidates.add(em.getProvider());
        }
    }

    public <T> List<ReaderInterceptor> createMessageBodyReaderInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, boolean checkMbrNow, Set<String> names) {
        MessageBodyReader<T> mr = !checkMbrNow ? null : this.createMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
        int size = this.readerInterceptors.size();
        if (mr != null || size > 0) {
            ReaderInterceptorMBR mbrReader = new ReaderInterceptorMBR(mr, m.getExchange().getInMessage());
            List<ReaderInterceptor> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<ReaderInterceptor>(size + 1);
                List<ProviderInfo<T>> readers = ProviderFactory.getBoundFilters(this.readerInterceptors, names);
                for (ProviderInfo<T> p : readers) {
                    InjectionUtils.injectContexts(p.getProvider(), p, m);
                    interceptors.add((ReaderInterceptor)p.getProvider());
                }
                interceptors.add(mbrReader);
            } else {
                interceptors = Collections.singletonList(mbrReader);
            }
            return interceptors;
        }
        return null;
    }

    public <T> List<WriterInterceptor> createMessageBodyWriterInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, Set<String> names) {
        MessageBodyWriter<T> mw = this.createMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
        int size = this.writerInterceptors.size();
        if (mw != null || size > 0) {
            WriterInterceptorMBW mbwWriter = new WriterInterceptorMBW(mw, m);
            List<WriterInterceptor> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<WriterInterceptor>(size + 1);
                List<ProviderInfo<T>> writers = ProviderFactory.getBoundFilters(this.writerInterceptors, names);
                for (ProviderInfo<T> p : writers) {
                    InjectionUtils.injectContexts(p.getProvider(), p, m);
                    interceptors.add((WriterInterceptor)p.getProvider());
                }
                interceptors.add(mbwWriter);
            } else {
                interceptors = Collections.singletonList(mbwWriter);
            }
            return interceptors;
        }
        return null;
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyReader<T> mr = this.chooseMessageReader(this.messageReaders, bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mr != null || this.isBaseFactory()) {
            return mr;
        }
        return this.baseFactory.createMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyWriter<T> mw = this.chooseMessageWriter(this.messageWriters, bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mw != null || this.isBaseFactory()) {
            return mw;
        }
        return this.baseFactory.createMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
    }

    protected void setBusProviders() {
        LinkedList<Object> extensions = new LinkedList<Object>();
        String alreadySetProp = "bus.providers.set";
        if (this.bus.getProperty("bus.providers.set") == null) {
            this.addBusExtension(extensions, MessageBodyReader.class, MessageBodyWriter.class, ExceptionMapper.class);
            if (!extensions.isEmpty()) {
                this.setProviders(extensions.toArray());
                this.bus.setProperty("bus.providers.set", "");
            }
        }
    }

    private void addBusExtension(List<Object> extensions, Class<?> ... extClasses) {
        for (Class<?> extClass : extClasses) {
            Object ext = this.bus.getProperty(extClass.getName());
            if (!extClass.isInstance(ext)) continue;
            extensions.add(ext);
        }
        Object allProp = this.bus.getProperty(BUS_PROVIDERS_ALL);
        if (allProp instanceof List) {
            List all = (List)allProp;
            extensions.addAll(all);
        }
    }

    protected abstract void setProviders(Object ... var1);

    protected void setCommonProviders(List<ProviderInfo<? extends Object>> theProviders) {
        LinkedList readInts = new LinkedList();
        LinkedList writeInts = new LinkedList();
        for (ProviderInfo<? extends Object> provider : theProviders) {
            Class<?> providerCls = ClassHelper.getRealClass(provider.getProvider());
            if (MessageBodyReader.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.messageReaders, provider);
            }
            if (MessageBodyWriter.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.messageWriters, provider);
            }
            if (ContextResolver.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.contextResolvers, provider);
            }
            if (ContextProvider.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.contextProviders, provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, ReaderInterceptor.class)) {
                readInts.add(provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, WriterInterceptor.class)) {
                writeInts.add(provider);
            }
            if (!ParamConverterProvider.class.isAssignableFrom(providerCls)) continue;
            Object converter = provider.getProvider();
            if (this.newParamConverters == null) {
                this.newParamConverters = new LinkedHashSet<ParamConverterProvider>();
            }
            this.newParamConverters.add((ParamConverterProvider)converter);
        }
        this.sortReaders();
        this.sortWriters();
        this.sortContextResolvers();
        ProviderFactory.mapInterceptorFilters(this.readerInterceptors, readInts, ReaderInterceptor.class, true);
        ProviderFactory.mapInterceptorFilters(this.writerInterceptors, writeInts, WriterInterceptor.class, true);
        this.injectContextProxies(this.messageReaders, this.messageWriters, this.contextResolvers, this.readerInterceptors.values(), this.writerInterceptors.values());
    }

    protected void injectContextValues(ProviderInfo<?> pi, Message m) {
        if (m != null) {
            InjectionUtils.injectContexts(pi.getProvider(), pi, m);
        }
    }

    protected void addProviderToList(List<?> list, ProviderInfo<?> provider) {
        List<ProviderInfo> list2 = CastUtils.cast(list);
        for (ProviderInfo pi : list2) {
            if (pi.getProvider().getClass() != provider.getProvider().getClass()) continue;
            return;
        }
        list2.add(provider);
    }

    protected void injectContextProxies(Collection<?> ... providerLists) {
        for (Collection<?> list : providerLists) {
            Collection<ProviderInfo> l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                this.injectContextProxiesIntoProvider(pi);
            }
        }
    }

    protected void injectContextProxiesIntoProvider(ProviderInfo<?> pi) {
        this.injectContextProxiesIntoProvider(pi, null);
    }

    void injectContextProxiesIntoProvider(ProviderInfo<?> pi, Application app) {
        if (pi.contextsAvailable()) {
            InjectionUtils.injectContextProxiesAndApplication(pi, pi.getProvider(), app);
            this.injectedProviders.add(pi);
        }
    }

    private void sortReaders() {
        Collections.sort(this.messageReaders, new MessageBodyReaderComparator());
    }

    private void sortWriters() {
        Collections.sort(this.messageWriters, new MessageBodyWriterComparator());
    }

    private void sortContextResolvers() {
        Collections.sort(this.contextResolvers, new ContextResolverComparator());
    }

    private <T> MessageBodyReader<T> chooseMessageReader(List<ProviderInfo<MessageBodyReader<?>>> readers, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<MessageBodyReader<?>> ep : readers) {
            if (!this.matchesReaderCriterias(ep, type, genericType, annotations, mediaType, m)) continue;
            if (this.isBaseFactory()) {
                return ep.getProvider();
            }
            this.handleMapper(candidates, ep, type, m, MessageBodyReader.class, false);
            if (candidates.isEmpty()) continue;
            break;
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (MessageBodyReader)candidates.get(0);
    }

    private <T> boolean matchesReaderCriterias(ProviderInfo<MessageBodyReader<?>> pi, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        boolean matches;
        MessageBodyReader<?> ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderConsumeTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes, false);
        if (availableMimeTypes.size() == 0) {
            return false;
        }
        boolean injected = false;
        if (m.get(ACTIVE_JAXRS_PROVIDER_KEY) != ep) {
            this.injectContextValues(pi, m);
            injected = true;
        }
        if (!(matches = ep.isReadable(type, genericType, annotations, mediaType)) && injected) {
            pi.clearThreadLocalProxies();
        }
        return matches;
    }

    private <T> MessageBodyWriter<T> chooseMessageWriter(List<ProviderInfo<MessageBodyWriter<?>>> writers, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<MessageBodyWriter<?>> ep : writers) {
            if (!this.matchesWriterCriterias(ep, type, genericType, annotations, mediaType, m)) continue;
            if (this.isBaseFactory()) {
                return ep.getProvider();
            }
            this.handleMapper(candidates, ep, type, m, MessageBodyWriter.class, false);
            if (candidates.isEmpty()) continue;
            break;
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (MessageBodyWriter)candidates.get(0);
    }

    private <T> boolean matchesWriterCriterias(ProviderInfo<MessageBodyWriter<?>> pi, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        boolean matches;
        MessageBodyWriter<?> ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderProduceTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes, false);
        if (availableMimeTypes.size() == 0) {
            return false;
        }
        boolean injected = false;
        if (m.get(ACTIVE_JAXRS_PROVIDER_KEY) != ep) {
            this.injectContextValues(pi, m);
            injected = true;
        }
        if (!(matches = ep.isWriteable(type, genericType, annotations, mediaType)) && injected) {
            pi.clearThreadLocalProxies();
        }
        return matches;
    }

    List<ProviderInfo<MessageBodyReader<?>>> getMessageReaders() {
        return Collections.unmodifiableList(this.messageReaders);
    }

    List<ProviderInfo<MessageBodyWriter<?>>> getMessageWriters() {
        return Collections.unmodifiableList(this.messageWriters);
    }

    List<ProviderInfo<ContextResolver<?>>> getContextResolvers() {
        return Collections.unmodifiableList(this.contextResolvers);
    }

    public void registerUserProvider(Object provider) {
        this.setUserProviders(Collections.singletonList(provider));
    }

    public void setUserProviders(List<?> userProviders) {
        this.setProviders(userProviders.toArray());
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.injectedProviders);
        if (this.baseFactory != null) {
            this.baseFactory.clearThreadLocalProxies();
        }
    }

    void clearProxies(Collection<?> ... lists) {
        for (Collection<?> list : lists) {
            Collection<ProviderInfo> l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                pi.clearThreadLocalProxies();
            }
        }
    }

    public void clearProviders() {
        this.messageReaders.clear();
        this.messageWriters.clear();
        this.contextResolvers.clear();
        this.contextProviders.clear();
        this.readerInterceptors.clear();
        this.writerInterceptors.clear();
    }

    public void setBus(Bus bus) {
        if (bus == null) {
            return;
        }
        for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
            this.injectProviderProperty(r.getProvider(), "setBus", Bus.class, bus);
        }
    }

    private boolean injectProviderProperty(Object provider, String mName, Class<?> pClass, Object pValue) {
        try {
            Method m = provider.getClass().getMethod(mName, pClass);
            m.invoke(provider, pValue);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setSchemaLocations(List<String> schemas) {
        boolean schemasMethodAvailable = false;
        for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
            schemasMethodAvailable = this.injectProviderProperty(r.getProvider(), "setSchemaLocations", List.class, schemas);
        }
        if (!schemasMethodAvailable) {
            this.setProviders(ProviderFactory.createProvider(JAXB_PROVIDER_NAME), ProviderFactory.createProvider(JSON_PROVIDER_NAME));
            for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
                this.injectProviderProperty(r.getProvider(), "setSchemaLocations", List.class, schemas);
            }
        }
    }

    protected static <T> List<ProviderInfo<T>> getBoundFilters(Map<NameKey, ProviderInfo<T>> boundFilters, Set<String> names) {
        if (boundFilters.isEmpty()) {
            return Collections.emptyList();
        }
        names = names == null ? Collections.emptySet() : names;
        MetadataMap map = new MetadataMap();
        for (Map.Entry<NameKey, ProviderInfo<T>> entry : boundFilters.entrySet()) {
            FilterProviderInfo fpi;
            String entryName = entry.getKey().getName();
            ProviderInfo<T> provider = entry.getValue();
            if (entryName.equals(DEFAULT_FILTER_NAME_BINDING)) {
                map.put(provider, Collections.emptyList());
                continue;
            }
            if (provider instanceof FilterProviderInfo && (fpi = (FilterProviderInfo)provider).isDynamic() && !names.containsAll(fpi.getNameBinding())) continue;
            map.add(provider, entryName);
        }
        LinkedList<ProviderInfo<T>> list = new LinkedList<ProviderInfo<T>>();
        for (Map.Entry entry : map.entrySet()) {
            List values = (List)entry.getValue();
            if (!names.containsAll(values)) continue;
            ProviderInfo provider = (ProviderInfo)entry.getKey();
            list.add(provider);
        }
        return list;
    }

    public void initProviders(List<ClassResourceInfo> cris) {
        Set<Object> set = this.getReadersWriters();
        for (Object o : set) {
            Object provider = ((ProviderInfo)o).getProvider();
            if (!(provider instanceof AbstractConfigurableProvider)) continue;
            ((AbstractConfigurableProvider)provider).init(cris);
        }
        if (!this.isBaseFactory()) {
            this.baseFactory.initProviders(cris);
        }
    }

    Set<Object> getReadersWriters() {
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(this.messageReaders);
        set.addAll(this.messageWriters);
        return set;
    }

    public static ProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().get(Endpoint.class);
        Message outM = m.getExchange().getOutMessage();
        boolean isClient = outM != null && MessageUtils.isRequestor(outM);
        String name = isClient ? CLIENT_FACTORY_NAME : SERVER_FACTORY_NAME;
        return (ProviderFactory)e.get(name);
    }

    protected static int compareClasses(Object o1, Object o2) {
        return ProviderFactory.compareClasses(null, o1, o2);
    }

    protected static int compareClasses(Class<?> expectedCls, Object o1, Object o2) {
        Class<?> realClass2;
        Class<?> cl1 = ClassHelper.getRealClass(o1);
        Class<?> cl2 = ClassHelper.getRealClass(o2);
        Type[] types1 = ProviderFactory.getGenericInterfaces(cl1, expectedCls);
        Type[] types2 = ProviderFactory.getGenericInterfaces(cl2, expectedCls);
        if (types1.length == 0 && types2.length > 0) {
            return 1;
        }
        if (types1.length > 0 && types2.length == 0) {
            return -1;
        }
        Class<?> realClass1 = InjectionUtils.getActualType(types1[0]);
        if (realClass1 == (realClass2 = InjectionUtils.getActualType(types2[0]))) {
            return 0;
        }
        if (realClass1.isAssignableFrom(realClass2)) {
            return 1;
        }
        return -1;
    }

    private static Type[] getGenericInterfaces(Class<?> cls, Class<?> expectedClass) {
        Type genericSuperType;
        if (Object.class == cls) {
            return new Type[0];
        }
        if (expectedClass != null && (genericSuperType = cls.getGenericSuperclass()) instanceof ParameterizedType && expectedClass == InjectionUtils.getActualType(genericSuperType)) {
            return new Type[]{genericSuperType};
        }
        Type[] types = cls.getGenericInterfaces();
        if (types.length > 0) {
            return types;
        }
        return ProviderFactory.getGenericInterfaces(cls.getSuperclass(), expectedClass);
    }

    protected ProviderInfo<? extends Object> createProviderFromConstructor(Constructor<?> c, Map<Class<?>, Object> values) {
        Object[] cArgs = ResourceUtils.createConstructorArguments(c, null, false, values);
        Object instance = null;
        try {
            instance = c.newInstance(cArgs);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Resource or provider class " + c.getDeclaringClass().getName() + " can not be instantiated");
        }
        HashMap proxies = new HashMap();
        Class<?>[] paramTypes = c.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!(cArgs[i] instanceof ThreadLocalProxy)) continue;
            ThreadLocalProxy proxy = (ThreadLocalProxy)cArgs[i];
            proxies.put(paramTypes[i], proxy);
        }
        return new ProviderInfo<Object>(instance, proxies, this.getBus());
    }

    protected static <T> void mapInterceptorFilters(Map<NameKey, ProviderInfo<T>> map, List<ProviderInfo<T>> filters, Class<?> providerCls, boolean ascending) {
        for (ProviderInfo<T> p : filters) {
            Set<String> names = ProviderFactory.getFilterNameBindings(p);
            int priority = ProviderFactory.getFilterPriority(p, providerCls);
            for (String name : names) {
                map.put(new NameKey(name, priority, p.getClass()), p);
            }
        }
    }

    protected static Set<String> getFilterNameBindings(ProviderInfo<?> p) {
        Set<String> names = null;
        if (p instanceof FilterProviderInfo) {
            names = ((FilterProviderInfo)p).getNameBinding();
        }
        if (names == null) {
            names = AnnotationUtils.getNameBindings(p.getProvider().getClass().getAnnotations());
        }
        if (names.isEmpty()) {
            names = Collections.singleton(DEFAULT_FILTER_NAME_BINDING);
        }
        return names;
    }

    protected static int getFilterPriority(ProviderInfo<?> p, Class<?> providerCls) {
        return p instanceof FilterProviderInfo ? ((FilterProviderInfo)p).getPriority(providerCls) : AnnotationUtils.getBindingPriority(p.getProvider().getClass());
    }

    protected static boolean filterContractSupported(ProviderInfo<?> provider, Class<?> providerCls, Class<?> contract) {
        boolean result = false;
        if (contract.isAssignableFrom(providerCls)) {
            Set<Class<?>> actualContracts = null;
            if (provider instanceof FilterProviderInfo) {
                actualContracts = ((FilterProviderInfo)provider).getSupportedContracts();
            }
            result = actualContracts != null ? actualContracts.contains(contract) : true;
        }
        return result;
    }

    protected List<ProviderInfo<? extends Object>> prepareProviders(Object[] providers, ProviderInfo<Application> application) {
        ArrayList<ProviderInfo<? extends Object>> theProviders = new ArrayList<ProviderInfo<? extends Object>>(providers.length);
        for (Object o : providers) {
            if (o == null) continue;
            if (o instanceof Constructor) {
                Map<Class<?>, Object> values = CastUtils.cast(application == null ? null : Collections.singletonMap(Application.class, application.getProvider()));
                theProviders.add(this.createProviderFromConstructor((Constructor)o, values));
                continue;
            }
            if (o instanceof ProviderInfo) {
                theProviders.add((ProviderInfo)o);
                continue;
            }
            theProviders.add(new ProviderInfo<Object>(o, this.getBus()));
        }
        return theProviders;
    }

    public MessageBodyWriter<?> getRegisteredJaxbWriter() {
        for (ProviderInfo<MessageBodyWriter<?>> pi : this.messageWriters) {
            Class<?> cls = pi.getProvider().getClass();
            if (!cls.getName().equals(JAXB_PROVIDER_NAME) && !cls.getSuperclass().getName().equals(JAXB_PROVIDER_NAME)) continue;
            return pi.getProvider();
        }
        return null;
    }

    protected static class NameKeyMap<T>
    extends TreeMap<NameKey, T> {
        private static final long serialVersionUID = -4352258671270502204L;

        public NameKeyMap(boolean ascending) {
            super(new NameKeyComparator(ascending));
        }
    }

    protected static class NameKeyComparator
    extends AbstractPriorityComparator
    implements Comparator<NameKey> {
        public NameKeyComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(NameKey key1, NameKey key2) {
            int result = this.compare(key1.getPriority(), key2.getPriority());
            if (result != 0) {
                return result;
            }
            return this.compare(key1.hashCode(), key2.hashCode());
        }
    }

    protected static class NameKey {
        private String name;
        private Integer priority;
        private Class<?> providerCls;

        public NameKey(String name, int priority, Class<?> providerCls) {
            this.name = name;
            this.priority = priority;
            this.providerCls = providerCls;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NameKey)) {
                return false;
            }
            NameKey other = (NameKey)o;
            return this.name.equals(other.name) && this.priority.equals(other.priority) && this.providerCls == other.providerCls;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.name + ":" + this.priority;
        }
    }

    static class ContextResolverProxy<T>
    implements ContextResolver<T> {
        private List<ContextResolver<T>> candidates;

        public ContextResolverProxy(List<ContextResolver<T>> candidates) {
            this.candidates = candidates;
        }

        public T getContext(Class<?> cls) {
            for (ContextResolver<T> resolver : this.candidates) {
                Object context = resolver.getContext(cls);
                if (context == null) continue;
                return (T)context;
            }
            return null;
        }

        public List<ContextResolver<T>> getResolvers() {
            return this.candidates;
        }
    }

    protected static class BindingPriorityComparator
    extends AbstractPriorityComparator
    implements Comparator<ProviderInfo<?>> {
        private Class<?> providerCls;

        public BindingPriorityComparator(Class<?> providerCls, boolean ascending) {
            super(ascending);
            this.providerCls = providerCls;
        }

        @Override
        public int compare(ProviderInfo<?> p1, ProviderInfo<?> p2) {
            return this.compare(ProviderFactory.getFilterPriority(p1, this.providerCls), ProviderFactory.getFilterPriority(p2, this.providerCls));
        }
    }

    protected static class AbstractPriorityComparator {
        private boolean ascending;

        protected AbstractPriorityComparator(boolean ascending) {
            this.ascending = ascending;
        }

        protected int compare(Integer b1Value, Integer b2Value) {
            int result = b1Value.compareTo(b2Value);
            return this.ascending ? result : result * -1;
        }
    }

    public static class ClassComparator
    implements Comparator<Object> {
        private Class<?> expectedCls;

        public ClassComparator() {
        }

        public ClassComparator(Class<?> expectedCls) {
            this.expectedCls = expectedCls;
        }

        @Override
        public int compare(Object em1, Object em2) {
            return ProviderFactory.compareClasses(this.expectedCls, em1, em2);
        }
    }

    private static class ContextResolverComparator
    implements Comparator<ProviderInfo<ContextResolver<?>>> {
        private ContextResolverComparator() {
        }

        @Override
        public int compare(ProviderInfo<ContextResolver<?>> p1, ProviderInfo<ContextResolver<?>> p2) {
            ContextResolver<?> e1 = p1.getProvider();
            ContextResolver<?> e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e1.getClass().getAnnotation(Produces.class)), "qs");
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e2.getClass().getAnnotation(Produces.class)), "qs");
            return JAXRSUtils.compareSortedMediaTypes(types1, types2, "qs");
        }
    }

    private static class MessageBodyWriterComparator
    implements Comparator<ProviderInfo<MessageBodyWriter<?>>> {
        private MessageBodyWriterComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyWriter<?>> p1, ProviderInfo<MessageBodyWriter<?>> p2) {
            MessageBodyWriter<?> e2;
            MessageBodyWriter<?> e1 = p1.getProvider();
            int result = ProviderFactory.compareClasses(e1, e2 = p2.getProvider());
            if (result != 0) {
                return result;
            }
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e1), "qs");
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e2), "qs");
            return JAXRSUtils.compareSortedMediaTypes(types1, types2, "qs");
        }
    }

    private static class MessageBodyReaderComparator
    implements Comparator<ProviderInfo<MessageBodyReader<?>>> {
        private MessageBodyReaderComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyReader<?>> p1, ProviderInfo<MessageBodyReader<?>> p2) {
            MessageBodyReader<?> e2;
            MessageBodyReader<?> e1 = p1.getProvider();
            int result = ProviderFactory.compareClasses(e1, e2 = p2.getProvider());
            if (result != 0) {
                return result;
            }
            List<MediaType> types1 = JAXRSUtils.getProviderConsumeTypes(e1);
            types1 = JAXRSUtils.sortMediaTypes(types1, null);
            List<MediaType> types2 = JAXRSUtils.getProviderConsumeTypes(e2);
            types2 = JAXRSUtils.sortMediaTypes(types2, null);
            return JAXRSUtils.compareSortedMediaTypes(types1, types2, null);
        }
    }
}

