/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.JaxrsClientCallback;
import org.apache.cxf.jaxrs.client.LocalClientState;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ParameterizedCollectionType;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class WebClient
extends AbstractClient {
    private static final String REQUEST_CLASS = "request.class";
    private static final String REQUEST_TYPE = "request.type";
    private static final String REQUEST_ANNS = "request.annotations";
    private static final String RESPONSE_CLASS = "response.class";
    private static final String RESPONSE_TYPE = "response.type";

    protected WebClient(String baseAddress) {
        this(WebClient.convertStringToURI(baseAddress));
    }

    protected WebClient(URI baseURI) {
        this(new LocalClientState(baseURI));
    }

    protected WebClient(ClientState state) {
        super(state);
        this.cfg.getInInterceptors().add(new ClientAsyncResponseInterceptor());
    }

    public static WebClient create(String baseAddress) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(baseAddress);
        return bean.createWebClient();
    }

    public static WebClient create(URI baseURI) {
        return WebClient.create(baseURI.toString());
    }

    public static WebClient create(String baseURI, boolean threadSafe) {
        return WebClient.create(baseURI, Collections.emptyList(), threadSafe);
    }

    public static WebClient create(String baseAddress, List<?> providers) {
        return WebClient.create(baseAddress, providers, null);
    }

    public static WebClient create(String baseAddress, List<?> providers, boolean threadSafe) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, null);
        bean.setProviders(providers);
        if (threadSafe) {
            bean.setInitialState(new ThreadLocalClientState(baseAddress));
        }
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setProviders(providers);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, List<?> providers, List<? extends Feature> features, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setProviders(providers);
        bean.setFeatures(features);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setUsername(username);
        bean.setPassword(password);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, List<?> providers, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setUsername(username);
        bean.setPassword(password);
        bean.setProviders(providers);
        return bean.createWebClient();
    }

    public static WebClient fromClient(Client client) {
        return WebClient.fromClient(client, false);
    }

    public static WebClient fromClient(Client client, boolean inheritHeaders) {
        WebClient webClient = null;
        ClientState clientState = WebClient.getClientState(client);
        if (clientState == null) {
            webClient = WebClient.create(client.getCurrentURI());
            if (inheritHeaders) {
                webClient.headers((MultivaluedMap)client.getHeaders());
            }
        } else {
            MultivaluedMap<String, String> headers = inheritHeaders ? client.getHeaders() : null;
            webClient = new WebClient(clientState.newState(client.getCurrentURI(), headers, null));
        }
        WebClient.copyProperties(webClient, client);
        return webClient;
    }

    public static Client client(Object object) {
        if (object instanceof Client) {
            return (Client)object;
        }
        return null;
    }

    public static ClientConfiguration getConfig(Object client) {
        if (client instanceof Client) {
            if (client instanceof WebClient) {
                return ((AbstractClient)client).getConfiguration();
            }
            if (client instanceof InvocationHandlerAware) {
                Object handler = ((InvocationHandlerAware)client).getInvocationHandler();
                return ((AbstractClient)handler).getConfiguration();
            }
        }
        throw new IllegalArgumentException("Not a valid Client");
    }

    public Response invoke(String httpMethod, Object body) {
        return this.doInvoke(httpMethod, body, null, Response.class, (Type)((Object)Response.class));
    }

    public Response post(Object body) {
        return this.invoke("POST", body);
    }

    public Response put(Object body) {
        return this.invoke("PUT", body);
    }

    public Response get() {
        return this.invoke("GET", null);
    }

    public Response head() {
        return this.invoke("HEAD", null);
    }

    public Response options() {
        return this.invoke("OPTIONS", null);
    }

    public Response delete() {
        return this.invoke("DELETE", null);
    }

    public Response form(Map<String, List<Object>> values) {
        this.type("application/x-www-form-urlencoded");
        return this.doInvoke("POST", values, null, Response.class, (Type)((Object)Response.class));
    }

    public Response form(Form form) {
        this.type("application/x-www-form-urlencoded");
        return this.doInvoke("POST", form.asMap(), null, Response.class, (Type)((Object)Response.class));
    }

    public <T> T invoke(String httpMethod, Object body, GenericType<T> responseType) {
        Class responseClass = responseType.getRawType();
        Response r = this.doInvoke(httpMethod, body, null, responseClass, responseType.getType());
        return responseClass.cast(responseClass == Response.class ? r : r.getEntity());
    }

    public <T> T invoke(String httpMethod, Object body, Class<T> responseClass) {
        Response r = this.doInvoke(httpMethod, body, null, responseClass, responseClass);
        return responseClass.cast(responseClass == Response.class ? r : r.getEntity());
    }

    public <T> T invoke(String httpMethod, Object body, Class<?> requestClass, Class<T> responseClass) {
        Response r = this.doInvoke(httpMethod, body, requestClass, null, responseClass, responseClass);
        return responseClass.cast(responseClass == Response.class ? r : r.getEntity());
    }

    public <T> T post(Object body, Class<T> responseClass) {
        return this.invoke("POST", body, responseClass);
    }

    public <T> T post(Object body, GenericType<T> responseType) {
        return this.invoke("POST", body, responseType);
    }

    public <T> Future<T> post(Object body, InvocationCallback<T> callback) {
        return this.doInvokeAsyncCallback("POST", body, body.getClass(), null, callback);
    }

    public <T> T put(Object body, Class<T> responseClass) {
        return this.invoke("PUT", body, responseClass);
    }

    public <T> T put(Object body, GenericType<T> responseType) {
        return this.invoke("PUT", body, responseType);
    }

    public <T> Future<T> put(Object body, InvocationCallback<T> callback) {
        return this.doInvokeAsyncCallback("PUT", body, body.getClass(), null, callback);
    }

    public <T> Collection<? extends T> invokeAndGetCollection(String httpMethod, Object body, Class<T> memberClass) {
        Response r = this.doInvoke(httpMethod, body, null, Collection.class, new ParameterizedCollectionType(memberClass));
        return CastUtils.cast((Collection)r.getEntity(), memberClass);
    }

    public <T> Response postCollection(Object collection, Class<T> memberClass) {
        return this.doInvoke("POST", collection, new ParameterizedCollectionType(memberClass), Response.class, (Type)((Object)Response.class));
    }

    public <T1, T2> T2 postCollection(Object collection, Class<T1> memberClass, Class<T2> responseClass) {
        Response r = this.doInvoke("POST", collection, new ParameterizedCollectionType(memberClass), responseClass, responseClass);
        return responseClass.cast(responseClass == Response.class ? r : r.getEntity());
    }

    public <T1, T2> Collection<? extends T2> postAndGetCollection(Object collection, Class<T1> memberClass, Class<T2> responseClass) {
        Response r = this.doInvoke("POST", collection, new ParameterizedCollectionType(memberClass), Collection.class, new ParameterizedCollectionType(responseClass));
        return CastUtils.cast((Collection)r.getEntity(), responseClass);
    }

    public <T> Collection<? extends T> postObjectGetCollection(Object body, Class<T> responseClass) {
        Response r = this.doInvoke("POST", body, null, Collection.class, new ParameterizedCollectionType(responseClass));
        return CastUtils.cast((Collection)r.getEntity(), responseClass);
    }

    public <T> Collection<? extends T> postAndGetCollection(Object body, Class<T> memberClass) {
        return this.invokeAndGetCollection("POST", body, memberClass);
    }

    public <T> Collection<? extends T> getCollection(Class<T> memberClass) {
        return this.invokeAndGetCollection("GET", null, memberClass);
    }

    public <T> T get(Class<T> responseClass) {
        return this.invoke("GET", null, responseClass);
    }

    public <T> T get(GenericType<T> responseType) {
        return this.invoke("GET", null, responseType);
    }

    public <T> Future<T> get(InvocationCallback<T> callback) {
        return this.doInvokeAsyncCallback("GET", null, null, null, callback);
    }

    public WebClient path(Object path) {
        this.getCurrentBuilder().path(this.convertParamValue(path));
        return this;
    }

    public WebClient path(String path, Object ... values) {
        URI u = new UriBuilderImpl().uri(URI.create("http://tempuri")).path(path).buildFromEncoded(values);
        this.getState().setTemplates(this.getTemplateParametersMap(new URITemplate(path), Arrays.asList(values)));
        return this.path(u.getRawPath());
    }

    @Override
    public WebClient query(String name, Object ... values) {
        return (WebClient)super.query(name, values);
    }

    public WebClient matrix(String name, Object ... values) {
        this.addMatrixQueryParamsToBuilder(this.getCurrentBuilder(), name, ParameterType.MATRIX, values);
        return this;
    }

    public WebClient fragment(String name) {
        this.getCurrentBuilder().fragment(name);
        return this;
    }

    public WebClient to(String newAddress, boolean forward) {
        this.getState().setTemplates(null);
        if (forward) {
            if (!newAddress.startsWith(this.getBaseURI().toString())) {
                throw new IllegalArgumentException("Base address can not be preserved");
            }
            this.resetCurrentBuilder(URI.create(newAddress));
        } else {
            this.resetBaseAddress(URI.create(newAddress));
        }
        return this;
    }

    public WebClient back(boolean fast) {
        this.getState().setTemplates(null);
        if (fast) {
            this.getCurrentBuilder().replacePath(this.getBaseURI().getPath());
        } else {
            URI uri = this.getCurrentURI();
            if (uri == this.getBaseURI()) {
                return this;
            }
            List<PathSegment> segments = JAXRSUtils.getPathSegments(uri.getPath(), false);
            this.getCurrentBuilder().replacePath(null);
            for (int i = 0; i < segments.size() - 1; ++i) {
                this.getCurrentBuilder().path(HttpUtils.fromPathSegment(segments.get(i)));
            }
        }
        return this;
    }

    public WebClient replacePath(String path) {
        if (path == null) {
            return this.back(true);
        }
        this.back(path.startsWith("/"));
        return this.path(path);
    }

    public WebClient resetQuery() {
        return this.replaceQuery(null);
    }

    public WebClient replaceQuery(String queryString) {
        this.getCurrentBuilder().replaceQuery(queryString);
        return this;
    }

    public WebClient replaceHeader(String headerName, String value) {
        MultivaluedMap<String, String> headers = this.getState().getRequestHeaders();
        headers.remove((Object)headerName);
        if (value != null) {
            headers.add((Object)headerName, (Object)value);
        }
        return this;
    }

    public WebClient replaceQueryParam(String queryParam, Object ... value) {
        this.getCurrentBuilder().replaceQueryParam(queryParam, value);
        return this;
    }

    @Override
    public WebClient type(MediaType ct) {
        return (WebClient)super.type(ct);
    }

    @Override
    public WebClient type(String type) {
        return (WebClient)super.type(type);
    }

    @Override
    public WebClient accept(MediaType ... types) {
        return (WebClient)super.accept(types);
    }

    @Override
    public WebClient accept(String ... types) {
        return (WebClient)super.accept(types);
    }

    @Override
    public WebClient language(String language) {
        return (WebClient)super.language(language);
    }

    @Override
    public WebClient acceptLanguage(String ... languages) {
        return (WebClient)super.acceptLanguage(languages);
    }

    @Override
    public WebClient encoding(String encoding) {
        return (WebClient)super.encoding(encoding);
    }

    @Override
    public WebClient acceptEncoding(String ... encodings) {
        return (WebClient)super.acceptEncoding(encodings);
    }

    @Override
    public WebClient match(EntityTag tag, boolean ifNot) {
        return (WebClient)super.match(tag, ifNot);
    }

    @Override
    public WebClient modified(Date date, boolean ifNot) {
        return (WebClient)super.modified(date, ifNot);
    }

    @Override
    public WebClient cookie(Cookie cookie) {
        return (WebClient)super.cookie(cookie);
    }

    @Override
    public WebClient header(String name, Object ... values) {
        return (WebClient)super.header(name, values);
    }

    @Override
    public WebClient headers(MultivaluedMap<String, String> map) {
        return (WebClient)super.headers(map);
    }

    @Override
    public WebClient reset() {
        return (WebClient)super.reset();
    }

    protected Response doInvoke(String httpMethod, Object body, Type inGenericType, Class<?> responseClass, Type outGenericType) {
        return this.doInvoke(httpMethod, body, body == null ? null : body.getClass(), inGenericType, responseClass, outGenericType);
    }

    protected Response doInvoke(String httpMethod, Object body, Class<?> requestClass, Type inGenericType, Class<?> responseClass, Type outGenericType) {
        Annotation[] inAnns = null;
        if (body instanceof Entity) {
            Entity entity = (Entity)body;
            this.setEntityHeaders(entity);
            body = entity.getEntity();
            requestClass = body.getClass();
            inGenericType = body.getClass();
            inAnns = entity.getAnnotations();
        }
        if (body instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)body;
            body = genericEntity.getEntity();
            requestClass = genericEntity.getRawType();
            inGenericType = genericEntity.getType();
        }
        MultivaluedMap<String, String> headers = this.prepareHeaders(responseClass, body);
        this.resetResponse();
        Response r = this.doChainedInvocation(httpMethod, headers, body, requestClass, inGenericType, inAnns, responseClass, outGenericType, null, null);
        if (r.getStatus() >= 300 && responseClass != Response.class) {
            throw this.convertToWebApplicationException(r);
        }
        return r;
    }

    private ParameterizedType findCallbackType(Class<?> cls) {
        if (cls == null || cls == Object.class) {
            return null;
        }
        for (Type c2 : cls.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(c2 instanceof ParameterizedType) || !InvocationCallback.class.equals((Object)(pt = (ParameterizedType)c2).getRawType())) continue;
            return pt;
        }
        return this.findCallbackType(cls.getSuperclass());
    }

    private Type getCallbackType(InvocationCallback<?> callback) {
        int i$ = 0;
        Class<?> cls = callback.getClass();
        ParameterizedType pt = this.findCallbackType(cls);
        Type[] arr$ = pt.getActualTypeArguments();
        int len$ = arr$.length;
        if (i$ < len$) {
            Type tp = arr$[i$];
            return tp;
        }
        return null;
    }

    protected <T> Future<T> doInvokeAsyncCallback(String httpMethod, Object body, Class<?> requestClass, Type inType, InvocationCallback<T> callback) {
        ParameterizedType pt;
        Class<?> outType = this.getCallbackType(callback);
        Class respClass = null;
        if (outType instanceof Class) {
            respClass = outType;
        } else if (outType instanceof ParameterizedType && (pt = (ParameterizedType)((Object)outType)).getRawType() instanceof Class) {
            respClass = (Class)pt.getRawType();
            outType = InjectionUtils.getActualType(pt);
        }
        return this.doInvokeAsync(httpMethod, body, requestClass, inType, respClass, outType, callback);
    }

    protected <T> Future<T> doInvokeAsync(String httpMethod, Object body, Class<?> requestClass, Type inType, Class<?> respClass, Type outType, InvocationCallback<T> callback) {
        Annotation[] inAnns = null;
        if (body instanceof Entity) {
            Entity entity = (Entity)body;
            this.setEntityHeaders(entity);
            body = entity.getEntity();
            requestClass = body.getClass();
            inType = body.getClass();
            inAnns = entity.getAnnotations();
        }
        if (body instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)body;
            body = genericEntity.getEntity();
            requestClass = genericEntity.getRawType();
            inType = genericEntity.getType();
        }
        MultivaluedMap<String, String> headers = this.prepareHeaders(respClass, body);
        this.resetResponse();
        Message m = this.finalizeMessage(httpMethod, headers, body, requestClass, inType, inAnns, respClass, outType, null, null);
        m.getExchange().setSynchronous(false);
        JaxrsClientCallback<T> cb = new JaxrsClientCallback<T>(callback, respClass, outType);
        m.getExchange().put(JaxrsClientCallback.class, cb);
        this.doRunInterceptorChain(m);
        Future<T> future = cb.createFuture();
        if (m.getExchange().get(Exception.class) != null) {
            Throwable ex = m.getExchange().get(Exception.class);
            if (ex instanceof Fault) {
                ex = ex.getCause();
            }
            cb.handleException(m, ex);
        }
        return future;
    }

    private MultivaluedMap<String, String> prepareHeaders(Class<?> responseClass, Object body) {
        boolean contentTypeNotSet;
        MultivaluedMap<String, String> headers = this.getHeaders();
        boolean bl = contentTypeNotSet = headers.getFirst((Object)"Content-Type") == null;
        if (contentTypeNotSet) {
            String ct = "*/*";
            if (body != null) {
                ct = body instanceof Form ? "application/x-www-form-urlencoded" : "application/xml";
            }
            headers.putSingle((Object)"Content-Type", (Object)ct);
        }
        if (responseClass != null && responseClass != Response.class && headers.getFirst((Object)"Accept") == null) {
            headers.putSingle((Object)"Accept", (Object)JAXRSUtils.mediaTypeToString(MediaType.APPLICATION_XML_TYPE, new String[0]));
        }
        return headers;
    }

    private void handleAsyncResponse(Message message) {
        JaxrsClientCallback cb = message.getExchange().get(JaxrsClientCallback.class);
        Response r = null;
        try {
            Object[] results = this.preProcessResult(message);
            if (results != null && results.length == 1) {
                r = (Response)results[0];
            }
        }
        catch (Exception ex) {
            WebApplicationException t = ex instanceof WebApplicationException ? (WebApplicationException)((Object)ex) : (ex instanceof ProcessingException ? (ProcessingException)ex : new ProcessingException((Throwable)ex));
            cb.handleException(message, t);
            return;
        }
        if (r == null) {
            try {
                r = this.handleResponse(message.getExchange().getOutMessage(), cb.getResponseClass(), cb.getOutGenericType());
            }
            catch (Throwable t) {
                cb.handleException(message, t);
                return;
            }
        }
        if (cb.getResponseClass() == null || Response.class.equals(cb.getResponseClass())) {
            cb.handleResponse(message, new Object[]{r});
        } else if (r.getStatus() >= 300) {
            cb.handleException(message, this.convertToWebApplicationException(r));
        } else {
            cb.handleResponse(message, new Object[]{r.getEntity()});
            this.closeAsyncResponseIfPossible(r, message, cb);
        }
    }

    private void closeAsyncResponseIfPossible(Response r, Message outMessage, JaxrsClientCallback<?> cb) {
        if (this.responseStreamCanBeClosed(outMessage, cb.getResponseClass())) {
            r.close();
        }
    }

    private void handleAsyncFault(Message message) {
    }

    @Override
    protected Object retryInvoke(URI newRequestURI, MultivaluedMap<String, String> headers, Object body, Exchange exchange, Map<String, Object> invContext) throws Throwable {
        Map reqContext = CastUtils.cast((Map)invContext.get("RequestContext"));
        String httpMethod = (String)reqContext.get("org.apache.cxf.request.method");
        Class requestClass = (Class)reqContext.get(REQUEST_CLASS);
        Type inType = (Type)reqContext.get(REQUEST_TYPE);
        Annotation[] inAnns = (Annotation[])reqContext.get(REQUEST_ANNS);
        Class respClass = (Class)reqContext.get(RESPONSE_CLASS);
        Type outType = (Type)reqContext.get(RESPONSE_TYPE);
        return this.doChainedInvocation(httpMethod, headers, body, requestClass, inType, inAnns, respClass, outType, exchange, invContext);
    }

    protected Response doChainedInvocation(String httpMethod, MultivaluedMap<String, String> headers, Object body, Class<?> requestClass, Type inType, Annotation[] inAnns, Class<?> respClass, Type outType, Exchange exchange, Map<String, Object> invContext) {
        Message m = this.finalizeMessage(httpMethod, headers, body, requestClass, inType, inAnns, respClass, outType, exchange, invContext);
        this.doRunInterceptorChain(m);
        return this.doResponse(m, respClass, outType);
    }

    private Message finalizeMessage(String httpMethod, MultivaluedMap<String, String> headers, Object body, Class<?> requestClass, Type inGenericType, Annotation[] inAnns, Class<?> responseClass, Type outGenericType, Exchange exchange, Map<String, Object> invContext) {
        URI uri = this.getCurrentURI();
        Message m = this.createMessage(body, httpMethod, headers, uri, exchange, invContext, false);
        if (inAnns != null) {
            m.put(Annotation.class.getName(), inAnns);
        }
        Map<String, Object> reqContext = this.getRequestContext(m);
        reqContext.put("org.apache.cxf.request.method", httpMethod);
        reqContext.put(REQUEST_CLASS, requestClass);
        reqContext.put(REQUEST_TYPE, inGenericType);
        reqContext.put(REQUEST_ANNS, inAnns);
        reqContext.put(RESPONSE_CLASS, responseClass);
        reqContext.put(RESPONSE_TYPE, outGenericType);
        if (body != null) {
            m.put(Type.class, inGenericType);
            m.getInterceptorChain().add(new BodyWriter());
        }
        this.setPlainOperationNameProperty(m, httpMethod + ":" + uri.toString());
        return m;
    }

    protected Response doResponse(Message m, Class<?> responseClass, Type outGenericType) {
        try {
            Object[] results = this.preProcessResult(m);
            if (results != null && results.length == 1) {
                return (Response)results[0];
            }
        }
        catch (Exception ex) {
            throw ex instanceof WebApplicationException ? (WebApplicationException)((Object)ex) : (ex instanceof ProcessingException ? (ProcessingException)ex : new ProcessingException((Throwable)ex));
        }
        Response response = null;
        Object entity = null;
        try {
            response = this.handleResponse(m, responseClass, outGenericType);
            entity = response.getEntity();
            Response response2 = response;
            return response2;
        }
        catch (RuntimeException ex) {
            entity = ex;
            throw ex;
        }
        finally {
            this.completeExchange(entity, m.getExchange(), false);
        }
    }

    protected Response handleResponse(Message outMessage, Class<?> responseClass, Type genericType) {
        try {
            int status;
            Response.ResponseBuilder rb = this.setResponseBuilder(outMessage, outMessage.getExchange());
            Response currentResponse = rb.clone().build();
            ((ResponseImpl)currentResponse).setOutMessage(outMessage);
            Object entity = this.readBody(currentResponse, outMessage, responseClass, genericType, new Annotation[0]);
            if (entity == null && (status = currentResponse.getStatus()) >= 400) {
                entity = currentResponse.getEntity();
            }
            rb = JAXRSUtils.fromResponse(currentResponse);
            rb.entity(entity instanceof Response ? ((Response)entity).getEntity() : entity);
            Response r = rb.build();
            this.getState().setResponse(r);
            ((ResponseImpl)r).setOutMessage(outMessage);
            Response response = r;
            return response;
        }
        catch (Throwable ex) {
            throw ex instanceof ProcessingException ? (ProcessingException)ex : new ProcessingException(ex);
        }
        finally {
            ClientProviderFactory.getInstance(outMessage).clearThreadLocalProxies();
        }
    }

    static void copyProperties(Client toClient, Client fromClient) {
        AbstractClient newClient = WebClient.toAbstractClient(toClient);
        AbstractClient oldClient = WebClient.toAbstractClient(fromClient);
        newClient.setConfiguration(oldClient.getConfiguration());
    }

    private static AbstractClient toAbstractClient(Object client) {
        if (client instanceof AbstractClient) {
            return (AbstractClient)client;
        }
        return (AbstractClient)((InvocationHandlerAware)client).getInvocationHandler();
    }

    static JAXRSClientFactoryBean getBean(String baseAddress, String configLocation) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        if (configLocation != null) {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus(configLocation);
            bean.setBus(bus);
        }
        bean.setAddress(baseAddress);
        return bean;
    }

    static ClientState getClientState(Client client) {
        ClientState clientState = null;
        if (client instanceof WebClient) {
            clientState = ((AbstractClient)client).getState();
        } else if (client instanceof InvocationHandlerAware) {
            Object handler = ((InvocationHandlerAware)((Object)client)).getInvocationHandler();
            clientState = ((AbstractClient)handler).getState();
        }
        return clientState;
    }

    static URI convertStringToURI(String baseAddress) {
        try {
            return URI.create(baseAddress);
        }
        catch (RuntimeException ex) {
            if (baseAddress.startsWith("http")) {
                return new UriBuilderImpl().uriAsTemplate(baseAddress).build(new Object[0]);
            }
            throw ex;
        }
    }

    public AsyncInvoker async() {
        return new AsyncInvokerImpl();
    }

    public SyncInvoker sync() {
        return new SyncInvokerImpl();
    }

    private void setEntityHeaders(Entity<?> entity) {
        this.type(entity.getMediaType());
        if (entity.getLanguage() != null) {
            this.language(entity.getLanguage().toString());
        }
        if (entity.getEncoding() != null) {
            this.encoding(entity.getEncoding());
        }
    }

    class SyncInvokerImpl
    implements SyncInvoker {
        SyncInvokerImpl() {
        }

        public Response delete() {
            return this.method("DELETE");
        }

        public <T> T delete(Class<T> cls) {
            return this.method("DELETE", cls);
        }

        public <T> T delete(GenericType<T> genericType) {
            return this.method("DELETE", genericType);
        }

        public Response get() {
            return this.method("GET");
        }

        public <T> T get(Class<T> cls) {
            return this.method("GET", cls);
        }

        public <T> T get(GenericType<T> genericType) {
            return this.method("GET", genericType);
        }

        public Response head() {
            return this.method("HEAD");
        }

        public Response options() {
            return this.method("OPTIONS");
        }

        public <T> T options(Class<T> cls) {
            return this.method("OPTIONS", cls);
        }

        public <T> T options(GenericType<T> genericType) {
            return this.method("OPTIONS", genericType);
        }

        public Response post(Entity<?> entity) {
            return this.method("POST", entity);
        }

        public <T> T post(Entity<?> entity, Class<T> cls) {
            return this.method("POST", entity, cls);
        }

        public <T> T post(Entity<?> entity, GenericType<T> genericType) {
            return this.method("POST", genericType);
        }

        public Response put(Entity<?> entity) {
            return this.method("PUT", entity);
        }

        public <T> T put(Entity<?> entity, Class<T> cls) {
            return this.method("PUT", entity, cls);
        }

        public <T> T put(Entity<?> entity, GenericType<T> genericType) {
            return this.method("PUT", entity, genericType);
        }

        public Response trace() {
            return this.method("TRACE");
        }

        public <T> T trace(Class<T> cls) {
            return this.method("TRACE", cls);
        }

        public <T> T trace(GenericType<T> genericType) {
            return this.method("TRACE", genericType);
        }

        public Response method(String method) {
            return this.method(method, Response.class);
        }

        public <T> T method(String method, Class<T> cls) {
            return WebClient.this.invoke(method, null, cls);
        }

        public <T> T method(String method, GenericType<T> genericType) {
            return WebClient.this.invoke(method, null, genericType);
        }

        public Response method(String method, Entity<?> entity) {
            return this.method(method, entity, Response.class);
        }

        public <T> T method(String method, Entity<?> entity, Class<T> cls) {
            return WebClient.this.invoke(method, entity, cls);
        }

        public <T> T method(String method, Entity<?> entity, GenericType<T> genericType) {
            return WebClient.this.invoke(method, entity, genericType);
        }
    }

    class AsyncInvokerImpl
    implements AsyncInvoker {
        AsyncInvokerImpl() {
        }

        public Future<Response> get() {
            return this.get(Response.class);
        }

        public <T> Future<T> get(Class<T> responseType) {
            return this.method("GET", responseType);
        }

        public <T> Future<T> get(GenericType<T> responseType) {
            return this.method("GET", responseType);
        }

        public <T> Future<T> get(InvocationCallback<T> callback) {
            return this.method("GET", callback);
        }

        public Future<Response> put(Entity<?> entity) {
            return this.put(entity, Response.class);
        }

        public <T> Future<T> put(Entity<?> entity, Class<T> responseType) {
            return this.method("PUT", entity, responseType);
        }

        public <T> Future<T> put(Entity<?> entity, GenericType<T> responseType) {
            return this.method("PUT", entity, responseType);
        }

        public <T> Future<T> put(Entity<?> entity, InvocationCallback<T> callback) {
            return this.method("PUT", entity, callback);
        }

        public Future<Response> post(Entity<?> entity) {
            return this.post(entity, Response.class);
        }

        public <T> Future<T> post(Entity<?> entity, Class<T> responseType) {
            return this.method("POST", entity, responseType);
        }

        public <T> Future<T> post(Entity<?> entity, GenericType<T> responseType) {
            return this.method("POST", entity, responseType);
        }

        public <T> Future<T> post(Entity<?> entity, InvocationCallback<T> callback) {
            return this.method("POST", entity, callback);
        }

        public Future<Response> delete() {
            return this.delete(Response.class);
        }

        public <T> Future<T> delete(Class<T> responseType) {
            return this.method("DELETE", responseType);
        }

        public <T> Future<T> delete(GenericType<T> responseType) {
            return this.method("DELETE", responseType);
        }

        public <T> Future<T> delete(InvocationCallback<T> callback) {
            return this.method("DELETE", callback);
        }

        public Future<Response> head() {
            return this.method("HEAD");
        }

        public Future<Response> head(InvocationCallback<Response> callback) {
            return this.method("HEAD", callback);
        }

        public Future<Response> options() {
            return this.options(Response.class);
        }

        public <T> Future<T> options(Class<T> responseType) {
            return this.method("OPTIONS", responseType);
        }

        public <T> Future<T> options(GenericType<T> responseType) {
            return this.method("OPTIONS", responseType);
        }

        public <T> Future<T> options(InvocationCallback<T> callback) {
            return this.method("OPTIONS", callback);
        }

        public Future<Response> trace() {
            return this.trace(Response.class);
        }

        public <T> Future<T> trace(Class<T> responseType) {
            return this.method("TRACE", responseType);
        }

        public <T> Future<T> trace(GenericType<T> responseType) {
            return this.method("TRACE", responseType);
        }

        public <T> Future<T> trace(InvocationCallback<T> callback) {
            return this.method("TRACE", callback);
        }

        public Future<Response> method(String name) {
            return this.method(name, Response.class);
        }

        public <T> Future<T> method(String name, Class<T> responseType) {
            return WebClient.this.doInvokeAsync(name, null, null, null, responseType, responseType, null);
        }

        public <T> Future<T> method(String name, GenericType<T> responseType) {
            return WebClient.this.doInvokeAsync(name, null, null, null, responseType.getRawType(), responseType.getType(), null);
        }

        public <T> Future<T> method(String name, InvocationCallback<T> callback) {
            return WebClient.this.doInvokeAsyncCallback(name, null, null, null, callback);
        }

        public Future<Response> method(String name, Entity<?> entity) {
            return this.method(name, entity, Response.class);
        }

        public <T> Future<T> method(String name, Entity<?> entity, Class<T> responseType) {
            return WebClient.this.doInvokeAsync(name, entity, null, null, responseType, responseType, null);
        }

        public <T> Future<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
            return WebClient.this.doInvokeAsync(name, entity, null, null, responseType.getRawType(), responseType.getType(), null);
        }

        public <T> Future<T> method(String name, Entity<?> entity, InvocationCallback<T> callback) {
            return WebClient.this.doInvokeAsyncCallback(name, entity, null, null, callback);
        }
    }

    class ClientAsyncResponseInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public ClientAsyncResponseInterceptor() {
            super("unmarshal");
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            if (message.getExchange().isSynchronous()) {
                return;
            }
            WebClient.this.handleAsyncResponse(message);
        }

        @Override
        public void handleFault(Message message) {
            if (message.getExchange().isSynchronous()) {
                return;
            }
            WebClient.this.handleAsyncFault(message);
        }
    }

    private class BodyWriter
    extends AbstractClient.AbstractBodyWriter {
        private BodyWriter() {
        }

        @Override
        protected void doWriteBody(Message outMessage, Object body, Type bodyType, Annotation[] customAnns, OutputStream os) throws Fault {
            Map<String, Object> requestContext = WebClient.this.getRequestContext(outMessage);
            Class requestClass = null;
            Type requestType = null;
            if (requestContext != null) {
                requestClass = (Class)requestContext.get(WebClient.REQUEST_CLASS);
                requestType = (Type)requestContext.get(WebClient.REQUEST_TYPE);
            }
            if (bodyType != null) {
                requestType = bodyType;
            }
            Annotation[] anns = customAnns != null ? customAnns : new Annotation[]{};
            boolean isAssignable = requestClass != null && requestClass.isAssignableFrom(body.getClass());
            try {
                WebClient.this.writeBody(body, outMessage, requestClass == null || !isAssignable ? body.getClass() : requestClass, requestType == null || !isAssignable ? body.getClass() : requestType, anns, os);
            }
            catch (Exception ex) {
                throw new Fault(ex);
            }
        }
    }
}

