/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduit;
import org.apache.cxf.transport.http.asyncclient.CXFHttpRequest;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAuthCache;
import org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.http.client.protocol.RequestDefaultHeaders;
import org.apache.http.client.protocol.RequestProxyAuthentication;
import org.apache.http.client.protocol.RequestTargetAuthentication;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.impl.nio.DefaultHttpClientIODispatch;
import org.apache.http.impl.nio.client.DefaultHttpAsyncClient;
import org.apache.http.impl.nio.conn.DefaultClientAsyncConnection;
import org.apache.http.impl.nio.conn.PoolingClientAsyncConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.conn.ClientAsyncConnection;
import org.apache.http.nio.conn.ClientAsyncConnectionFactory;
import org.apache.http.nio.conn.ClientAsyncConnectionManager;
import org.apache.http.nio.conn.scheme.AsyncScheme;
import org.apache.http.nio.conn.scheme.AsyncSchemeRegistry;
import org.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;

@NoJSR250Annotations(unlessNull={"bus"})
public class AsyncHTTPConduitFactory
implements BusLifeCycleListener,
HTTPConduitFactory {
    public static final String TCP_NODELAY = "org.apache.cxf.transport.http.async.TCP_NODELAY";
    public static final String SO_KEEPALIVE = "org.apache.cxf.transport.http.async.SO_KEEPALIVE";
    public static final String SO_LINGER = "org.apache.cxf.transport.http.async.SO_LINGER";
    public static final String SO_TIMEOUT = "org.apache.cxf.transport.http.async.SO_TIMEOUT";
    public static final String MAX_CONNECTIONS = "org.apache.cxf.transport.http.async.MAX_CONNECTIONS";
    public static final String MAX_PER_HOST_CONNECTIONS = "org.apache.cxf.transport.http.async.MAX_PER_HOST_CONNECTIONS";
    public static final String CONNECTION_TTL = "org.apache.cxf.transport.http.async.CONNECTION_TTL";
    public static final String THREAD_COUNT = "org.apache.cxf.transport.http.async.ioThreadCount";
    public static final String INTEREST_OP_QUEUED = "org.apache.cxf.transport.http.async.interestOpQueued";
    public static final String SELECT_INTERVAL = "org.apache.cxf.transport.http.async.selectInterval";
    public static final String USE_POLICY = "org.apache.cxf.transport.http.async.usePolicy";
    final IOReactorConfig config = new IOReactorConfig();
    volatile ConnectingIOReactor ioReactor;
    volatile PoolingClientAsyncConnectionManager connectionManager;
    boolean isShutdown;
    UseAsyncPolicy policy;
    int maxConnections = 5000;
    int maxPerRoute = 1000;
    int connectionTTL = 60000;
    private final TargetAuthenticationStrategy targetAuthenticationStrategy = new TargetAuthenticationStrategy();
    private final ProxyAuthenticationStrategy proxyAuthenticationStrategy = new ProxyAuthenticationStrategy();
    private final BasicHttpProcessor httpproc = new BasicHttpProcessor();

    AsyncHTTPConduitFactory() {
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestDefaultHeaders());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestContent());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestClientConnControl());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestAuthCache());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestTargetAuthentication());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestProxyAuthentication());
    }

    public AsyncHTTPConduitFactory(Map<String, Object> conf) {
        this();
        this.config.setTcpNoDelay(true);
        this.setProperties(conf);
    }

    public AsyncHTTPConduitFactory(Bus b) {
        this();
        this.addListener(b);
        this.config.setTcpNoDelay(true);
        this.setProperties(b.getProperties());
    }

    public BasicHttpProcessor getDefaultHttpProcessor() {
        return this.httpproc;
    }

    public UseAsyncPolicy getUseAsyncPolicy() {
        return this.policy;
    }

    public void update(Map<String, Object> props) {
        if (this.setProperties(props) && this.ioReactor != null) {
            this.restartReactor();
        }
    }

    private void restartReactor() {
        ConnectingIOReactor ioReactor2 = this.ioReactor;
        PoolingClientAsyncConnectionManager connectionManager2 = this.connectionManager;
        this.resetVars();
        AsyncHTTPConduitFactory.shutdown(ioReactor2, connectionManager2);
    }

    private synchronized void resetVars() {
        this.ioReactor = null;
        this.connectionManager = null;
    }

    private boolean setProperties(Map<String, Object> s) {
        Object st = s.get(USE_POLICY);
        if (st == null) {
            st = SystemPropertyAction.getPropertyOrNull(USE_POLICY);
        }
        this.policy = st instanceof UseAsyncPolicy ? (UseAsyncPolicy)((Object)st) : (st instanceof String ? UseAsyncPolicy.valueOf((String)st) : UseAsyncPolicy.ASYNC_ONLY);
        this.maxConnections = this.getInt(s.get(MAX_CONNECTIONS), this.maxConnections);
        this.connectionTTL = this.getInt(s.get(CONNECTION_TTL), this.connectionTTL);
        this.maxPerRoute = this.getInt(s.get(MAX_PER_HOST_CONNECTIONS), this.maxPerRoute);
        if (this.connectionManager != null) {
            this.connectionManager.setMaxTotal(this.maxConnections);
            this.connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        }
        boolean changed = false;
        int i = this.config.getIoThreadCount();
        this.config.setIoThreadCount(this.getInt(s.get(THREAD_COUNT), Runtime.getRuntime().availableProcessors()));
        changed |= i != this.config.getIoThreadCount();
        long l = this.config.getSelectInterval();
        this.config.setSelectInterval((long)this.getInt(s.get(SELECT_INTERVAL), 1000));
        changed |= l != this.config.getSelectInterval();
        i = this.config.getSoLinger();
        this.config.setSoLinger(this.getInt(s.get(SO_LINGER), -1));
        changed |= i != this.config.getSoLinger();
        i = this.config.getSoTimeout();
        this.config.setSoTimeout(this.getInt(s.get(SO_TIMEOUT), 0));
        changed |= i != this.config.getSoTimeout();
        boolean b = this.config.isInterestOpQueued();
        this.config.setInterestOpQueued(this.getBoolean(s.get(INTEREST_OP_QUEUED), false));
        changed |= b != this.config.isInterestOpQueued();
        b = this.config.isTcpNoDelay();
        this.config.setTcpNoDelay(this.getBoolean(s.get(TCP_NODELAY), true));
        changed |= b != this.config.isTcpNoDelay();
        b = this.config.isSoKeepalive();
        this.config.setSoKeepalive(this.getBoolean(s.get(SO_KEEPALIVE), false));
        return changed |= b != this.config.isSoKeepalive();
    }

    private int getInt(Object s, int defaultv) {
        int i = defaultv;
        if (s instanceof String) {
            i = Integer.parseInt((String)s);
        } else if (s instanceof Number) {
            i = ((Number)s).intValue();
        }
        if (i == -1) {
            i = defaultv;
        }
        return i;
    }

    private boolean getBoolean(Object s, boolean defaultv) {
        if (s instanceof String) {
            return Boolean.parseBoolean((String)s);
        }
        if (s instanceof Boolean) {
            return (Boolean)s;
        }
        return defaultv;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public HTTPConduit createConduit(HTTPTransportFactory f, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        if (this.isShutdown) {
            return null;
        }
        return new AsyncHTTPConduit(f.getBus(), localInfo, target, this);
    }

    @Resource
    public void setBus(Bus b) {
        this.addListener(b);
    }

    @Override
    public void initComplete() {
    }

    @Override
    public synchronized void preShutdown() {
        this.shutdown();
    }

    @Override
    public void postShutdown() {
    }

    public void shutdown() {
        if (this.ioReactor != null) {
            AsyncHTTPConduitFactory.shutdown(this.ioReactor, this.connectionManager);
            this.connectionManager = null;
            this.ioReactor = null;
        }
        this.isShutdown = true;
    }

    private static void shutdown(ConnectingIOReactor ioReactor2, PoolingClientAsyncConnectionManager connectionManager2) {
        try {
            connectionManager2.shutdown();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            ioReactor2.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addListener(Bus b) {
        b.getExtension(BusLifeCycleManager.class).registerLifeCycleListener(this);
    }

    public synchronized void setupNIOClient() throws IOReactorException {
        if (this.connectionManager != null) {
            return;
        }
        DefaultHttpClientIODispatch ioEventDispatch = new DefaultHttpClientIODispatch((NHttpClientEventHandler)new HttpAsyncRequestExecutor(), (HttpParams)new BasicHttpParams());
        this.ioReactor = new DefaultConnectingIOReactor(this.config);
        Thread t = new Thread(new Runnable((IOEventDispatch)ioEventDispatch){
            final /* synthetic */ IOEventDispatch val$ioEventDispatch;
            {
                this.val$ioEventDispatch = iOEventDispatch;
            }

            @Override
            public void run() {
                try {
                    AsyncHTTPConduitFactory.this.ioReactor.execute(this.val$ioEventDispatch);
                }
                catch (InterruptedIOException ex) {
                    System.err.println("Interrupted");
                }
                catch (IOException e) {
                    System.err.println("I/O error: " + e.getMessage());
                }
            }
        });
        t.start();
        AsyncSchemeRegistry registry = new AsyncSchemeRegistry();
        registry.register(new AsyncScheme("http", 80, null));
        registry.register(new AsyncScheme("https", 443, null));
        this.connectionManager = new PoolingClientAsyncConnectionManager(this.ioReactor, registry, this.connectionTTL, TimeUnit.MILLISECONDS){

            protected ClientAsyncConnectionFactory createClientAsyncConnectionFactory() {
                DefaultHttpResponseFactory responseFactory = new DefaultHttpResponseFactory();
                HeapByteBufferAllocator allocator = new HeapByteBufferAllocator();
                return new ClientAsyncConnectionFactory((HttpResponseFactory)responseFactory, (ByteBufferAllocator)allocator){
                    final /* synthetic */ HttpResponseFactory val$responseFactory;
                    final /* synthetic */ ByteBufferAllocator val$allocator;
                    {
                        this.val$responseFactory = httpResponseFactory;
                        this.val$allocator = byteBufferAllocator;
                    }

                    public ClientAsyncConnection create(String id, IOSession iosession, HttpParams params) {
                        return new DefaultClientAsyncConnection(id, iosession, this.val$responseFactory, this.val$allocator, params){

                            protected void onRequestSubmitted(HttpRequest request) {
                                super.onRequestSubmitted(request);
                                if (request instanceof EntityEnclosingRequestWrapper) {
                                    request = ((EntityEnclosingRequestWrapper)request).getOriginal();
                                }
                                if (this.getIOSession() instanceof SSLIOSession) {
                                    SSLIOSession sslio = (SSLIOSession)this.getIOSession();
                                    this.getIOSession().setAttribute(CXFHttpRequest.class.getName(), (Object)request);
                                    if (this.getIOSession().getAttribute("cxf.handshake.done") != null) {
                                        ((CXFHttpRequest)request).getOutputStream().setSSLSession(sslio.getSSLSession());
                                    }
                                }
                            }
                        };
                    }
                };
            }
        };
        this.connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        this.connectionManager.setMaxTotal(this.maxConnections);
    }

    public DefaultHttpAsyncClient createClient(final AsyncHTTPConduit c) throws IOException {
        if (this.connectionManager == null) {
            this.setupNIOClient();
        }
        DefaultHttpAsyncClient dhac = new DefaultHttpAsyncClient((ClientAsyncConnectionManager)this.connectionManager){

            protected HttpParams createHttpParams() {
                SyncBasicHttpParams params = new SyncBasicHttpParams();
                HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
                HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
                int bufSize = c.getClient().getChunkLength() > 0 ? c.getClient().getChunkLength() : 16332;
                HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)bufSize);
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)((int)c.getClient().getConnectionTimeout()));
                return params;
            }

            protected BasicHttpProcessor createHttpProcessor() {
                return AsyncHTTPConduitFactory.this.httpproc;
            }
        };
        dhac.setRedirectStrategy(new RedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return false;
            }

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return null;
            }
        });
        dhac.setTargetAuthenticationStrategy((AuthenticationStrategy)this.targetAuthenticationStrategy);
        dhac.setProxyAuthenticationStrategy((AuthenticationStrategy)this.proxyAuthenticationStrategy);
        return dhac;
    }

    public static enum UseAsyncPolicy {
        ALWAYS,
        ASYNC_ONLY,
        NEVER;

    }
}

