/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.corba.common.idltypes.IdlArrayBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;

public final class IdlArray
extends IdlArrayBase {
    private static final Logger LOG = LogUtils.getL7dLogger(IdlArray.class);

    private IdlArray(IdlScopeBase parent, String name, IdlType elem, int size) {
        super(parent, name, elem, size);
    }

    public static IdlArray create(IdlScopeBase parent, String name, IdlType elem, int size) {
        return new IdlArray(parent, name, elem, size);
    }

    @Override
    public void write(PrintWriter pw) {
        IdlType elem = this.elemType();
        if (!elem.isEmptyDef()) {
            pw.print(IdlArray.indent() + "typedef " + elem.fullName(this.scopeName()) + " " + this.localName());
            super.write(pw);
            pw.println(";");
        } else {
            LOG.log(Level.WARNING, "Ignoring Array " + this.localName() + " with Empty Element Type.");
        }
    }
}

