/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.net.URI;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.services.RedirectionBasedGrantService;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@Path(value="/authorize-implicit")
public class ImplicitGrantService
extends RedirectionBasedGrantService {
    private boolean reportClientId;

    public ImplicitGrantService() {
        super("token", "implicit");
    }

    @Override
    protected Response createGrant(MultivaluedMap<String, String> params, Client client, String redirectUri, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        ServerAccessToken token = null;
        if (preAuthorizedToken == null) {
            AccessTokenRegistration reg = new AccessTokenRegistration();
            reg.setClient(client);
            reg.setGrantType("implicit");
            reg.setSubject(userSubject);
            reg.setRequestedScope(requestedScope);
            reg.setApprovedScope(approvedScope);
            reg.setAudience((String)params.getFirst((Object)"audience"));
            token = this.getDataProvider().createAccessToken(reg);
        } else {
            token = preAuthorizedToken;
        }
        String state = (String)params.getFirst((Object)"state");
        StringBuilder sb = this.getUriWithFragment(state, redirectUri);
        if (state != null) {
            sb.append("&");
        }
        sb.append("access_token").append("=").append(token.getTokenKey());
        sb.append("&").append("token_type").append("=").append(token.getTokenType());
        if (this.reportClientId) {
            sb.append("&").append("client_id").append("=").append(client.getClientId());
        }
        if (this.isWriteOptionalParameters()) {
            sb.append("&").append("expires_in").append("=").append(token.getExpiresIn());
            List<OAuthPermission> perms = token.getScopes();
            if (!perms.isEmpty()) {
                sb.append("&").append("scope").append("=").append(OAuthUtils.convertPermissionsToScope(perms));
            }
        }
        return Response.seeOther((URI)URI.create(sb.toString())).build();
    }

    @Override
    protected Response createErrorResponse(MultivaluedMap<String, String> params, String redirectUri, String error) {
        String state = (String)params.getFirst((Object)"state");
        StringBuilder sb = this.getUriWithFragment(state, redirectUri);
        if (state != null) {
            sb.append("&");
        }
        sb.append("error").append("=").append(error);
        return Response.seeOther((URI)URI.create(sb.toString())).build();
    }

    private StringBuilder getUriWithFragment(String state, String redirectUri) {
        StringBuilder sb = new StringBuilder();
        sb.append(redirectUri);
        sb.append("#");
        if (state != null) {
            sb.append("state").append("=").append(state);
        }
        return sb;
    }

    public void setReportClientId(boolean reportClientId) {
        this.reportClientId = reportClientId;
    }

    @Override
    protected boolean canSupportPublicClient(Client c) {
        return true;
    }

    @Override
    protected boolean canRedirectUriBeEmpty(Client c) {
        return false;
    }
}

