/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.refresh;

import java.util.LinkedList;
import java.util.List;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class RefreshToken
extends ServerAccessToken {
    private static final long serialVersionUID = 2837120382251693874L;
    private List<String> accessTokens = new LinkedList<String>();

    public RefreshToken(Client client, long lifetime) {
        super(client, "refresh", OAuthUtils.generateRandomTokenKey(), lifetime, System.currentTimeMillis() / 1000L);
    }

    public RefreshToken(Client client, String tokenKey, long lifetime, long issuedAt) {
        super(client, "refresh", tokenKey, lifetime, issuedAt);
    }

    public List<String> getAccessTokens() {
        return this.accessTokens;
    }

    public void setAccessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
    }

    public void addAccessToken(String token) {
        this.accessTokens.add(token);
    }

    public boolean removeAccessToken(String token) {
        return this.accessTokens.remove(token);
    }
}

