/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.security;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.transport.http.auth.AbstractSpnegoAuthSupplier;

public class KerberosAuthOutInterceptor
extends AbstractSpnegoAuthSupplier
implements PhaseInterceptor<Message> {
    private String phase = "marshal";
    private AuthorizationPolicy policy;

    public KerberosAuthOutInterceptor() {
    }

    public KerberosAuthOutInterceptor(String phase) {
        this.phase = phase;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        URI currentURI = this.getCurrentURI(message);
        String value = super.getAuthorization(this.getPolicy(), currentURI, message);
        Map headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (headers == null) {
            headers = new HashMap();
            message.put(Message.PROTOCOL_HEADERS, headers);
        }
        headers.put("Authorization", Collections.singletonList(value));
    }

    private URI getCurrentURI(Message message) {
        try {
            return new URI((String)message.get(Message.ENDPOINT_ADDRESS));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleFault(Message message) {
    }

    @Override
    public Set<String> getAfter() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getBefore() {
        return Collections.emptySet();
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return Collections.emptySet();
    }

    public AuthorizationPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(AuthorizationPolicy policy) {
        this.policy = policy;
    }
}

