/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rt.security.xacml;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rt.security.xacml.DefaultXACMLRequestBuilder;
import org.apache.cxf.rt.security.xacml.XACMLRequestBuilder;
import org.apache.cxf.security.LoginSecurityContext;
import org.apache.cxf.security.SecurityContext;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.ctx.ResultType;

public abstract class AbstractXACMLAuthorizingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractXACMLAuthorizingInterceptor.class);
    private XACMLRequestBuilder requestBuilder = new DefaultXACMLRequestBuilder();

    public AbstractXACMLAuthorizingInterceptor() {
        super("pre-invoke");
        OpenSAMLUtil.initSamlEngine();
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        SecurityContext sc = message.get(SecurityContext.class);
        if (sc instanceof LoginSecurityContext) {
            Principal principal = sc.getUserPrincipal();
            LoginSecurityContext loginSecurityContext = (LoginSecurityContext)sc;
            Set<Principal> principalRoles = loginSecurityContext.getUserRoles();
            ArrayList<String> roles = new ArrayList<String>();
            if (principalRoles != null) {
                for (Principal p : principalRoles) {
                    if (p == principal) continue;
                    roles.add(p.getName());
                }
            }
            try {
                if (this.authorize(principal, roles, message)) {
                    return;
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Unauthorized: " + e.getMessage(), e);
                throw new AccessDeniedException("Unauthorized");
            }
        }
        throw new AccessDeniedException("Unauthorized");
    }

    public XACMLRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    public void setRequestBuilder(XACMLRequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    protected boolean authorize(Principal principal, List<String> roles, Message message) throws Exception {
        RequestType request = this.requestBuilder.createRequest(principal, roles, message);
        ResponseType response = this.performRequest(request, message);
        ResultType result = response.getResult();
        this.handleObligations(request, principal, message, result);
        String resource = this.requestBuilder.getResource(message);
        if (result != null && (result.getResourceId() == null || resource.equals(result.getResourceId())) && result.getDecision().getDecision() == DecisionType.DECISION.Permit) {
            LOG.fine("XACML authorization permitted");
            return true;
        }
        LOG.fine("XACML authorization not permitted:");
        if (result != null && result.getStatus() != null) {
            if (result.getStatus().getStatusCode() != null) {
                LOG.fine("XACML Status Code: " + result.getStatus().getStatusCode().getValue());
            }
            if (result.getStatus().getStatusMessage() != null) {
                LOG.fine("XACML Status Message: " + result.getStatus().getStatusMessage().getValue());
            }
        }
        return false;
    }

    public abstract ResponseType performRequest(RequestType var1, Message var2) throws Exception;

    protected void handleObligations(RequestType request, Principal principal, Message message, ResultType result) throws Exception {
    }
}

