/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.test;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.xml.namespace.NamespaceContext;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.test.TestUtilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Ignore
public class AbstractCXFTest
extends Assert {
    protected TestUtilities testUtilities = new TestUtilities(((Object)((Object)this)).getClass());
    protected Bus bus;

    protected AbstractCXFTest() {
        this.testUtilities.addDefaultNamespaces();
    }

    @Before
    public void setUpBus() throws Exception {
        if (this.bus == null) {
            this.bus = this.createBus();
            this.testUtilities.setBus(this.bus);
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    @After
    public void shutdownBus() {
        if (this.bus != null) {
            this.bus.shutdown(false);
            this.bus = null;
        }
        BusFactory.setDefaultBus(null);
    }

    protected Bus createBus() throws BusException {
        return BusFactory.newInstance().createBus();
    }

    protected byte[] invokeBytes(String address, String transport, String message) throws Exception {
        return this.testUtilities.invokeBytes(address, transport, message);
    }

    protected Node invoke(String address, String transport, String message) throws Exception {
        return this.testUtilities.invoke(address, transport, message);
    }

    protected Node invoke(String address, String transport, byte[] message) throws Exception {
        return this.testUtilities.invoke(address, transport, message);
    }

    public NodeList assertValid(String xpath, Node node) throws Exception {
        return this.testUtilities.assertValid(xpath, node);
    }

    public void assertValidBoolean(String xpath, Node node) throws Exception {
        this.testUtilities.assertValidBoolean(xpath, node);
    }

    public NodeList assertInvalid(String xpath, Node node) throws Exception {
        return this.testUtilities.assertInvalid(xpath, node);
    }

    public void assertXPathEquals(String xpath, String value, Node node) throws Exception {
        this.testUtilities.assertXPathEquals(xpath, value, node);
    }

    public void assertNoFault(Node node) throws Exception {
        this.testUtilities.assertNoFault(node);
    }

    public void addNamespace(String ns, String uri) {
        this.testUtilities.addNamespace(ns, uri);
    }

    public NamespaceContext getNamespaceContext() {
        return new MapNamespaceContext(this.testUtilities.getNamespaces());
    }

    public Map<String, String> getNamespaces() {
        return this.testUtilities.getNamespaces();
    }

    protected InputStream getResourceAsStream(String resource) {
        return this.testUtilities.getResourceAsStream(resource);
    }

    protected Reader getResourceAsReader(String resource) {
        return this.testUtilities.getResourceAsReader(resource);
    }

    public File getTestFile(String relativePath) {
        return this.testUtilities.getTestFile(relativePath);
    }

    public static String getBasedir() {
        return TestUtilities.getBasedir();
    }

    protected Document getWSDLDocument(Server server) throws WSDLException {
        return this.testUtilities.getWSDLDocument(server);
    }

    public static class TestMessageObserver
    extends TestUtilities.TestMessageObserver {
    }
}

