/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.AbstractTokenInterceptor;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.processor.BinarySecurityTokenProcessor;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosTokenInterceptor
extends AbstractTokenInterceptor {
    @Override
    protected void processToken(SoapMessage message) {
        Header h = this.findSecurityHeader(message, false);
        if (h == null) {
            return;
        }
        Element el = (Element)h.getObject();
        Element child = DOMUtils.getFirstElement(el);
        while (child != null) {
            if ("BinarySecurityToken".equals(child.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI())) {
                try {
                    List<WSSecurityEngineResult> bstResults = this.processToken(child, message);
                    if (bstResults != null) {
                        List results = CastUtils.cast((List)message.get("RECV_RESULTS"));
                        if (results == null) {
                            results = new ArrayList();
                            message.put("RECV_RESULTS", (Object)results);
                        }
                        WSHandlerResult rResult = new WSHandlerResult(null, bstResults);
                        results.add(0, rResult);
                        this.assertTokens(message, SP12Constants.KERBEROS_TOKEN, false);
                        Principal principal = (Principal)bstResults.get(0).get((Object)"principal");
                        message.put("wss4j.principal.result", (Object)principal);
                        SecurityContext sc = message.get(SecurityContext.class);
                        if (sc == null || sc.getUserPrincipal() == null) {
                            message.put(SecurityContext.class, new DefaultSecurityContext(principal, null));
                        }
                    }
                }
                catch (WSSecurityException ex) {
                    throw new Fault(ex);
                }
            }
            child = DOMUtils.getNextElement(child);
        }
    }

    private List<WSSecurityEngineResult> processToken(Element tokenElement, final SoapMessage message) throws WSSecurityException {
        WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
        RequestData data = new RequestData(){

            public CallbackHandler getCallbackHandler() {
                return KerberosTokenInterceptor.this.getCallback(message);
            }

            public Validator getValidator(QName qName) throws WSSecurityException {
                String key = "ws-security.bst.validator";
                Object o = message.getContextualProperty(key);
                try {
                    if (o instanceof Validator) {
                        return (Validator)o;
                    }
                    if (o instanceof Class) {
                        return (Validator)((Class)o).newInstance();
                    }
                    if (o instanceof String) {
                        return (Validator)ClassLoaderUtils.loadClass(o.toString(), KerberosTokenInterceptor.class).newInstance();
                    }
                }
                catch (RuntimeException t) {
                    throw t;
                }
                catch (Throwable t) {
                    throw new WSSecurityException(t.getMessage(), t);
                }
                return super.getValidator(qName);
            }
        };
        data.setWssConfig(WSSConfig.getNewInstance());
        BinarySecurityTokenProcessor p = new BinarySecurityTokenProcessor();
        List results = p.handleToken(tokenElement, data, wsDocInfo);
        return results;
    }

    @Override
    protected Token assertTokens(SoapMessage message) {
        return this.assertTokens(message, SP12Constants.KERBEROS_TOKEN, true);
    }

    @Override
    protected void addToken(SoapMessage message) {
        SecurityToken securityToken = this.getSecurityToken(message);
        if (securityToken == null || securityToken.getToken() == null) {
            return;
        }
        this.assertTokens(message);
        Header h = this.findSecurityHeader(message, true);
        Element el = (Element)h.getObject();
        el.appendChild(el.getOwnerDocument().importNode(securityToken.getToken(), true));
    }

    private SecurityToken getSecurityToken(SoapMessage message) {
        TokenStore tokenStore = this.getTokenStore(message);
        if (tokenStore == null) {
            return null;
        }
        String id = (String)message.getContextualProperty("ws-security.token.id");
        if (id != null) {
            return tokenStore.getToken(id);
        }
        return null;
    }
}

