/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Scope
implements Comparable<Object> {
    private static final String SEPARATOR = ".";
    private List<String> scope;
    private Scope parent;
    private String prefix;

    public Scope() {
        this.scope = new ArrayList<String>();
        this.parent = this;
    }

    public Scope(String scopes, String separator) {
        StringTokenizer tokens = new StringTokenizer(scopes, separator);
        Scope rootScope = new Scope();
        Scope prevScope = rootScope.parent;
        this.scope = rootScope.scope;
        this.parent = this;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            this.parent = prevScope;
            prevScope = new Scope(prevScope, token);
            this.scope.add(token);
        }
    }

    public Scope(Scope containingScope) {
        this.scope = new ArrayList<String>(containingScope.scope);
        this.parent = containingScope.getParent();
        this.setPrefix(this.parent.getPrefix());
    }

    public Scope(Scope containingScope, String str) {
        this.scope = new ArrayList<String>(containingScope.scope);
        this.scope.add(str);
        this.parent = containingScope;
        this.setPrefix(this.parent.getPrefix());
    }

    public Scope(Scope containingScope, Scope prefixScope, String str) {
        this.scope = new ArrayList<String>(containingScope.scope);
        this.scope.addAll(prefixScope.scope);
        this.scope.add(str);
        this.parent = containingScope;
        this.setPrefix(this.parent.getPrefix());
    }

    public Scope(Scope containingScope, AST node) {
        this.scope = new ArrayList<String>(containingScope.scope);
        if (node != null) {
            this.scope.add(node.toString());
        }
        this.parent = containingScope;
        this.setPrefix(this.parent.getPrefix());
    }

    public String tail() {
        int size = this.scope.size();
        if (size > 0) {
            return this.scope.get(size - 1);
        }
        return "";
    }

    public Scope getParent() {
        return this.parent;
    }

    public String toString(String separator) {
        StringBuilder result = new StringBuilder();
        Iterator<String> it = this.scope.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public String toString() {
        return this.toString(SEPARATOR);
    }

    public String toIDLRepositoryID() {
        StringBuilder result = new StringBuilder();
        result.append("IDL:");
        if (this.prefix != null && this.prefix.length() > 0) {
            result.append(this.prefix + "/");
        }
        result.append(this.toString("/"));
        result.append(":1.0");
        return result.toString();
    }

    public boolean equals(Object otherScope) {
        if (otherScope instanceof Scope) {
            return this.toString().equals(((Scope)otherScope).toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(Object otherScope) {
        if (otherScope == null) {
            throw new RuntimeException("Cannot compare a null object");
        }
        if (otherScope instanceof Scope) {
            return this.toString().compareTo(otherScope.toString());
        }
        throw new ClassCastException("Scope class expected but found " + otherScope.getClass().getName());
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

