/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509TokenBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public X509TokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        X509Token x509Token = new X509Token(consts);
        x509Token.setOptional(PolicyConstants.isOptional(element));
        x509Token.setIgnorable(PolicyConstants.isIgnorable(element));
        Element policyElement = DOMUtils.getFirstElement(element);
        if (policyElement == null && consts != SP11Constants.INSTANCE) {
            throw new IllegalArgumentException("sp:X509Token/wsp:Policy must have a value");
        }
        String includeAttr = DOMUtils.getAttribute(element, consts.getIncludeToken());
        if (includeAttr != null) {
            SPConstants.IncludeTokenType inclusion = consts.getInclusionFromAttributeValue(includeAttr);
            x509Token.setInclusion(inclusion);
        }
        if (policyElement != null) {
            x509Token.setPolicy(policyElement);
            if (DOMUtils.getFirstChildWithName(policyElement, consts.getRequiredDerivedKeys()) != null) {
                x509Token.setDerivedKeys(true);
            } else if (DOMUtils.getFirstChildWithName(policyElement, SP12Constants.REQUIRE_IMPLIED_DERIVED_KEYS) != null) {
                x509Token.setImpliedDerivedKeys(true);
            } else if (DOMUtils.getFirstChildWithName(policyElement, SP12Constants.REQUIRE_EXPLICIT_DERIVED_KEYS) != null) {
                x509Token.setExplicitDerivedKeys(true);
            }
        }
        Policy policy = this.builder.getPolicy(DOMUtils.getFirstElement(element));
        Iterator iterator = (policy = policy.normalize(this.builder.getPolicyRegistry(), false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), x509Token, consts);
        }
        return x509Token;
    }

    private void processAlternative(List<Assertion> assertions, X509Token parent, SPConstants consts) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (!consts.getNamespace().equals(name.getNamespaceURI())) continue;
            if ("RequireKeyIdentifierReference".equals(name.getLocalPart())) {
                parent.setRequireKeyIdentifierReference(true);
                continue;
            }
            if ("RequireIssuerSerialReference".equals(name.getLocalPart())) {
                parent.setRequireIssuerSerialReference(true);
                continue;
            }
            if ("RequireEmbeddedTokenReference".equals(name.getLocalPart())) {
                parent.setRequireEmbeddedTokenReference(true);
                continue;
            }
            if ("RequireThumbprintReference".equals(name.getLocalPart())) {
                parent.setRequireThumbprintReference(true);
                continue;
            }
            if ("WssX509V1Token10".equals(name.getLocalPart())) {
                parent.setTokenVersionAndType("WssX509V1Token10");
                continue;
            }
            if ("WssX509V1Token11".equals(name.getLocalPart())) {
                parent.setTokenVersionAndType("WssX509V1Token11");
                continue;
            }
            if ("WssX509V3Token10".equals(name.getLocalPart())) {
                parent.setTokenVersionAndType("WssX509V3Token10");
                continue;
            }
            if ("WssX509V3Token11".equals(name.getLocalPart())) {
                parent.setTokenVersionAndType("WssX509V3Token11");
                continue;
            }
            if ("WssX509Pkcs7Token10".equals(name.getLocalPart())) {
                parent.setTokenVersionAndType("WssX509Pkcs7Token10");
                continue;
            }
            if ("WssX509Pkcs7Token11".equals(name.getLocalPart())) {
                parent.setTokenVersionAndType("WssX509Pkcs7Token11");
                continue;
            }
            if ("WssX509PkiPathV1Token10".equals(name.getLocalPart())) {
                parent.setTokenVersionAndType("WssX509PkiPathV1Token10");
                continue;
            }
            if (!"WssX509PkiPathV1Token11".equals(name.getLocalPart())) continue;
            parent.setTokenVersionAndType("WssX509PkiPathV1Token11");
        }
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.X509_TOKEN, SP12Constants.X509_TOKEN};
    }
}

