/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.utils;

import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveHandler;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.W3CConstants;
import org.apache.cxf.common.util.ASMHelper;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;

public final class CorbaAnyHelper {
    private static final Map<QName, QName> SCHEMA_TO_IDL_TYPES = new HashMap<QName, QName>();
    private static final Map<QName, QName> IDL_TO_SCHEMA_TYPES = new HashMap<QName, QName>();
    private static Constructor<?> fixedAnyConstructor;

    private CorbaAnyHelper() {
    }

    public static Any createAny(ORB orb) {
        Any value = orb.create_any();
        if ("com.sun.corba.se.impl.corba.AnyImpl".equals(value.getClass().getName())) {
            value = CorbaAnyHelper.createFixedAny(orb, value);
        }
        return value;
    }

    public static boolean isPrimitiveSchemaType(QName schemaType) {
        return SCHEMA_TO_IDL_TYPES.get(schemaType) != null;
    }

    public static boolean isPrimitiveIdlType(QName idlType) {
        return IDL_TO_SCHEMA_TYPES.get(idlType) != null;
    }

    public static QName convertPrimitiveSchemaToIdlType(QName schemaType) {
        return SCHEMA_TO_IDL_TYPES.get(schemaType);
    }

    public static QName convertPrimitiveIdlToSchemaType(QName idlType) {
        return IDL_TO_SCHEMA_TYPES.get(idlType);
    }

    public static QName getPrimitiveIdlTypeFromTypeCode(TypeCode tc) {
        TCKind type = tc.kind();
        QName result = null;
        switch (type.value()) {
            case 8: {
                result = CorbaConstants.NT_CORBA_BOOLEAN;
                break;
            }
            case 9: {
                result = CorbaConstants.NT_CORBA_CHAR;
                break;
            }
            case 26: {
                result = CorbaConstants.NT_CORBA_WCHAR;
                break;
            }
            case 10: {
                result = CorbaConstants.NT_CORBA_OCTET;
                break;
            }
            case 2: {
                result = CorbaConstants.NT_CORBA_SHORT;
                break;
            }
            case 4: {
                result = CorbaConstants.NT_CORBA_USHORT;
                break;
            }
            case 3: {
                result = CorbaConstants.NT_CORBA_LONG;
                break;
            }
            case 5: {
                result = CorbaConstants.NT_CORBA_ULONG;
                break;
            }
            case 23: {
                result = CorbaConstants.NT_CORBA_LONGLONG;
                break;
            }
            case 24: {
                result = CorbaConstants.NT_CORBA_ULONGLONG;
                break;
            }
            case 6: {
                result = CorbaConstants.NT_CORBA_FLOAT;
                break;
            }
            case 7: {
                result = CorbaConstants.NT_CORBA_DOUBLE;
                break;
            }
            case 18: {
                result = CorbaConstants.NT_CORBA_STRING;
                break;
            }
            case 27: {
                result = CorbaConstants.NT_CORBA_WSTRING;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static void insertPrimitiveIntoAny(Any a, CorbaPrimitiveHandler primitive) throws CorbaBindingException {
        assert (primitive != null);
        switch (primitive.getTypeCode().kind().value()) {
            case 8: {
                a.insert_boolean(((Boolean)primitive.getValue()).booleanValue());
                break;
            }
            case 9: {
                a.insert_char(((Character)primitive.getValue()).charValue());
                break;
            }
            case 26: {
                a.insert_wchar(((Character)primitive.getValue()).charValue());
                break;
            }
            case 10: {
                a.insert_octet(((Byte)primitive.getValue()).byteValue());
                break;
            }
            case 2: {
                a.insert_short(((Short)primitive.getValue()).shortValue());
                break;
            }
            case 4: {
                a.insert_ushort(((Integer)primitive.getValue()).shortValue());
                break;
            }
            case 3: {
                a.insert_long(((Integer)primitive.getValue()).intValue());
                break;
            }
            case 5: {
                a.insert_ulong(((BigInteger)primitive.getValue()).intValue());
                break;
            }
            case 23: {
                a.insert_longlong(((Long)primitive.getValue()).longValue());
                break;
            }
            case 24: {
                a.insert_ulonglong((long)((BigInteger)primitive.getValue()).intValue());
                break;
            }
            case 6: {
                a.insert_float(((Float)primitive.getValue()).floatValue());
                break;
            }
            case 7: {
                a.insert_double(((Double)primitive.getValue()).doubleValue());
                break;
            }
            case 18: {
                a.insert_string((String)primitive.getValue());
                break;
            }
            case 27: {
                a.insert_wstring((String)primitive.getValue());
                break;
            }
            default: {
                throw new CorbaBindingException("Unable to insert type into any.  Kind = " + primitive.getTypeCode().kind().value());
            }
        }
    }

    public static void extractPrimitiveFromAny(Any a, CorbaPrimitiveHandler primitive) {
        assert (primitive != null);
        switch (primitive.getTypeCode().kind().value()) {
            case 8: {
                primitive.setValue(a.extract_boolean());
                break;
            }
            case 9: {
                primitive.setValue(Character.valueOf(a.extract_char()));
                break;
            }
            case 26: {
                primitive.setValue(Character.valueOf(a.extract_wchar()));
                break;
            }
            case 10: {
                primitive.setValue(a.extract_octet());
                break;
            }
            case 2: {
                primitive.setValue(a.extract_short());
                break;
            }
            case 4: {
                primitive.setValue(a.extract_ushort());
                break;
            }
            case 3: {
                primitive.setValue(a.extract_long());
                break;
            }
            case 5: {
                primitive.setValue(BigInteger.valueOf(a.extract_ulong()));
                break;
            }
            case 23: {
                primitive.setValue(a.extract_longlong());
                break;
            }
            case 24: {
                primitive.setValue(BigInteger.valueOf(a.extract_ulonglong()));
                break;
            }
            case 6: {
                primitive.setValue(Float.valueOf(a.extract_float()));
                break;
            }
            case 7: {
                primitive.setValue(a.extract_double());
                break;
            }
            case 18: {
                primitive.setValue(a.extract_string());
                break;
            }
            case 27: {
                primitive.setValue(a.extract_wstring());
                break;
            }
            default: {
                throw new CorbaBindingException("Unable to extract type from any.  Kind = " + primitive.getTypeCode().kind().value());
            }
        }
    }

    private static Any createFixedAny(ORB orb, Any any) {
        CorbaAnyHelper.createFixedAnyConstructor();
        try {
            return (Any)fixedAnyConstructor.newInstance(orb, any);
        }
        catch (Exception e) {
            return any;
        }
    }

    private static synchronized void createFixedAnyConstructor() {
        if (fixedAnyConstructor != null) {
            return;
        }
        ASMHelper helper = new ASMHelper();
        ClassWriter cw = helper.createClassWriter();
        cw.visit(49, 33, "org/apache/cxf/binding/corba/utils/FixedAnyImpl", null, "com/sun/corba/se/impl/corba/AnyImpl", null);
        cw.visitSource("FixedAnyImpl.java", null);
        FieldVisitor fv = cw.visitField(0, "obj", "Lorg/omg/CORBA/portable/Streamable;", null, null);
        fv.visitEnd();
        CorbaAnyHelper.addFixedAnyConstructor(cw);
        CorbaAnyHelper.addInsertOverride(cw);
        CorbaAnyHelper.addExtractOverride(cw);
        CorbaAnyHelper.addReadOverride(cw);
        CorbaAnyHelper.addWriteOverride(cw);
        cw.visitEnd();
        byte[] b = cw.toByteArray();
        Class<?> c = helper.loadClass("org.apache.cxf.binding.corba.utils.FixedAnyImpl", CorbaAnyHelper.class, b);
        try {
            fixedAnyConstructor = c.getConstructor(ORB.class, Any.class);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void addReadOverride(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "read_value", "(Lorg/omg/CORBA/portable/InputStream;Lorg/omg/CORBA/TypeCode;)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(54, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "org/apache/cxf/binding/corba/utils/FixedAnyImpl", "obj", "Lorg/omg/CORBA/portable/Streamable;");
        Label l1 = new Label();
        mv.visitJumpInsn(198, l1);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(55, l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "org/apache/cxf/binding/corba/utils/FixedAnyImpl", "obj", "Lorg/omg/CORBA/portable/Streamable;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "org/omg/CORBA/portable/Streamable", "_read", "(Lorg/omg/CORBA/portable/InputStream;)V");
        Label l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l1);
        mv.visitLineNumber(57, l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, "com/sun/corba/se/impl/corba/AnyImpl", "read_value", "(Lorg/omg/CORBA/portable/InputStream;Lorg/omg/CORBA/TypeCode;)V");
        mv.visitLabel(l3);
        mv.visitLineNumber(59, l3);
        mv.visitInsn(177);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "Lorg/apache/cxf/binding/corba/utils/FixedAnyImpl;", null, l0, l4, 0);
        mv.visitLocalVariable("is", "Lorg/omg/CORBA/portable/InputStream;", null, l0, l4, 1);
        mv.visitLocalVariable("t", "Lorg/omg/CORBA/TypeCode;", null, l0, l4, 2);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    private static void addWriteOverride(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "write_value", "(Lorg/omg/CORBA/portable/OutputStream;)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(61, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "org/apache/cxf/binding/corba/utils/FixedAnyImpl", "obj", "Lorg/omg/CORBA/portable/Streamable;");
        Label l1 = new Label();
        mv.visitJumpInsn(198, l1);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(62, l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "org/apache/cxf/binding/corba/utils/FixedAnyImpl", "obj", "Lorg/omg/CORBA/portable/Streamable;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "org/omg/CORBA/portable/Streamable", "_write", "(Lorg/omg/CORBA/portable/OutputStream;)V");
        Label l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l1);
        mv.visitLineNumber(64, l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "com/sun/corba/se/impl/corba/AnyImpl", "write_value", "(Lorg/omg/CORBA/portable/OutputStream;)V");
        mv.visitLabel(l3);
        mv.visitLineNumber(66, l3);
        mv.visitInsn(177);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "Lorg/apache/cxf/binding/corba/utils/FixedAnyImpl;", null, l0, l4, 0);
        mv.visitLocalVariable("os", "Lorg/omg/CORBA/portable/OutputStream;", null, l0, l4, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static void addExtractOverride(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "extract_Streamable", "()Lorg/omg/CORBA/portable/Streamable;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(47, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "org/apache/cxf/binding/corba/utils/FixedAnyImpl", "obj", "Lorg/omg/CORBA/portable/Streamable;");
        Label l1 = new Label();
        mv.visitJumpInsn(198, l1);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(48, l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "org/apache/cxf/binding/corba/utils/FixedAnyImpl", "obj", "Lorg/omg/CORBA/portable/Streamable;");
        mv.visitInsn(176);
        mv.visitLabel(l1);
        mv.visitLineNumber(50, l1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/sun/corba/se/impl/corba/AnyImpl", "extract_Streamable", "()Lorg/omg/CORBA/portable/Streamable;");
        mv.visitInsn(176);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "Lorg/apache/cxf/binding/corba/utils/FixedAnyImpl;", null, l0, l3, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addInsertOverride(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "insert_Streamable", "(Lorg/omg/CORBA/portable/Streamable;)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(43, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "com/sun/corba/se/impl/corba/AnyImpl", "insert_Streamable", "(Lorg/omg/CORBA/portable/Streamable;)V");
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(44, l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, "org/apache/cxf/binding/corba/utils/FixedAnyImpl", "obj", "Lorg/omg/CORBA/portable/Streamable;");
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(45, l2);
        mv.visitInsn(177);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "Lorg/apache/cxf/binding/corba/utils/FixedAnyImpl;", null, l0, l3, 0);
        mv.visitLocalVariable("s", "Lorg/omg/CORBA/portable/Streamable;", null, l0, l3, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static void addFixedAnyConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lorg/omg/CORBA/ORB;)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(36, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, "com/sun/corba/se/spi/orb/ORB");
        mv.visitMethodInsn(183, "com/sun/corba/se/impl/corba/AnyImpl", "<init>", "(Lcom/sun/corba/se/spi/orb/ORB;)V");
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(37, l1);
        mv.visitInsn(177);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable("this", "Lorg/apache/cxf/binding/corba/utils/FixedAnyImpl;", null, l0, l2, 0);
        mv.visitLocalVariable("orb", "Lorg/omg/CORBA/ORB;", null, l0, l2, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "<init>", "(Lorg/omg/CORBA/ORB;Lorg/omg/CORBA/Any;)V", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(39, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, "com/sun/corba/se/spi/orb/ORB");
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, "com/sun/corba/se/impl/corba/AnyImpl", "<init>", "(Lcom/sun/corba/se/spi/orb/ORB;Lorg/omg/CORBA/Any;)V");
        l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(40, l1);
        mv.visitInsn(177);
        l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable("this", "Lorg/apache/cxf/binding/corba/utils/FixedAnyImpl;", null, l0, l2, 0);
        mv.visitLocalVariable("orb", "Lorg/omg/CORBA/ORB;", null, l0, l2, 1);
        mv.visitLocalVariable("any", "Lorg/omg/CORBA/Any;", null, l0, l2, 2);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    static {
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_BOOLEAN, CorbaConstants.NT_CORBA_BOOLEAN);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_BYTE, CorbaConstants.NT_CORBA_CHAR);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_UBYTE, CorbaConstants.NT_CORBA_OCTET);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_SHORT, CorbaConstants.NT_CORBA_SHORT);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_USHORT, CorbaConstants.NT_CORBA_USHORT);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_INT, CorbaConstants.NT_CORBA_LONG);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_UINT, CorbaConstants.NT_CORBA_ULONG);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_LONG, CorbaConstants.NT_CORBA_LONGLONG);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_ULONG, CorbaConstants.NT_CORBA_ULONGLONG);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_FLOAT, CorbaConstants.NT_CORBA_FLOAT);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_DOUBLE, CorbaConstants.NT_CORBA_DOUBLE);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_STRING, CorbaConstants.NT_CORBA_STRING);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_ANYTYPE, CorbaConstants.NT_CORBA_ANY);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_BOOLEAN, W3CConstants.NT_SCHEMA_BOOLEAN);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_CHAR, W3CConstants.NT_SCHEMA_BYTE);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_WCHAR, W3CConstants.NT_SCHEMA_STRING);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_OCTET, W3CConstants.NT_SCHEMA_UBYTE);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_SHORT, W3CConstants.NT_SCHEMA_SHORT);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_USHORT, W3CConstants.NT_SCHEMA_USHORT);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_LONG, W3CConstants.NT_SCHEMA_INT);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_ULONG, W3CConstants.NT_SCHEMA_UINT);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_LONGLONG, W3CConstants.NT_SCHEMA_LONG);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_ULONGLONG, W3CConstants.NT_SCHEMA_ULONG);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_FLOAT, W3CConstants.NT_SCHEMA_FLOAT);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_DOUBLE, W3CConstants.NT_SCHEMA_DOUBLE);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_STRING, W3CConstants.NT_SCHEMA_STRING);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_WSTRING, W3CConstants.NT_SCHEMA_STRING);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_ANY, W3CConstants.NT_SCHEMA_ANYTYPE);
    }
}

