/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.JAXWSAConstants;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ManagedRMEndpoint;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.Servant;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.WrappedEndpoint;
import org.apache.cxf.ws.rm.WrappedService;
import org.apache.cxf.ws.rm.manager.SequenceTerminationPolicyType;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMEndpoint {
    private static final Logger LOG = LogUtils.getL7dLogger(RMEndpoint.class);
    private static final String SERVICE_NAME = "SequenceAbstractService";
    private static final String INTERFACE_NAME = "SequenceAbstractPortType";
    private static final String BINDING_NAME = "SequenceAbstractSoapBinding";
    private static final String CREATE_PART_NAME = "create";
    private static final String CREATE_RESPONSE_PART_NAME = "createResponse";
    private static final String TERMINATE_PART_NAME = "terminate";
    private static Schema rmSchema;
    private RMManager manager;
    private Endpoint applicationEndpoint;
    private Conduit conduit;
    private ProtocolVariation protocol;
    private EndpointReferenceType replyTo;
    private Source source;
    private Destination destination;
    private WrappedService service;
    private Endpoint endpoint;
    private Proxy proxy;
    private Servant servant;
    private QName serviceQName;
    private QName bindingQName;
    private QName interfaceQName;
    private long lastApplicationMessage;
    private long lastControlMessage;
    private InstrumentationManager instrumentationManager;
    private ManagedRMEndpoint managedEndpoint;

    public RMEndpoint(RMManager m, Endpoint ae, ProtocolVariation pv) {
        this.manager = m;
        this.applicationEndpoint = ae;
        this.source = new Source(this);
        this.destination = new Destination(this);
        this.proxy = new Proxy(this);
        this.servant = new Servant(this);
        this.protocol = pv;
    }

    public RMManager getManager() {
        return this.manager;
    }

    public Endpoint getApplicationEndpoint() {
        return this.applicationEndpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ProtocolVariation getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolVariation protocol) {
        this.protocol = protocol;
    }

    public Service getService() {
        return this.service;
    }

    public BindingInfo getBindingInfo() {
        return this.service.getServiceInfo().getBinding(this.bindingQName);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Servant getServant() {
        return this.servant;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public long getLastApplicationMessage() {
        return this.lastApplicationMessage;
    }

    public void receivedApplicationMessage() {
        this.lastApplicationMessage = System.currentTimeMillis();
    }

    public long getLastControlMessage() {
        return this.lastControlMessage;
    }

    public void receivedControlMessage() {
        this.lastControlMessage = System.currentTimeMillis();
    }

    public Conduit getConduit() {
        return this.conduit;
    }

    EndpointReferenceType getReplyTo() {
        return this.replyTo;
    }

    void initialise(Conduit c, EndpointReferenceType r, org.apache.cxf.transport.Destination d) {
        this.conduit = c;
        this.replyTo = r;
        this.createService();
        this.createEndpoint(d);
        this.setPolicies();
        if (!ProtocolVariation.RM10WSA200408.equals((Object)this.protocol)) {
            LOG.log(Level.INFO, "Skip monitoring for protocol: " + (Object)((Object)this.protocol));
            return;
        }
        if (this.manager != null && this.manager.getBus() != null) {
            this.managedEndpoint = new ManagedRMEndpoint(this);
            this.instrumentationManager = this.manager.getBus().getExtension(InstrumentationManager.class);
            if (this.instrumentationManager != null) {
                try {
                    this.instrumentationManager.register(this.managedEndpoint);
                }
                catch (JMException jmex) {
                    LOG.log(Level.WARNING, "Registering ManagedRMEndpoint failed.", jmex);
                }
            }
        }
    }

    void createService() {
        ServiceInfo si = new ServiceInfo();
        si.setProperty(Schema.class.getName(), RMEndpoint.getSchema());
        this.serviceQName = new QName(this.protocol.getWSRMNamespace(), SERVICE_NAME);
        si.setName(this.serviceQName);
        this.buildInterfaceInfo(si);
        this.service = new WrappedService(this.applicationEndpoint.getService(), this.serviceQName, si);
        JAXBDataBinding dataBinding = null;
        Class create = this.protocol.getCodec().getCreateSequenceType();
        try {
            JAXBContext ctx = JAXBContext.newInstance((String)PackageUtils.getPackageName(create), (ClassLoader)create.getClassLoader());
            dataBinding = new JAXBDataBinding(ctx);
        }
        catch (JAXBException e) {
            throw new ServiceConstructionException(e);
        }
        this.service.setDataBinding(dataBinding);
        this.service.setInvoker(this.servant);
    }

    private static synchronized Schema getSchema() {
        if (rmSchema == null) {
            try {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource ad = new StreamSource(RMEndpoint.class.getResource("/schemas/wsdl/addressing.xsd").openStream(), "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                StreamSource rm = new StreamSource(RMEndpoint.class.getResource("/schemas/wsdl/wsrm.xsd").openStream());
                javax.xml.transform.Source[] schemas = new javax.xml.transform.Source[]{ad, rm};
                rmSchema = factory.newSchema(schemas);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rmSchema;
    }

    void createEndpoint(org.apache.cxf.transport.Destination d) {
        ServiceInfo si = this.service.getServiceInfo();
        this.buildBindingInfo(si);
        EndpointInfo aei = this.applicationEndpoint.getEndpointInfo();
        String transportId = aei.getTransportId();
        EndpointInfo ei = new EndpointInfo(si, transportId);
        if (d != null) {
            ei.setProperty(MAPAggregator.DECOUPLED_DESTINATION, d);
        }
        ei.setAddress(aei.getAddress());
        ei.setName(RMUtils.getConstants(this.protocol.getWSRMNamespace()).getPortName());
        ei.setBinding(si.getBinding(this.bindingQName));
        Object ua = this.getUsingAddressing(aei);
        if (null != ua) {
            ei.addExtensor(ua);
        }
        si.addEndpoint(ei);
        this.endpoint = new WrappedEndpoint(this.applicationEndpoint, ei, this.service);
        this.service.setEndpoint(this.endpoint);
    }

    void setPolicies() {
        EndpointPolicy ep;
        PolicyEngine engine = this.manager.getBus().getExtension(PolicyEngine.class);
        if (null == engine || !engine.isEnabled()) {
            return;
        }
        EndpointInfo ei = this.getEndpoint().getEndpointInfo();
        PolicyInterceptorProviderRegistry reg = this.manager.getBus().getExtension(PolicyInterceptorProviderRegistry.class);
        EndpointPolicy endpointPolicy = ep = null == this.conduit ? engine.getServerEndpointPolicy(this.applicationEndpoint.getEndpointInfo(), null) : engine.getClientEndpointPolicy(this.applicationEndpoint.getEndpointInfo(), this.conduit);
        if (this.conduit != null) {
            engine.setClientEndpointPolicy(ei, ep);
        } else {
            engine.setServerEndpointPolicy(ei, ep);
        }
        EffectivePolicyImpl effectiveOutbound = new EffectivePolicyImpl(ep, reg, true, false);
        EffectivePolicyImpl effectiveInbound = new EffectivePolicyImpl(ep, reg, false, false);
        BindingInfo bi = ei.getBinding();
        Collection<BindingOperationInfo> bois = bi.getOperations();
        for (BindingOperationInfo boi : bois) {
            engine.setEffectiveServerRequestPolicy(ei, boi, effectiveInbound);
            engine.setEffectiveServerResponsePolicy(ei, boi, effectiveOutbound);
            engine.setEffectiveClientRequestPolicy(ei, boi, effectiveOutbound);
            engine.setEffectiveClientResponsePolicy(ei, boi, effectiveInbound);
        }
    }

    void buildInterfaceInfo(ServiceInfo si) {
        this.interfaceQName = new QName(this.protocol.getWSRMNamespace(), INTERFACE_NAME);
        InterfaceInfo ii = new InterfaceInfo(si, this.interfaceQName);
        this.buildOperationInfo(ii);
    }

    void buildOperationInfo(InterfaceInfo ii) {
        this.buildCreateSequenceOperationInfo(ii);
        this.buildTerminateSequenceOperationInfo(ii);
        this.buildSequenceAckOperationInfo(ii);
        this.buildCloseSequenceOperationInfo(ii);
        this.buildAckRequestedOperationInfo(ii);
    }

    void buildCreateSequenceOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessagePartInfo partInfo = null;
        MessageInfo messageInfo = null;
        RMConstants consts = this.protocol.getConstants();
        operationInfo = ii.addOperation(consts.getCreateSequenceOperationName());
        messageInfo = operationInfo.createMessage(consts.getCreateSequenceOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_PART_NAME);
        partInfo.setElementQName(consts.getCreateSequenceOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(this.protocol.getCodec().getCreateSequenceType());
        messageInfo = operationInfo.createMessage(consts.getCreateSequenceResponseOperationName(), MessageInfo.Type.OUTPUT);
        operationInfo.setOutput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_RESPONSE_PART_NAME);
        partInfo.setElementQName(consts.getCreateSequenceResponseOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(this.protocol.getCodec().getCreateSequenceResponseType());
        partInfo.setIndex(0);
        operationInfo = ii.addOperation(consts.getCreateSequenceOnewayOperationName());
        messageInfo = operationInfo.createMessage(consts.getCreateSequenceOnewayOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_PART_NAME);
        partInfo.setElementQName(consts.getCreateSequenceOnewayOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(this.protocol.getCodec().getCreateSequenceType());
        operationInfo = ii.addOperation(consts.getCreateSequenceResponseOnewayOperationName());
        messageInfo = operationInfo.createMessage(consts.getCreateSequenceResponseOnewayOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_RESPONSE_PART_NAME);
        partInfo.setElementQName(consts.getCreateSequenceResponseOnewayOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(this.protocol.getCodec().getCreateSequenceResponseType());
    }

    void buildTerminateSequenceOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessagePartInfo partInfo = null;
        MessageInfo messageInfo = null;
        RMConstants consts = this.protocol.getConstants();
        operationInfo = ii.addOperation(consts.getTerminateSequenceOperationName());
        messageInfo = operationInfo.createMessage(consts.getTerminateSequenceOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(TERMINATE_PART_NAME);
        partInfo.setElementQName(consts.getTerminateSequenceOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(this.protocol.getCodec().getTerminateSequenceType());
        operationInfo = ii.addOperation(consts.getTerminateSequenceAnonymousOperationName());
        messageInfo = operationInfo.createMessage(consts.getTerminateSequenceAnonymousOperationName(), MessageInfo.Type.OUTPUT);
        operationInfo.setOutput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(TERMINATE_PART_NAME);
        partInfo.setElementQName(consts.getTerminateSequenceOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(this.protocol.getCodec().getTerminateSequenceType());
    }

    void buildSequenceAckOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessageInfo messageInfo = null;
        RMConstants consts = this.protocol.getConstants();
        operationInfo = ii.addOperation(consts.getSequenceAckOperationName());
        messageInfo = operationInfo.createMessage(consts.getSequenceAckOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
    }

    void buildCloseSequenceOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessageInfo messageInfo = null;
        RMConstants consts = this.protocol.getConstants();
        operationInfo = ii.addOperation(consts.getCloseSequenceOperationName());
        messageInfo = operationInfo.createMessage(consts.getCloseSequenceOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
    }

    void buildAckRequestedOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessageInfo messageInfo = null;
        RMConstants consts = this.protocol.getConstants();
        operationInfo = ii.addOperation(consts.getAckRequestedOperationName());
        messageInfo = operationInfo.createMessage(consts.getAckRequestedOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
    }

    void buildBindingInfo(ServiceInfo si) {
        if (null != this.applicationEndpoint) {
            SoapBindingInfo sbi = (SoapBindingInfo)this.applicationEndpoint.getEndpointInfo().getBinding();
            SoapVersion sv = sbi.getSoapVersion();
            String bindingId = sbi.getBindingId();
            SoapBindingInfo bi = new SoapBindingInfo(si, bindingId, sv);
            this.bindingQName = new QName(this.protocol.getWSRMNamespace(), BINDING_NAME);
            bi.setName(this.bindingQName);
            BindingOperationInfo boi = null;
            RMConstants consts = this.protocol.getConstants();
            boi = bi.buildOperation(consts.getCreateSequenceOperationName(), consts.getCreateSequenceOperationName().getLocalPart(), null);
            this.addAction(boi, consts.getCreateSequenceAction(), consts.getCreateSequenceResponseAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(consts.getTerminateSequenceOperationName(), consts.getTerminateSequenceOperationName().getLocalPart(), null);
            this.addAction(boi, consts.getTerminateSequenceAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(consts.getTerminateSequenceAnonymousOperationName(), null, consts.getTerminateSequenceAnonymousOperationName().getLocalPart());
            this.addAction(boi, consts.getTerminateSequenceAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(consts.getSequenceAckOperationName(), null, null);
            this.addAction(boi, consts.getSequenceAckAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(consts.getCloseSequenceOperationName(), null, null);
            this.addAction(boi, consts.getCloseSequenceAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(consts.getAckRequestedOperationName(), null, null);
            this.addAction(boi, consts.getAckRequestedAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(consts.getCreateSequenceOnewayOperationName(), consts.getCreateSequenceOnewayOperationName().getLocalPart(), null);
            this.addAction(boi, consts.getCreateSequenceAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(consts.getCreateSequenceResponseOnewayOperationName(), consts.getCreateSequenceResponseOnewayOperationName().getLocalPart(), null);
            this.addAction(boi, consts.getCreateSequenceResponseAction());
            bi.addOperation(boi);
            si.addBinding(bi);
        }
    }

    private void addAction(BindingOperationInfo boi, String action) {
        this.addAction(boi, action, action);
    }

    private void addAction(BindingOperationInfo boi, String action, String outputAction) {
        SoapOperationInfo soi = new SoapOperationInfo();
        soi.setAction(action);
        boi.addExtensor(soi);
        MessageInfo info = boi.getOperationInfo().getInput();
        if (info != null) {
            info.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, action);
        }
        if ((info = boi.getOperationInfo().getOutput()) != null) {
            info.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, outputAction);
        }
    }

    Object getUsingAddressing(EndpointInfo endpointInfo) {
        if (null == endpointInfo) {
            return null;
        }
        Object ua = null;
        List<ExtensibilityElement> exts = endpointInfo.getExtensors(ExtensibilityElement.class);
        ua = this.getUsingAddressing(exts);
        if (null != ua) {
            return ua;
        }
        exts = endpointInfo.getBinding() != null ? endpointInfo.getBinding().getExtensors(ExtensibilityElement.class) : null;
        ua = this.getUsingAddressing(exts);
        if (null != ua) {
            return ua;
        }
        exts = endpointInfo.getService() != null ? endpointInfo.getService().getExtensors(ExtensibilityElement.class) : null;
        ua = this.getUsingAddressing(exts);
        if (null != ua) {
            return ua;
        }
        return ua;
    }

    Object getUsingAddressing(List<ExtensibilityElement> exts) {
        ExtensibilityElement ua = null;
        if (exts != null) {
            for (ExtensibilityElement ext : exts) {
                if (!Names.WSAW_USING_ADDRESSING_QNAME.equals(ext.getElementType())) continue;
                ua = ext;
            }
        }
        return ua;
    }

    void setAplicationEndpoint(Endpoint ae) {
        this.applicationEndpoint = ae;
    }

    void setManager(RMManager m) {
        this.manager = m;
    }

    void shutdown() {
        for (DestinationSequence ds : this.getDestination().getAllSequences()) {
            ds.cancelDeferredAcknowledgments();
            ds.cancelTermination();
        }
        SourcePolicyType sp = this.manager.getSourcePolicy();
        SequenceTerminationPolicyType stp = null;
        if (null != sp) {
            stp = sp.getSequenceTerminationPolicy();
        }
        if (null != stp && stp.isTerminateOnShutdown()) {
            Collection<SourceSequence> seqs = this.source.getAllUnacknowledgedSequences();
            LOG.log(Level.FINE, "Trying to terminate {0} sequences", seqs.size());
            for (SourceSequence seq : seqs) {
                try {
                    if (seq.isLastMessage()) continue;
                    this.getProxy().lastMessage(seq);
                }
                catch (RMException ex) {}
            }
        }
        for (SourceSequence ss : this.getSource().getAllSequences()) {
            this.manager.getRetransmissionQueue().stop(ss);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EffectivePolicyImpl
    implements EffectivePolicy {
        private EndpointPolicy endpointPolicy;
        private List<Interceptor<? extends Message>> interceptors;

        EffectivePolicyImpl(EndpointPolicy ep, PolicyInterceptorProviderRegistry reg, boolean outbound, boolean fault) {
            this.endpointPolicy = ep;
            this.interceptors = reg.getInterceptors(this.endpointPolicy.getChosenAlternative(), outbound, fault);
        }

        @Override
        public Collection<Assertion> getChosenAlternative() {
            return this.endpointPolicy.getChosenAlternative();
        }

        @Override
        public List<Interceptor<? extends Message>> getInterceptors() {
            return this.interceptors;
        }

        @Override
        public Policy getPolicy() {
            return this.endpointPolicy.getPolicy();
        }
    }
}

