/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.cache;

import java.io.Closeable;
import java.io.IOException;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientLifeCycleListener;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.ws.security.cache.ReplayCache;

public class CacheCleanupListener
implements ServerLifeCycleListener,
ClientLifeCycleListener {
    public void clientCreated(Client client) {
    }

    public void startServer(Server server) {
    }

    public void clientDestroyed(Client client) {
        this.shutdownResources(client.getEndpoint().getEndpointInfo());
    }

    public void stopServer(Server server) {
        this.shutdownResources(server.getEndpoint().getEndpointInfo());
    }

    protected void shutdownResources(EndpointInfo info) {
        ReplayCache rc = (ReplayCache)info.getProperty("ws-security.nonce.cache.instance");
        if (rc instanceof Closeable) {
            this.close((Closeable)rc);
        }
        if ((rc = (ReplayCache)info.getProperty("ws-security.timestamp.cache.instance")) instanceof Closeable) {
            this.close((Closeable)rc);
        }
    }

    private void close(Closeable ts) {
        try {
            ts.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

