/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultFactory;
import org.apache.cxf.ws.rm.Servant;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMInInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(RMInInterceptor.class);

    public RMInInterceptor() {
        this.addBefore(MAPAggregator.class.getName());
    }

    @Override
    public void handleFault(Message message) {
        message.put(MAPAggregator.class.getName(), true);
        if (MessageUtils.isTrue(message.get("org.apache.cxf.oneway.robust.delivering"))) {
            try {
                Destination destination = this.getManager().getDestination(message);
                destination.releaseDeliveringStatus(message);
            }
            catch (RMException e) {
                LOG.log(Level.WARNING, "Failed to revert the delivering status");
            }
        }
    }

    @Override
    protected void handle(Message message) throws SequenceFault, RMException {
        Object originalRequestor;
        LOG.entering(this.getClass().getName(), "handleMessage");
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs(message, false, false);
        if (null == maps) {
            return;
        }
        String action = null;
        if (null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        if (null != (originalRequestor = message.get("org.apache.cxf.client.original"))) {
            LOG.fine("Restoring original requestor role to: " + originalRequestor);
            message.put("org.apache.cxf.client", originalRequestor);
        }
        boolean isServer = RMContextUtils.isServerSide(message);
        LOG.fine("isServerSide: " + isServer);
        boolean isApplicationMessage = !RMContextUtils.isRMProtocolMessage(action);
        LOG.fine("isApplicationMessage: " + isApplicationMessage);
        RMEndpoint rme = this.getManager().getReliableEndpoint(message);
        Destination destination = this.getManager().getDestination(message);
        if (isApplicationMessage) {
            if (null != rmps) {
                this.processAcknowledgments(rme, rmps);
                this.processAcknowledgmentRequests(destination, message);
                this.processSequence(destination, message);
                this.processDeliveryAssurance(rmps);
            }
            if (ContextUtils.retrieveDeferredUncorrelatedMessageAbort(message)) {
                LOG.info("deferred uncorrelated message abort");
                message.getInterceptorChain().abort();
            } else {
                rme.receivedApplicationMessage();
            }
        } else {
            rme.receivedControlMessage();
            if ("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement".equals(action) || "http://docs.oasis-open.org/ws-rx/wsrm/200702/SequenceAcknowledgement".equals(action)) {
                this.processAcknowledgments(rme, rmps);
            } else if ("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage".equals(action) || "http://docs.oasis-open.org/ws-rx/wsrm/200702/SequenceAcknowledgement".equals(action)) {
                this.processSequence(destination, message);
            } else if (("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence".equals(action) || "http://docs.oasis-open.org/ws-rx/wsrm/200702/CreateSequence".equals(action)) && !isServer) {
                LOG.fine("Processing inbound CreateSequence on client side.");
                Servant servant = rme.getServant();
                Object csr = servant.createSequence(message);
                Proxy proxy = rme.getProxy();
                proxy.createSequenceResponse(csr);
                return;
            }
        }
        this.assertReliability(message);
    }

    void processAcknowledgments(RMEndpoint rme, RMProperties rmps) throws SequenceFault, RMException {
        Collection<SequenceAcknowledgement> acks = rmps.getAcks();
        Source source = rme.getSource();
        if (null != acks) {
            for (SequenceAcknowledgement ack : acks) {
                Identifier id = ack.getIdentifier();
                SourceSequence ss = source.getSequence(id);
                if (null != ss) {
                    ss.setAcknowledged(ack);
                    continue;
                }
                RMConstants consts = rme.getProtocol().getConstants();
                SequenceFaultFactory sff = new SequenceFaultFactory(consts);
                throw sff.createUnknownSequenceFault(id);
            }
        }
    }

    void processAcknowledgmentRequests(Destination destination, Message message) throws SequenceFault, RMException {
        destination.ackRequested(message);
    }

    void processSequence(Destination destination, Message message) throws SequenceFault, RMException {
        boolean robust = MessageUtils.isTrue(message.getContextualProperty("org.apache.cxf.oneway.robust"));
        if (robust) {
            message.put("org.apache.cxf.oneway.robust.delivering", Boolean.TRUE);
        }
        destination.acknowledge(message);
    }

    void processDeliveryAssurance(RMProperties rmps) {
    }
}

