/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndorsingTokenPolicyValidator {
    private List<WSSecurityEngineResult> signedResults;
    private Message message;

    public EndorsingTokenPolicyValidator(List<WSSecurityEngineResult> signedResults, Message message) {
        this.signedResults = signedResults;
        this.message = message;
    }

    public boolean validatePolicy(AssertionInfoMap aim) {
        Collection endorsingAis = (Collection)aim.get(SP12Constants.ENDORSING_SUPPORTING_TOKENS);
        if (endorsingAis != null && !endorsingAis.isEmpty()) {
            for (AssertionInfo ai : endorsingAis) {
                ai.setAsserted(true);
                TLSSessionInfo tlsInfo = this.message.get(TLSSessionInfo.class);
                boolean transport = false;
                if (tlsInfo != null) {
                    transport = true;
                }
                if (this.checkEndorsed(transport)) continue;
                ai.setNotAsserted("Message fails endorsing supporting tokens requirements");
                return false;
            }
        }
        return true;
    }

    private boolean checkEndorsed(boolean transport) {
        if (transport) {
            return this.checkTimestampIsSigned();
        }
        return this.checkSignatureIsSigned();
    }

    private boolean checkTimestampIsSigned() {
        for (WSSecurityEngineResult signedResult : this.signedResults) {
            List<WSDataRef> sl = CastUtils.cast((List)signedResult.get((Object)"data-ref-uris"));
            if (sl == null) continue;
            for (WSDataRef dataRef : sl) {
                QName signedQName = dataRef.getName();
                if (!WSSecurityEngine.TIMESTAMP.equals(signedQName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkSignatureIsSigned() {
        for (WSSecurityEngineResult signedResult : this.signedResults) {
            List<WSDataRef> sl = CastUtils.cast((List)signedResult.get((Object)"data-ref-uris"));
            if (sl == null) continue;
            for (WSDataRef dataRef : sl) {
                QName signedQName = dataRef.getName();
                if (!WSSecurityEngine.SIGNATURE.equals(signedQName)) continue;
                return true;
            }
        }
        return false;
    }
}

