/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.AsymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractBindingPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsymmetricBindingPolicyValidator
extends AbstractBindingPolicyValidator {
    private List<WSSecurityEngineResult> signedResults;
    private List<WSSecurityEngineResult> encryptedResults;
    private Message message;
    private boolean hasDerivedKeys;

    public AsymmetricBindingPolicyValidator(Message message, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        this.message = message;
        this.results = results;
        this.signedResults = signedResults;
        this.encryptedResults = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult result : results) {
            Integer actInt = (Integer)result.get((Object)"action");
            if (actInt == 2048) {
                this.hasDerivedKeys = true;
                continue;
            }
            if (actInt != 4) continue;
            this.encryptedResults.add(result);
        }
    }

    public boolean validatePolicy(AssertionInfoMap aim) {
        Collection ais = (Collection)aim.get(SP12Constants.ASYMMETRIC_BINDING);
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        for (AssertionInfo ai : ais) {
            AsymmetricBinding binding = (AsymmetricBinding)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.checkProtectionOrder(binding, ai)) {
                return false;
            }
            if (!this.checkProperties(binding, ai, aim, this.signedResults, this.message)) {
                return false;
            }
            if (this.checkTokens(binding, ai, aim)) continue;
            return false;
        }
        return true;
    }

    private boolean checkTokens(AsymmetricBinding binding, AssertionInfo ai, AssertionInfoMap aim) {
        if (binding.getInitiatorToken() != null) {
            Token token = binding.getInitiatorToken().getToken();
            if (token instanceof X509Token) {
                for (WSSecurityEngineResult result : this.signedResults) {
                    X509Certificate cert = (X509Certificate)result.get((Object)"x509-certificate");
                    if (cert != null) continue;
                    String error = "An X.509 certificate was not used for the initiator token";
                    this.notAssertPolicy(aim, binding.getInitiatorToken().getName(), error);
                    ai.setNotAsserted(error);
                    return false;
                }
            }
            this.assertPolicy(aim, binding.getInitiatorToken());
            if (!this.checkDerivedKeys(binding.getInitiatorToken(), this.hasDerivedKeys, this.signedResults, this.encryptedResults)) {
                ai.setNotAsserted("Message fails the DerivedKeys requirement");
                return false;
            }
        }
        if (binding.getRecipientToken() != null) {
            this.assertPolicy(aim, binding.getRecipientToken());
            if (!this.checkDerivedKeys(binding.getRecipientToken(), this.hasDerivedKeys, this.signedResults, this.encryptedResults)) {
                ai.setNotAsserted("Message fails the DerivedKeys requirement");
                return false;
            }
        }
        return true;
    }
}

