/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty.continuations;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.message.Message;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.server.AsyncContext;
import org.eclipse.jetty.server.Request;

public class JettyContinuationWrapper
implements org.apache.cxf.continuations.Continuation,
ContinuationListener {
    volatile boolean isNew;
    volatile boolean isResumed;
    volatile boolean isPending;
    volatile Object obj;
    private Message message;
    private final AsyncContext context;
    private final Request req;

    public JettyContinuationWrapper(HttpServletRequest request, HttpServletResponse resp, Message m) {
        this.req = (Request)request;
        this.message = m;
        boolean bl = this.isNew = this.req.getAttribute("cxf.continuation.message") == null;
        if (this.isNew) {
            this.req.setAttribute("cxf.continuation.message", (Object)this.message.getExchange().getInMessage());
            this.context = this.req.startAsync((ServletRequest)this.req, (ServletResponse)resp);
            this.context.addContinuationListener((ContinuationListener)this);
            this.req.setAttribute("cxf.async.context", (Object)this.context);
        } else {
            this.context = (AsyncContext)this.req.getAttribute("cxf.async.context");
        }
    }

    public Object getObject() {
        return this.obj;
    }

    public void setObject(Object userObject) {
        this.obj = userObject;
    }

    public void resume() {
        this.isResumed = true;
        this.context.dispatch();
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public boolean isResumed() {
        return this.isResumed;
    }

    public void reset() {
        this.context.complete();
        this.obj = null;
    }

    public boolean suspend(long timeout) {
        if (this.isPending) {
            return false;
        }
        this.context.setTimeout(timeout);
        this.isNew = false;
        this.message.getExchange().getInMessage().getInterceptorChain().suspend();
        this.isPending = true;
        return true;
    }

    protected Message getMessage() {
        Message m = this.message;
        if (m != null && m.getExchange().getInMessage() != null) {
            m = m.getExchange().getInMessage();
        }
        return m;
    }

    public void onComplete(Continuation continuation) {
        this.getMessage().remove("cxf.continuation.message");
        this.isPending = false;
    }

    public void onTimeout(Continuation continuation) {
        this.isPending = false;
        this.context.dispatch();
    }
}

