/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.ext.ParameterHandler;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.WebApplicationExceptionMapper;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.model.wadl.WadlGenerator;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.provider.MultipartProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(ProviderFactory.class);
    private static final ProviderFactory SHARED_FACTORY = new ProviderFactory();
    private List<ProviderInfo<MessageBodyReader>> messageReaders = new ArrayList<ProviderInfo<MessageBodyReader>>();
    private List<ProviderInfo<MessageBodyWriter>> messageWriters = new ArrayList<ProviderInfo<MessageBodyWriter>>();
    private List<ProviderInfo<ContextResolver>> contextResolvers = new ArrayList<ProviderInfo<ContextResolver>>(1);
    private List<ProviderInfo<ExceptionMapper>> exceptionMappers = new ArrayList<ProviderInfo<ExceptionMapper>>(1);
    private List<ProviderInfo<RequestHandler>> requestHandlers = new ArrayList<ProviderInfo<RequestHandler>>(1);
    private List<ProviderInfo<ResponseHandler>> responseHandlers = new ArrayList<ProviderInfo<ResponseHandler>>(1);
    private List<ProviderInfo<ParameterHandler>> paramHandlers = new ArrayList<ProviderInfo<ParameterHandler>>(1);
    private List<ProviderInfo<ResponseExceptionMapper>> responseExceptionMappers = new ArrayList<ProviderInfo<ResponseExceptionMapper>>(1);
    private RequestPreprocessor requestPreprocessor;

    private ProviderFactory() {
    }

    private static void setDefaultProvider(ProviderFactory factory, String className) {
        try {
            Object provider = ClassLoaderUtils.loadClass(className, ProviderFactory.class).newInstance();
            factory.setProviders(provider);
        }
        catch (Throwable ex) {
            String message = "Problem with setting the default provider " + className;
            message = ex.getMessage() != null ? message + ex.getMessage() : message + ", exception class : " + ex.getClass().getName();
            LOG.info(message);
        }
    }

    public static ProviderFactory getInstance() {
        return new ProviderFactory();
    }

    public static ProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().get(Endpoint.class);
        return (ProviderFactory)e.get(ProviderFactory.class.getName());
    }

    public static ProviderFactory getSharedInstance() {
        return SHARED_FACTORY;
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m) {
        Object mt = m.get("Content-Type");
        return this.createContextResolver(contextType, m, mt == null ? MediaType.valueOf((String)"*/*") : MediaType.valueOf((String)mt.toString()));
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m, MediaType type) {
        for (ProviderInfo<ContextResolver> cr : this.contextResolvers) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                if (!(t instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    if (contextType != args[i]) continue;
                    InjectionUtils.injectContextFields(cr.getProvider(), cr, m);
                    InjectionUtils.injectContextMethods(cr.getProvider(), cr, m);
                    return cr.getProvider();
                }
            }
        }
        return null;
    }

    public <T extends Throwable> ExceptionMapper<T> createExceptionMapper(Class<?> exceptionType, Message m) {
        ExceptionMapper<T> mapper = this.doCreateExceptionMapper(exceptionType, m);
        if (mapper != null || this == SHARED_FACTORY) {
            return mapper;
        }
        return SHARED_FACTORY.createExceptionMapper(exceptionType, m);
    }

    private <T extends Throwable> ExceptionMapper<T> doCreateExceptionMapper(Class<?> exceptionType, Message m) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<ExceptionMapper> em : this.exceptionMappers) {
            ProviderFactory.handleMapper(candidates, em, exceptionType, m, ExceptionMapper.class);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ExceptionMapperComparator());
        return (ExceptionMapper)candidates.get(0);
    }

    public <T> ParameterHandler<T> createParameterHandler(Class<?> paramType) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<ParameterHandler> em : this.paramHandlers) {
            ProviderFactory.handleMapper(candidates, em, paramType, null, ParameterHandler.class);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator());
        return (ParameterHandler)candidates.get(0);
    }

    public <T extends Throwable> ResponseExceptionMapper<T> createResponseExceptionMapper(Class<?> paramType) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<ResponseExceptionMapper> em : this.responseExceptionMappers) {
            ProviderFactory.handleMapper(candidates, em, paramType, null, ResponseExceptionMapper.class);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator());
        return (ResponseExceptionMapper)candidates.get(0);
    }

    private static void handleMapper(List<Object> candidates, ProviderInfo em, Class<?> expectedType, Message m, Class<?> providerClass) {
        Type[] types;
        Class mapperClass = ClassHelper.getRealClass(em.getProvider());
        for (Type t : types = ProviderFactory.getGenericInterfaces(mapperClass)) {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type arg = args[i];
                    if (arg instanceof TypeVariable) {
                        TypeVariable var = (TypeVariable)arg;
                        Type[] bounds = var.getBounds();
                        boolean isResolved = false;
                        for (int j = 0; j < bounds.length; ++j) {
                            Class<?> cls = InjectionUtils.getRawType(bounds[j]);
                            if (cls == null || !cls.isAssignableFrom(expectedType)) continue;
                            isResolved = true;
                            break;
                        }
                        if (!isResolved) {
                            return;
                        }
                        if (m != null) {
                            InjectionUtils.injectContextFields(em.getProvider(), em, m);
                            InjectionUtils.injectContextMethods(em.getProvider(), em, m);
                        }
                        candidates.add(em.getProvider());
                        return;
                    }
                    Class<?> actualClass = InjectionUtils.getRawType(arg);
                    if (actualClass == null || !actualClass.isAssignableFrom(expectedType)) continue;
                    if (m != null) {
                        InjectionUtils.injectContextFields(em.getProvider(), em, m);
                        InjectionUtils.injectContextMethods(em.getProvider(), em, m);
                    }
                    candidates.add(em.getProvider());
                    return;
                }
                continue;
            }
            if (!(t instanceof Class) || !((Class)t).isAssignableFrom(providerClass)) continue;
            candidates.add(em.getProvider());
        }
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyReader<T> mr = this.chooseMessageReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mr != null || this == SHARED_FACTORY) {
            return mr;
        }
        return SHARED_FACTORY.createMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
    }

    public List<ProviderInfo<RequestHandler>> getRequestHandlers() {
        List<ProviderInfo<RequestHandler>> handlers = null;
        if (this.requestHandlers.size() == 0) {
            handlers = ProviderFactory.SHARED_FACTORY.requestHandlers;
        } else {
            handlers = new ArrayList<ProviderInfo<RequestHandler>>();
            boolean customWADLHandler = false;
            for (int i = 0; i < this.requestHandlers.size(); ++i) {
                if (!(this.requestHandlers.get(i).getProvider() instanceof WadlGenerator)) continue;
                customWADLHandler = true;
                break;
            }
            if (!customWADLHandler) {
                handlers.addAll(ProviderFactory.SHARED_FACTORY.requestHandlers);
            }
            handlers.addAll(this.requestHandlers);
        }
        return Collections.unmodifiableList(handlers);
    }

    public List<ProviderInfo<ResponseHandler>> getResponseHandlers() {
        return Collections.unmodifiableList(this.responseHandlers);
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyWriter<T> mw = this.chooseMessageWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mw != null || this == SHARED_FACTORY) {
            return mw;
        }
        return SHARED_FACTORY.createMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
    }

    private void setProviders(Object ... providers) {
        for (Object o : providers) {
            if (o == null) continue;
            Class oClass = ClassHelper.getRealClass(o);
            if (MessageBodyReader.class.isAssignableFrom(oClass)) {
                this.messageReaders.add(new ProviderInfo<MessageBodyReader>((MessageBodyReader)o));
            }
            if (MessageBodyWriter.class.isAssignableFrom(oClass)) {
                this.messageWriters.add(new ProviderInfo<MessageBodyWriter>((MessageBodyWriter)o));
            }
            if (ContextResolver.class.isAssignableFrom(oClass)) {
                this.contextResolvers.add(new ProviderInfo<ContextResolver>((ContextResolver)o));
            }
            if (RequestHandler.class.isAssignableFrom(oClass)) {
                this.requestHandlers.add(new ProviderInfo<RequestHandler>((RequestHandler)o));
            }
            if (ResponseHandler.class.isAssignableFrom(oClass)) {
                this.responseHandlers.add(new ProviderInfo<ResponseHandler>((ResponseHandler)o));
            }
            if (ExceptionMapper.class.isAssignableFrom(oClass)) {
                this.exceptionMappers.add(new ProviderInfo<ExceptionMapper>((ExceptionMapper)o));
            }
            if (ResponseExceptionMapper.class.isAssignableFrom(oClass)) {
                this.responseExceptionMappers.add(new ProviderInfo<ResponseExceptionMapper>((ResponseExceptionMapper)o));
            }
            if (!ParameterHandler.class.isAssignableFrom(oClass)) continue;
            this.paramHandlers.add(new ProviderInfo<ParameterHandler>((ParameterHandler)o));
        }
        this.sortReaders();
        this.sortWriters();
        this.injectContexts(this.messageReaders, this.messageWriters, this.contextResolvers, this.requestHandlers, this.responseHandlers, this.exceptionMappers);
    }

    void injectContexts(List<?> ... providerLists) {
        for (List<?> list : providerLists) {
            for (Object p : list) {
                ProviderInfo pi = (ProviderInfo)p;
                InjectionUtils.injectContextProxies(pi, pi.getProvider());
            }
        }
    }

    private void sortReaders() {
        Collections.sort(this.messageReaders, new MessageBodyReaderComparator());
    }

    private void sortWriters() {
        Collections.sort(this.messageWriters, new MessageBodyWriterComparator());
    }

    private <T> MessageBodyReader<T> chooseMessageReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<MessageBodyReader> ep : this.messageReaders) {
            if (!this.matchesReaderCriterias(ep.getProvider(), type, genericType, annotations, mediaType)) continue;
            if (this == SHARED_FACTORY) {
                InjectionUtils.injectContextFields(ep.getProvider(), ep, m);
                InjectionUtils.injectContextMethods(ep.getProvider(), ep, m);
                return ep.getProvider();
            }
            ProviderFactory.handleMapper(candidates, ep, type, m, MessageBodyReader.class);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator());
        return (MessageBodyReader)candidates.get(0);
    }

    private <T> boolean matchesReaderCriterias(MessageBodyReader<T> ep, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderConsumeTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes, false);
        if (availableMimeTypes.size() == 0) {
            return false;
        }
        return ep.isReadable(type, genericType, annotations, mediaType);
    }

    private <T> MessageBodyWriter<T> chooseMessageWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<MessageBodyWriter> ep : this.messageWriters) {
            if (!this.matchesWriterCriterias(ep.getProvider(), type, genericType, annotations, mediaType)) continue;
            if (this == SHARED_FACTORY) {
                InjectionUtils.injectContextFields(ep.getProvider(), ep, m);
                InjectionUtils.injectContextMethods(ep.getProvider(), ep, m);
                return ep.getProvider();
            }
            ProviderFactory.handleMapper(candidates, ep, type, m, MessageBodyWriter.class);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator());
        return (MessageBodyWriter)candidates.get(0);
    }

    private <T> boolean matchesWriterCriterias(MessageBodyWriter<T> ep, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderProduceTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes, false);
        if (availableMimeTypes.size() == 0) {
            return false;
        }
        return ep.isWriteable(type, genericType, annotations, mediaType);
    }

    List<ProviderInfo<MessageBodyReader>> getMessageReaders() {
        return Collections.unmodifiableList(this.messageReaders);
    }

    List<ProviderInfo<MessageBodyWriter>> getMessageWriters() {
        return Collections.unmodifiableList(this.messageWriters);
    }

    List<ProviderInfo<ContextResolver>> getContextResolvers() {
        return Collections.unmodifiableList(this.contextResolvers);
    }

    public void registerUserProvider(Object provider) {
        this.setUserProviders(Collections.singletonList(provider));
    }

    public void setUserProviders(List<?> userProviders) {
        this.setProviders(userProviders.toArray());
    }

    public void setRequestPreprocessor(RequestPreprocessor rp) {
        this.requestPreprocessor = rp;
    }

    public RequestPreprocessor getRequestPreprocessor() {
        return this.requestPreprocessor;
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.messageReaders, this.messageWriters, this.contextResolvers, this.requestHandlers, this.responseHandlers, this.exceptionMappers);
        if (this != SHARED_FACTORY) {
            SHARED_FACTORY.clearThreadLocalProxies();
        }
    }

    void clearProxies(List<?> ... lists) {
        for (List<?> list : lists) {
            for (Object p : list) {
                ProviderInfo pi = (ProviderInfo)p;
                pi.clearThreadLocalProxies();
            }
        }
    }

    void clearProviders() {
        this.messageReaders.clear();
        this.messageWriters.clear();
        this.contextResolvers.clear();
        this.exceptionMappers.clear();
        this.requestHandlers.clear();
        this.responseHandlers.clear();
        this.paramHandlers.clear();
        this.responseExceptionMappers.clear();
    }

    public void setBus(Bus bus) {
        if (bus == null) {
            return;
        }
        for (ProviderInfo<MessageBodyReader> r : this.messageReaders) {
            this.injectProviderProperty(r.getProvider(), "setBus", Bus.class, bus);
        }
    }

    private boolean injectProviderProperty(Object provider, String mName, Class<?> pClass, Object pValue) {
        try {
            Method m = provider.getClass().getMethod(mName, pClass);
            m.invoke(provider, pValue);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setSchemaLocations(List<String> schemas) {
        boolean schemasMethodAvailable = false;
        for (ProviderInfo<MessageBodyReader> r : this.messageReaders) {
            schemasMethodAvailable = this.injectProviderProperty(r.getProvider(), "setSchemas", List.class, schemas);
        }
        if (!schemasMethodAvailable) {
            for (ProviderInfo<MessageBodyReader> r : ProviderFactory.SHARED_FACTORY.messageReaders) {
                try {
                    Method m = r.getProvider().getClass().getMethod("setSchemas", List.class);
                    Object provider = r.getProvider().getClass().newInstance();
                    m.invoke(provider, schemas);
                    this.registerUserProvider(provider);
                }
                catch (Exception ex) {}
            }
        }
    }

    public void initProviders(List<ClassResourceInfo> cris) {
        HashSet<ProviderInfo<Object>> set = new HashSet<ProviderInfo<Object>>();
        set.addAll(this.messageReaders);
        set.addAll(this.messageWriters);
        for (Object e : set) {
            Object provider = ((ProviderInfo)e).getProvider();
            if (!(provider instanceof AbstractConfigurableProvider)) continue;
            ((AbstractConfigurableProvider)provider).init(cris);
        }
        if (this != SHARED_FACTORY) {
            SHARED_FACTORY.initProviders(cris);
        }
    }

    private static int compareClasses(Object o1, Object o2) {
        Class<?> realClass2;
        Class cl1 = ClassHelper.getRealClass(o1);
        Class cl2 = ClassHelper.getRealClass(o2);
        Type[] types1 = ProviderFactory.getGenericInterfaces(cl1);
        Type[] types2 = ProviderFactory.getGenericInterfaces(cl2);
        if (types1.length == 0 && types2.length > 0) {
            return 1;
        }
        if (types1.length > 0 && types2.length == 0) {
            return -1;
        }
        Class<?> realClass1 = InjectionUtils.getActualType(types1[0]);
        if (realClass1 == (realClass2 = InjectionUtils.getActualType(types2[0]))) {
            return 0;
        }
        if (realClass1.isAssignableFrom(realClass2)) {
            return 1;
        }
        return -1;
    }

    private static Type[] getGenericInterfaces(Class<?> cls) {
        if (Object.class == cls) {
            return new Type[0];
        }
        Type[] types = cls.getGenericInterfaces();
        if (types.length > 0) {
            return types;
        }
        return ProviderFactory.getGenericInterfaces(cls.getSuperclass());
    }

    static {
        ProviderFactory.setDefaultProvider(SHARED_FACTORY, "org.apache.cxf.jaxrs.provider.JAXBElementProvider");
        ProviderFactory.setDefaultProvider(SHARED_FACTORY, "org.apache.cxf.jaxrs.provider.JSONProvider");
        SHARED_FACTORY.setProviders(new BinaryDataProvider(), new SourceProvider(), new FormEncodingProvider(), new PrimitiveTextProvider(), new MultipartProvider(), new WebApplicationExceptionMapper(), new WadlGenerator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassComparator
    implements Comparator<Object> {
        private ClassComparator() {
        }

        @Override
        public int compare(Object em1, Object em2) {
            return ProviderFactory.compareClasses(em1, em2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExceptionMapperComparator
    implements Comparator<ExceptionMapper<? extends Throwable>> {
        private ExceptionMapperComparator() {
        }

        @Override
        public int compare(ExceptionMapper<? extends Throwable> em1, ExceptionMapper<? extends Throwable> em2) {
            return ProviderFactory.compareClasses(em1, em2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyWriterComparator
    implements Comparator<ProviderInfo<MessageBodyWriter>> {
        private MessageBodyWriterComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyWriter> p1, ProviderInfo<MessageBodyWriter> p2) {
            MessageBodyWriter e1 = p1.getProvider();
            MessageBodyWriter e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e1));
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e2));
            return JAXRSUtils.compareSortedMediaTypes(types1, types2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyReaderComparator
    implements Comparator<ProviderInfo<MessageBodyReader>> {
        private MessageBodyReaderComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyReader> p1, ProviderInfo<MessageBodyReader> p2) {
            MessageBodyReader e1 = p1.getProvider();
            MessageBodyReader e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.getProviderConsumeTypes(e1);
            types1 = JAXRSUtils.sortMediaTypes(types1);
            List<MediaType> types2 = JAXRSUtils.getProviderConsumeTypes(e2);
            types2 = JAXRSUtils.sortMediaTypes(types2);
            return JAXRSUtils.compareSortedMediaTypes(types1, types2);
        }
    }
}

