/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.staxutils.W3CNamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class W3CDOMStreamWriter
implements XMLStreamWriter {
    static final String XML_NS = "http://www.w3.org/2000/xmlns/";
    private Stack<Node> stack = new Stack();
    private Document document;
    private Node currentNode;
    private NamespaceContext context = new W3CNamespaceContext();
    private boolean nsRepairing;
    private Map properties = Collections.EMPTY_MAP;

    public W3CDOMStreamWriter() throws ParserConfigurationException {
        this.document = XMLUtils.newDocument();
    }

    public W3CDOMStreamWriter(DocumentBuilder builder) {
        this.document = builder.newDocument();
    }

    public W3CDOMStreamWriter(Document document) {
        this.document = document;
    }

    public W3CDOMStreamWriter(DocumentFragment frag) {
        this.document = frag.getOwnerDocument();
        this.currentNode = frag;
    }

    public W3CDOMStreamWriter(Element e) {
        this.document = e.getOwnerDocument();
        this.currentNode = e;
        ((W3CNamespaceContext)this.context).setElement(e);
    }

    public Element getCurrentNode() {
        if (this.currentNode instanceof Element) {
            return (Element)this.currentNode;
        }
        return null;
    }

    public DocumentFragment getCurrentFragment() {
        if (this.currentNode instanceof DocumentFragment) {
            return (DocumentFragment)this.currentNode;
        }
        return null;
    }

    public void setNsRepairing(boolean b) {
        this.nsRepairing = b;
    }

    public boolean isNsRepairing() {
        return this.nsRepairing;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public Document getDocument() {
        return this.document;
    }

    public void writeStartElement(String local) throws XMLStreamException {
        this.newChild(this.document.createElementNS(null, local));
    }

    protected void newChild(Element element) {
        this.setChild(element, true);
    }

    protected void setChild(Element element, boolean append) {
        if (this.currentNode != null) {
            this.stack.push(this.currentNode);
            if (append) {
                this.currentNode.appendChild(element);
            }
        } else if (append) {
            this.document.appendChild(element);
        }
        if (!(this.context instanceof W3CNamespaceContext)) {
            this.context = new W3CNamespaceContext();
        }
        ((W3CNamespaceContext)this.context).setElement(element);
        this.currentNode = element;
    }

    public void writeStartElement(String namespace, String local) throws XMLStreamException {
        this.newChild(this.document.createElementNS(namespace, local));
    }

    public void writeStartElement(String prefix, String local, String namespace) throws XMLStreamException {
        if (prefix == null || prefix.equals("")) {
            this.writeStartElement(namespace, local);
        } else {
            this.newChild(this.document.createElementNS(namespace, prefix + ":" + local));
            if (this.nsRepairing && !prefix.equals(this.getNamespaceContext().getPrefix(namespace))) {
                this.writeNamespace(prefix, namespace);
            }
        }
    }

    public void writeEmptyElement(String namespace, String local) throws XMLStreamException {
        this.writeStartElement(namespace, local);
        this.writeEndElement();
    }

    public void writeEmptyElement(String prefix, String namespace, String local) throws XMLStreamException {
        this.writeStartElement(prefix, namespace, local);
        this.writeEndElement();
    }

    public void writeEmptyElement(String local) throws XMLStreamException {
        this.writeStartElement(local);
        this.writeEndElement();
    }

    public void writeEndElement() throws XMLStreamException {
        this.currentNode = this.stack.size() > 0 ? this.stack.pop() : null;
        if (this.context instanceof W3CNamespaceContext && this.currentNode instanceof Element) {
            ((W3CNamespaceContext)this.context).setElement((Element)this.currentNode);
        } else if (this.context instanceof MapNamespaceContext) {
            ((MapNamespaceContext)this.context).setTargetNode(this.currentNode);
        }
    }

    public void writeEndDocument() throws XMLStreamException {
    }

    public void writeAttribute(String local, String value) throws XMLStreamException {
        Attr a = local.startsWith("xmlns") && (local.length() == 5 || local.charAt(5) == ':') ? this.document.createAttributeNS(XML_NS, local) : this.document.createAttributeNS(null, local);
        a.setValue(value);
        ((Element)this.currentNode).setAttributeNode(a);
    }

    public void writeAttribute(String prefix, String namespace, String local, String value) throws XMLStreamException {
        if (prefix.length() > 0) {
            local = prefix + ":" + local;
        }
        Attr a = this.document.createAttributeNS(namespace, local);
        a.setValue(value);
        ((Element)this.currentNode).setAttributeNodeNS(a);
        if (this.nsRepairing && !prefix.equals(this.getNamespaceContext().getPrefix(namespace))) {
            this.writeNamespace(prefix, namespace);
        }
    }

    public void writeAttribute(String namespace, String local, String value) throws XMLStreamException {
        Attr a = this.document.createAttributeNS(namespace, local);
        a.setValue(value);
        ((Element)this.currentNode).setAttributeNodeNS(a);
    }

    public void writeNamespace(String prefix, String namespace) throws XMLStreamException {
        if (prefix.length() == 0) {
            this.writeDefaultNamespace(namespace);
        } else {
            Attr attr = this.document.createAttributeNS(XML_NS, "xmlns:" + prefix);
            attr.setValue(namespace);
            ((Element)this.currentNode).setAttributeNodeNS(attr);
        }
    }

    public void writeDefaultNamespace(String namespace) throws XMLStreamException {
        Attr attr = this.document.createAttributeNS(XML_NS, "xmlns");
        attr.setValue(namespace);
        ((Element)this.currentNode).setAttributeNodeNS(attr);
    }

    public void writeComment(String value) throws XMLStreamException {
        if (this.currentNode == null) {
            this.document.appendChild(this.document.createComment(value));
        } else {
            this.currentNode.appendChild(this.document.createComment(value));
        }
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        if (this.currentNode == null) {
            this.document.appendChild(this.document.createProcessingInstruction(target, null));
        } else {
            this.currentNode.appendChild(this.document.createProcessingInstruction(target, null));
        }
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        if (this.currentNode == null) {
            this.document.appendChild(this.document.createProcessingInstruction(target, data));
        } else {
            this.currentNode.appendChild(this.document.createProcessingInstruction(target, data));
        }
    }

    public void writeCData(String data) throws XMLStreamException {
        this.currentNode.appendChild(this.document.createCDATASection(data));
    }

    public void writeDTD(String arg0) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public void writeEntityRef(String ref) throws XMLStreamException {
        this.currentNode.appendChild(this.document.createEntityReference(ref));
    }

    public void writeStartDocument() throws XMLStreamException {
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        try {
            this.document.setXmlVersion(version);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        try {
            this.document.setXmlVersion(version);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.currentNode.appendChild(this.document.createTextNode(text));
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writeCharacters(new String(text, start, len));
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.context == null ? null : this.context.getPrefix(uri);
    }

    public void setPrefix(String arg0, String arg1) throws XMLStreamException {
    }

    public void setDefaultNamespace(String arg0) throws XMLStreamException {
    }

    public void setNamespaceContext(NamespaceContext ctx) throws XMLStreamException {
        this.context = ctx;
    }

    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    public Object getProperty(String prop) throws IllegalArgumentException {
        return this.properties.get(prop);
    }

    public void close() throws XMLStreamException {
    }

    public void flush() throws XMLStreamException {
    }
}

