/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.staxutils.CachingXmlEventWriter;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSOutInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSOutInterceptor.class);

    public JAXRSOutInterceptor() {
        super("marshal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message message) {
        try {
            this.processResponse(message);
        }
        finally {
            ProviderFactory.getInstance(message).clearThreadLocalProxies();
            ClassResourceInfo cri = (ClassResourceInfo)message.getExchange().get("root.resource.class");
            if (cri != null) {
                cri.clearThreadLocalProxies();
            }
        }
    }

    private void processResponse(Message message) {
        if (this.isResponseAlreadyCommited(message)) {
            return;
        }
        MessageContentsList objs = MessageContentsList.getContentsList(message);
        if (objs == null || objs.size() == 0) {
            return;
        }
        if (objs.get(0) != null) {
            Object responseObj = objs.get(0);
            Response response = null;
            response = objs.get(0) instanceof Response ? (Response)responseObj : Response.ok(responseObj).build();
            Exchange exchange = message.getExchange();
            OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class.getName());
            List<ProviderInfo<ResponseHandler>> handlers = ProviderFactory.getInstance(message).getResponseHandlers();
            for (ProviderInfo<ResponseHandler> rh : handlers) {
                Response r = rh.getProvider().handleResponse(message, ori, response);
                if (r == null) continue;
                response = r;
            }
            this.serializeMessage(message, response, ori, true);
        } else {
            message.put(Message.RESPONSE_CODE, 204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeMessage(Message message, Response response, OperationResourceInfo ori, boolean firstTry) {
        int status = response.getStatus();
        Object responseObj = response.getEntity();
        if (status == 200 && !this.isResponseNull(responseObj) && firstTry && ori != null && JAXRSUtils.headMethodPossible(ori.getHttpMethod(), (String)message.getExchange().getInMessage().get(Message.HTTP_REQUEST_METHOD))) {
            LOG.info(new org.apache.cxf.common.i18n.Message("HEAD_WITHOUT_ENTITY", BUNDLE, new Object[0]).toString());
            responseObj = null;
        }
        if (status == -1) {
            status = this.isResponseNull(responseObj) ? 204 : 200;
        }
        message.put(Message.RESPONSE_CODE, status);
        Map theHeaders = (Map)message.get(Message.PROTOCOL_HEADERS);
        if (firstTry && theHeaders != null) {
            theHeaders.putAll(response.getMetadata());
        } else {
            message.put(Message.PROTOCOL_HEADERS, response.getMetadata());
        }
        MultivaluedMap responseHeaders = (MultivaluedMap)message.get(Message.PROTOCOL_HEADERS);
        this.setResponseDate((MultivaluedMap<String, Object>)responseHeaders, firstTry);
        if (this.isResponseNull(responseObj)) {
            return;
        }
        List<MediaType> availableContentTypes = this.computeAvailableContentTypes(message, response);
        Method invoked = null;
        if (firstTry) {
            invoked = ori == null ? null : ori.getMethodToInvoke();
        }
        Class<?> targetType = this.getRawResponseClass(responseObj);
        Type genericType = this.getGenericResponseType(ori == null ? null : ori.getAnnotatedMethod(), responseObj);
        if (genericType instanceof TypeVariable) {
            genericType = InjectionUtils.getSuperType(ori.getClassResourceInfo().getServiceClass(), (TypeVariable)genericType);
        }
        MessageBodyWriter<?> writer = null;
        MediaType responseType = null;
        for (MediaType type : availableContentTypes) {
            writer = ProviderFactory.getInstance(message).createMessageBodyWriter(targetType, genericType, invoked != null ? invoked.getAnnotations() : new Annotation[]{}, type, message);
            if (writer == null) continue;
            responseType = type;
            break;
        }
        OutputStream outOriginal = message.getContent(OutputStream.class);
        if (writer == null) {
            message.put(Message.RESPONSE_CODE, 500);
            this.writeResponseErrorMessage(outOriginal, "NO_MSG_WRITER", targetType.getSimpleName());
            return;
        }
        boolean enabled = this.checkBufferingMode(message, writer, firstTry);
        Object entity = this.getEntity(responseObj);
        try {
            responseType = this.checkFinalContentType(responseType);
            LOG.fine("Response content type is: " + responseType.toString());
            message.put("Content-Type", responseType.toString());
            LOG.fine("Response EntityProvider is: " + writer.getClass().getName());
            try {
                writer.writeTo(entity, targetType, genericType, invoked != null ? invoked.getAnnotations() : new Annotation[]{}, responseType, responseHeaders, message.getContent(OutputStream.class));
                Object newContentType = responseHeaders.getFirst((Object)"Content-Type");
                if (newContentType != null) {
                    message.put("Content-Type", newContentType.toString());
                }
                this.checkCachedStream(message, outOriginal, enabled);
            }
            finally {
                if (enabled) {
                    message.setContent(OutputStream.class, outOriginal);
                    message.put(XMLStreamWriter.class.getName(), null);
                }
            }
        }
        catch (IOException ex) {
            this.handleWriteException(message, response, ori, ex, entity, firstTry);
        }
        catch (Throwable ex) {
            this.handleWriteException(message, response, ori, ex, entity, firstTry);
        }
    }

    private boolean isResponseNull(Object o) {
        return o == null || GenericEntity.class.isAssignableFrom(o.getClass()) && ((GenericEntity)o).getEntity() == null;
    }

    private Object getEntity(Object o) {
        return GenericEntity.class.isAssignableFrom(o.getClass()) ? ((GenericEntity)o).getEntity() : o;
    }

    private boolean checkBufferingMode(Message m, MessageBodyWriter w, boolean firstTry) {
        boolean enabled;
        if (!firstTry) {
            return false;
        }
        Object outBuf = m.getContextualProperty("org.apache.cxf.output.buffering");
        boolean bl = enabled = Boolean.TRUE.equals(outBuf) || "true".equals(outBuf);
        if (!enabled && outBuf == null) {
            enabled = InjectionUtils.invokeBooleanGetter(w, "getEnableBuffering");
        }
        if (enabled) {
            boolean streamingOn = InjectionUtils.invokeBooleanGetter(w, "getEnableStreaming");
            if (streamingOn) {
                m.setContent(XMLStreamWriter.class, new CachingXmlEventWriter());
            } else {
                m.setContent(OutputStream.class, new CachedOutputStream());
            }
        }
        return enabled;
    }

    private void checkCachedStream(Message m, OutputStream osOriginal, boolean enabled) throws Exception {
        CachedOutputStream cos;
        OutputStream os;
        XMLStreamWriter writer = null;
        writer = enabled ? m.getContent(XMLStreamWriter.class) : (XMLStreamWriter)m.get(XMLStreamWriter.class.getName());
        if (writer instanceof CachingXmlEventWriter) {
            CachingXmlEventWriter cache = (CachingXmlEventWriter)writer;
            if (cache.getEvents().size() != 0) {
                XMLStreamWriter origWriter = StaxUtils.createXMLStreamWriter(osOriginal);
                for (XMLEvent event : cache.getEvents()) {
                    StaxUtils.writeEvent(event, origWriter);
                }
            }
            m.setContent(XMLStreamWriter.class, null);
            return;
        }
        if (enabled && (os = m.getContent(OutputStream.class)) != osOriginal && os instanceof CachedOutputStream && (cos = (CachedOutputStream)os).size() != 0) {
            cos.writeCacheTo(osOriginal);
        }
    }

    private void handleWriteException(Message message, Response response, OperationResourceInfo ori, Throwable ex, Object responseObj, boolean firstTry) {
        OutputStream out = message.getContent(OutputStream.class);
        if (firstTry) {
            Response excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
            if (excResponse != null) {
                this.serializeMessage(message, excResponse, ori, false);
            }
        } else {
            message.put(Message.RESPONSE_CODE, 500);
            this.writeResponseErrorMessage(out, "SERIALIZE_ERROR", responseObj.getClass().getSimpleName());
        }
    }

    private void writeResponseErrorMessage(OutputStream out, String errorString, String parameter) {
        try {
            org.apache.cxf.common.i18n.Message message = new org.apache.cxf.common.i18n.Message(errorString, BUNDLE, parameter);
            LOG.warning(message.toString());
            out.write(message.toString().getBytes("UTF-8"));
        }
        catch (IOException another) {
            // empty catch block
        }
    }

    private List<MediaType> computeAvailableContentTypes(Message message, Response response) {
        Object contentType = response.getMetadata().getFirst((Object)"Content-Type");
        Exchange exchange = message.getExchange();
        List<MediaType> produceTypes = null;
        OperationResourceInfo operation = exchange.get(OperationResourceInfo.class);
        if (contentType != null) {
            return Collections.singletonList(MediaType.valueOf((String)contentType.toString()));
        }
        produceTypes = operation != null ? operation.getProduceTypes() : Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM_TYPE);
        List<MediaType> acceptContentTypes = (List<MediaType>)exchange.get("Accept");
        if (acceptContentTypes == null) {
            acceptContentTypes = Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        return JAXRSUtils.intersectMimeTypes(acceptContentTypes, produceTypes);
    }

    private Class<?> getRawResponseClass(Object targetObject) {
        if (GenericEntity.class.isAssignableFrom(targetObject.getClass())) {
            return ((GenericEntity)targetObject).getRawType();
        }
        return targetObject.getClass();
    }

    private Type getGenericResponseType(Method invoked, Object targetObject) {
        if (GenericEntity.class.isAssignableFrom(targetObject.getClass())) {
            return ((GenericEntity)targetObject).getType();
        }
        return invoked == null ? targetObject.getClass() : invoked.getGenericReturnType();
    }

    private MediaType checkFinalContentType(MediaType mt) {
        if (mt.isWildcardType() || mt.isWildcardSubtype()) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        if (mt.getParameters().containsKey("q")) {
            return MediaType.valueOf((String)JAXRSUtils.removeMediaTypeParameter(mt, "q"));
        }
        return mt;
    }

    private void setResponseDate(MultivaluedMap<String, Object> headers, boolean firstTry) {
        if (!firstTry) {
            return;
        }
        SimpleDateFormat format = HttpUtils.getHttpDateFormat();
        headers.putSingle((Object)"Date", (Object)format.format(new Date()));
    }

    private boolean isResponseAlreadyCommited(Message m) {
        return Boolean.TRUE.equals(m.getExchange().get("http.response.done"));
    }
}

