/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.NamedItem;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageContainer
extends AbstractPropertiesHolder
implements NamedItem {
    protected QName mName;
    private OperationInfo operation;
    private Map<QName, MessagePartInfo> messageParts = new LinkedHashMap<QName, MessagePartInfo>(4);

    AbstractMessageContainer(OperationInfo op, QName nm) {
        this.operation = op;
        this.mName = nm;
    }

    @Override
    public QName getName() {
        return this.mName;
    }

    public OperationInfo getOperation() {
        return this.operation;
    }

    public MessagePartInfo addMessagePart(QName name) {
        if (name == null) {
            throw new IllegalArgumentException("Invalid name [" + name + "]");
        }
        MessagePartInfo part = new MessagePartInfo(name, this);
        this.addMessagePart(part);
        return part;
    }

    public QName getMessagePartQName(String name) {
        return new QName(this.getOperation().getInterface().getName().getNamespaceURI(), name);
    }

    public MessagePartInfo addMessagePart(String name) {
        return this.addMessagePart(this.getMessagePartQName(name));
    }

    public void addMessagePart(MessagePartInfo part) {
        if (this.messageParts.containsKey(part.getName())) {
            part.setIndex(this.messageParts.get(part.getName()).getIndex());
        } else {
            part.setIndex(this.messageParts.size());
        }
        this.messageParts.put(part.getName(), part);
    }

    public int getMessagePartIndex(MessagePartInfo part) {
        int i = 0;
        for (MessagePartInfo p : this.messageParts.values()) {
            if (part == p) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public MessagePartInfo getMessagePartByIndex(int i) {
        for (MessagePartInfo p : this.messageParts.values()) {
            if (p.getIndex() != i) continue;
            return p;
        }
        return null;
    }

    public void removeMessagePart(QName name) {
        MessagePartInfo messagePart = this.getMessagePart(name);
        if (messagePart != null) {
            this.messageParts.remove(name);
        }
    }

    public MessagePartInfo getMessagePart(QName name) {
        MessagePartInfo mpi = this.messageParts.get(name);
        if (mpi == null) {
            for (MessagePartInfo mpi2 : this.messageParts.values()) {
                if (!name.equals(mpi2.getConcreteName())) continue;
                return mpi2;
            }
        }
        return mpi;
    }

    public MessagePartInfo getMessagePart(int n) {
        if (n == -1) {
            return null;
        }
        for (MessagePartInfo mpi : this.messageParts.values()) {
            if (n == 0) {
                return mpi;
            }
            --n;
        }
        return null;
    }

    public List<MessagePartInfo> getMessageParts() {
        return Collections.unmodifiableList(new ArrayList<MessagePartInfo>(this.messageParts.values()));
    }

    public int size() {
        return this.messageParts.size();
    }
}

