/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.TransportBinding;
import org.apache.cxf.ws.security.policy.model.TransportToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportBindingBuilder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.TRANSPORT_BINDING, SP12Constants.TRANSPORT_BINDING);
    PolicyBuilder builder;

    public TransportBindingBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    @Override
    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        TransportBinding transportBinding = new TransportBinding(consts);
        Policy policy = this.builder.getPolicy(DOMUtils.getFirstElement(element));
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), transportBinding, consts);
        }
        return transportBinding;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    private void processAlternative(List assertionList, TransportBinding parent, SPConstants consts) {
        for (Assertion primitive : assertionList) {
            QName name = primitive.getName();
            if (!consts.getNamespace().equals(name.getNamespaceURI())) continue;
            if (name.getLocalPart().equals("AlgorithmSuite")) {
                parent.setAlgorithmSuite((AlgorithmSuite)primitive);
                continue;
            }
            if (name.getLocalPart().equals("TransportToken")) {
                parent.setTransportToken((TransportToken)primitive);
                continue;
            }
            if (name.getLocalPart().equals("IncludeTimestamp")) {
                parent.setIncludeTimestamp(true);
                continue;
            }
            if (name.getLocalPart().equals("Layout")) {
                parent.setLayout((Layout)primitive);
                continue;
            }
            if (name.getLocalPart().equals("SignedSupportingTokens")) {
                parent.setSignedSupportingToken((SupportingToken)primitive);
                continue;
            }
            if (!name.getLocalPart().equals("SignedEndorsingSupportingTokens")) continue;
            parent.setSignedEndorsingSupportingTokens((SupportingToken)primitive);
        }
    }

    @Override
    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

