/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSServiceFactoryBean
extends AbstractServiceFactoryBean {
    protected List<ClassResourceInfo> classResourceInfos = new ArrayList<ClassResourceInfo>();
    protected Map<Class, ResourceProvider> resourceProviders = new HashMap<Class, ResourceProvider>();
    private Invoker invoker;
    private Executor executor;
    private Map<String, Object> properties;
    private boolean enableStatic;

    public void setEnableStaticResolution(boolean staticResolution) {
        this.enableStatic = staticResolution;
    }

    public boolean resourcesAvailable() {
        return !this.classResourceInfos.isEmpty();
    }

    @Override
    public Service create() {
        this.initializeServiceModel();
        this.initializeDefaultInterceptors();
        if (this.invoker != null) {
            this.getService().setInvoker(this.getInvoker());
        } else {
            this.getService().setInvoker(this.createInvoker());
        }
        if (this.getExecutor() != null) {
            this.getService().setExecutor(this.getExecutor());
        }
        if (this.getDataBinding() != null) {
            this.getService().setDataBinding(this.getDataBinding());
        }
        return this.getService();
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public List<Class> getResourceClasses() {
        ArrayList<Class> resourceClasses = new ArrayList<Class>();
        for (ClassResourceInfo cri : this.classResourceInfos) {
            resourceClasses.add(cri.getResourceClass());
        }
        return resourceClasses;
    }

    public List<ClassResourceInfo> getClassResourceInfo() {
        return Collections.unmodifiableList(this.classResourceInfos);
    }

    public void setResourceClasses(List<Class> classes) {
        for (Class resourceClass : classes) {
            ClassResourceInfo classResourceInfo = ResourceUtils.createClassResourceInfo(resourceClass, resourceClass, true, this.enableStatic);
            if (classResourceInfo == null) continue;
            this.classResourceInfos.add(classResourceInfo);
        }
        this.injectContexts();
    }

    public void setResourceClasses(Class ... classes) {
        this.setResourceClasses(Arrays.asList(classes));
    }

    public void setResourceClassesFromBeans(List<Object> beans) {
        for (Object bean : beans) {
            Class realClass = ClassHelper.getRealClass(bean);
            ClassResourceInfo classResourceInfo = ResourceUtils.createClassResourceInfo(bean.getClass(), realClass, true, this.enableStatic);
            if (classResourceInfo == null) continue;
            this.classResourceInfos.add(classResourceInfo);
            classResourceInfo.setResourceProvider(new SingletonResourceProvider(bean));
        }
    }

    private void injectContexts() {
        for (ClassResourceInfo cri : this.classResourceInfos) {
            if (!cri.isSingleton()) continue;
            InjectionUtils.injectContextProxies(cri, cri.getResourceProvider().getInstance());
        }
    }

    public void setResourceProvider(Class c, ResourceProvider rp) {
        this.resourceProviders.put(c, rp);
    }

    protected void initializeServiceModel() {
        this.updateClassResourceProviders();
        JAXRSServiceImpl service = new JAXRSServiceImpl(this.classResourceInfos);
        this.setService(service);
        if (this.properties != null) {
            service.putAll(this.properties);
        }
    }

    private void updateClassResourceProviders() {
        for (ClassResourceInfo cri : this.classResourceInfos) {
            if (cri.getResourceProvider() != null) continue;
            ResourceProvider rp = this.resourceProviders.get(cri.getResourceClass());
            if (rp != null) {
                cri.setResourceProvider(rp);
                continue;
            }
            rp = new PerRequestResourceProvider(cri.getResourceClass());
            cri.setResourceProvider(rp);
        }
        this.injectContexts();
    }

    protected Invoker createInvoker() {
        return new JAXRSInvoker();
    }
}

