/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolContainer;
import org.apache.cxf.tools.common.toolspec.ToolSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToolRunner {
    private static final Logger LOG = LogUtils.getL7dLogger(ToolRunner.class);

    private ToolRunner() {
    }

    public static void runTool(Class<? extends ToolContainer> clz, InputStream toolspecStream, boolean validate, String[] args) throws Exception {
        ToolRunner.runTool(clz, toolspecStream, validate, args, true);
    }

    public static void runTool(Class<? extends ToolContainer> clz, InputStream toolspecStream, boolean validate, String[] args, ToolContext context) throws Exception {
        ToolRunner.runTool(clz, toolspecStream, validate, args, true, context);
    }

    public static void runTool(Class<? extends ToolContainer> clz, InputStream toolspecStream, boolean validate, String[] args, boolean exitOnFinish) throws Exception {
        ToolRunner.runTool(clz, toolspecStream, validate, args, true, null);
    }

    public static void runTool(Class<? extends ToolContainer> clz, InputStream toolspecStream, boolean validate, String[] args, boolean exitOnFinish, ToolContext context) throws Exception {
        ToolContainer container = null;
        try {
            Constructor<? extends ToolContainer> cons = clz.getConstructor(ToolSpec.class);
            container = cons.newInstance(new ToolSpec(toolspecStream, validate));
        }
        catch (Exception ex) {
            Message message = new Message("CLZ_CANNOT_BE_CONSTRUCTED", LOG, clz.getName());
            LOG.log(Level.SEVERE, message.toString());
            throw new ToolException(message, (Throwable)ex);
        }
        container.setArguments(args);
        container.setContext(context);
        container.execute(exitOnFinish);
    }
}

