/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.http.UrlUtilities;
import org.apache.cxf.transport.http.WSDLQueryException;
import org.apache.cxf.transports.http.StemMatchingQueryHandler;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLQueryHandler
implements StemMatchingQueryHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLQueryHandler.class, "QueryMessages");
    private Bus bus;

    @Override
    public String getResponseContentType(String baseUri, String ctx) {
        if (baseUri.toLowerCase().contains("?wsdl") || baseUri.toLowerCase().contains("?xsd=")) {
            return "text/xml";
        }
        return null;
    }

    @Override
    public boolean isRecognizedQuery(String baseUri, String ctx, EndpointInfo endpointInfo, boolean contextMatchExact) {
        int idx;
        Map<String, String> map;
        if (baseUri != null && baseUri.contains("?") && (baseUri.toLowerCase().contains("wsdl") || baseUri.toLowerCase().contains("xsd=")) && ((map = UrlUtilities.parseQueryString(baseUri.substring((idx = baseUri.indexOf("?")) + 1))).containsKey("wsdl") || map.containsKey("xsd"))) {
            if (contextMatchExact) {
                return endpointInfo.getAddress().contains(ctx);
            }
            return endpointInfo.getAddress().contains(UrlUtilities.getStem(baseUri.substring(0, idx)));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeResponse(String baseUri, String ctxUri, EndpointInfo endpointInfo, OutputStream os) {
        try {
            Document doc;
            int idx = baseUri.toLowerCase().indexOf("?");
            Map<String, String> params = UrlUtilities.parseQueryString(baseUri.substring(idx + 1));
            String base = baseUri.substring(0, baseUri.toLowerCase().indexOf("?"));
            String wsdl = params.get("wsdl");
            String xsd = params.get("xsd");
            Map<String, Definition> mp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName()));
            Map<String, SchemaReference> smp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName() + ".Schemas"));
            if (mp == null) {
                endpointInfo.getService().setProperty(WSDLQueryHandler.class.getName(), new ConcurrentHashMap());
                mp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName()));
            }
            if (smp == null) {
                endpointInfo.getService().setProperty(WSDLQueryHandler.class.getName() + ".Schemas", new ConcurrentHashMap());
                smp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName() + ".Schemas"));
            }
            if (!mp.containsKey("")) {
                Definition def = new ServiceWSDLBuilder(this.bus, endpointInfo.getService()).build();
                mp.put("", def);
                this.updateDefinition(def, mp, smp, base, endpointInfo);
            }
            if (xsd == null) {
                Object wsdl2;
                Definition def = (Definition)mp.get(wsdl);
                if (def == null && (wsdl2 = WSDLQueryHandler.resolveWithCatalogs(OASISCatalogManager.getCatalogManager(this.bus), wsdl, base)) != null) {
                    def = (Definition)mp.get(wsdl2);
                }
                if (def == null) {
                    throw new WSDLQueryException(new Message("WSDL_NOT_FOUND", LOG, wsdl), null);
                }
                wsdl2 = def;
                synchronized (wsdl2) {
                    if (endpointInfo.getProperty("publishedEndpointUrl") != null) {
                        String publishingUrl = String.valueOf(endpointInfo.getProperty("publishedEndpointUrl"));
                        this.updatePublishedEndpointUrl(publishingUrl, def, endpointInfo.getName());
                    }
                    WSDLWriter wsdlWriter = this.bus.getExtension(WSDLManager.class).getWSDLFactory().newWSDLWriter();
                    def.setExtensionRegistry(this.bus.getExtension(WSDLManager.class).getExtensionRegistry());
                    doc = wsdlWriter.getDocument(def);
                }
            } else {
                String xsd2;
                SchemaReference si = (SchemaReference)smp.get(xsd);
                if (si == null && (xsd2 = WSDLQueryHandler.resolveWithCatalogs(OASISCatalogManager.getCatalogManager(this.bus), xsd, base)) != null) {
                    si = (SchemaReference)smp.get(xsd2);
                }
                if (si == null) {
                    throw new WSDLQueryException(new Message("SCHEMA_NOT_FOUND", LOG, wsdl), null);
                }
                String uri = si.getReferencedSchema().getDocumentBaseURI();
                uri = WSDLQueryHandler.resolveWithCatalogs(OASISCatalogManager.getCatalogManager(this.bus), uri, si.getReferencedSchema().getDocumentBaseURI());
                if (uri == null) {
                    uri = si.getReferencedSchema().getDocumentBaseURI();
                }
                ResourceManagerWSDLLocator rml = new ResourceManagerWSDLLocator(uri, this.bus);
                InputSource src = rml.getBaseInputSource();
                doc = XMLUtils.getParser().parse(src);
            }
            this.updateDoc(doc, base, mp, smp);
            String enc = doc.getXmlEncoding();
            if (enc == null) {
                enc = "utf-8";
            }
            XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(os, enc);
            StaxUtils.writeNode(doc, writer, true);
            writer.flush();
        }
        catch (WSDLQueryException wex) {
            throw wex;
        }
        catch (Exception wex) {
            throw new WSDLQueryException(new Message("COULD_NOT_PROVIDE_WSDL", LOG, baseUri), (Throwable)wex);
        }
    }

    private void updateDoc(Document doc, String base, Map<String, Definition> mp, Map<String, SchemaReference> smp) {
        String sl;
        Element el;
        int x;
        NodeList nl = doc.getDocumentElement().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (x = 0; x < nl.getLength(); ++x) {
            el = (Element)nl.item(x);
            sl = el.getAttribute("schemaLocation");
            if (!smp.containsKey(sl)) continue;
            el.setAttribute("schemaLocation", base + "?xsd=" + sl);
        }
        nl = doc.getDocumentElement().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        for (x = 0; x < nl.getLength(); ++x) {
            el = (Element)nl.item(x);
            sl = el.getAttribute("schemaLocation");
            if (!smp.containsKey(sl)) continue;
            el.setAttribute("schemaLocation", base + "?xsd=" + sl);
        }
        nl = doc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        for (x = 0; x < nl.getLength(); ++x) {
            el = (Element)nl.item(x);
            sl = el.getAttribute("location");
            if (!mp.containsKey(sl)) continue;
            el.setAttribute("location", base + "?wsdl=" + sl);
        }
        doc.setXmlStandalone(true);
    }

    static String resolveWithCatalogs(OASISCatalogManager catalogs, String start, String base) {
        String resolvedSchemaLocation = null;
        try {
            resolvedSchemaLocation = catalogs.getCatalog().resolveSystem(start);
            if (resolvedSchemaLocation == null) {
                resolvedSchemaLocation = catalogs.getCatalog().resolveURI(start);
            }
            if (resolvedSchemaLocation == null) {
                resolvedSchemaLocation = catalogs.getCatalog().resolvePublic(start, base);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return resolvedSchemaLocation;
    }

    protected void updateDefinition(Definition def, Map<String, Definition> done, Map<String, SchemaReference> doneSchemas, String base, EndpointInfo ei) {
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager(this.bus);
        Collection<List> imports = CastUtils.cast(def.getImports().values());
        for (List lst : imports) {
            List<Import> impLst = CastUtils.cast(lst);
            for (Import imp : impLst) {
                String start = imp.getLocationURI();
                String resolvedSchemaLocation = WSDLQueryHandler.resolveWithCatalogs(catalogs, start, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        new URL(start);
                    }
                    catch (MalformedURLException e) {
                        if (done.put(start, imp.getDefinition()) != null) continue;
                        this.updateDefinition(imp.getDefinition(), done, doneSchemas, base, ei);
                    }
                    continue;
                }
                if (done.put(start, imp.getDefinition()) != null) continue;
                done.put(resolvedSchemaLocation, imp.getDefinition());
                this.updateDefinition(imp.getDefinition(), done, doneSchemas, base, ei);
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement el : CastUtils.cast(types.getExtensibilityElements(), ExtensibilityElement.class)) {
                if (!(el instanceof Schema)) continue;
                Schema see = (Schema)el;
                this.updateSchemaImports(see, doneSchemas, base);
            }
        }
    }

    protected void updatePublishedEndpointUrl(String publishingUrl, Definition def, QName name) {
        Collection<Service> services = CastUtils.cast(def.getAllServices().values());
        for (Service service : services) {
            Collection<Port> ports = CastUtils.cast(service.getPorts().values());
            if (ports.isEmpty()) continue;
            if (name == null) {
                this.setSoapAddressLocationOn(ports.iterator().next(), publishingUrl);
                break;
            }
            for (Port port : ports) {
                if (!name.getLocalPart().equals(port.getName())) continue;
                this.setSoapAddressLocationOn(port, publishingUrl);
            }
        }
    }

    private void setSoapAddressLocationOn(Port port, String url) {
        List extensions = port.getExtensibilityElements();
        for (Object extension : extensions) {
            if (extension instanceof SOAP12Address) {
                ((SOAP12Address)extension).setLocationURI(url);
                continue;
            }
            if (!(extension instanceof SOAPAddress)) continue;
            ((SOAPAddress)extension).setLocationURI(url);
        }
    }

    protected void updateSchemaImports(Schema schema, Map<String, SchemaReference> doneSchemas, String base) {
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager(this.bus);
        Collection<List> imports = CastUtils.cast(schema.getImports().values());
        for (List lst : imports) {
            List<SchemaImport> impLst = CastUtils.cast(lst);
            for (SchemaImport imp : impLst) {
                String start = imp.getSchemaLocationURI();
                if (start == null || doneSchemas.containsKey(start)) continue;
                String resolvedSchemaLocation = WSDLQueryHandler.resolveWithCatalogs(catalogs, start, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        new URL(start);
                    }
                    catch (MalformedURLException e) {
                        if (doneSchemas.put(start, (SchemaReference)imp) != null) continue;
                        this.updateSchemaImports(imp.getReferencedSchema(), doneSchemas, base);
                    }
                    continue;
                }
                if (doneSchemas.put(start, (SchemaReference)imp) != null) continue;
                doneSchemas.put(resolvedSchemaLocation, (SchemaReference)imp);
                this.updateSchemaImports(imp.getReferencedSchema(), doneSchemas, base);
            }
        }
        List<SchemaReference> includes = CastUtils.cast(schema.getIncludes());
        for (SchemaReference included : includes) {
            String start = included.getSchemaLocationURI();
            if (start == null) continue;
            String resolvedSchemaLocation = WSDLQueryHandler.resolveWithCatalogs(catalogs, start, base);
            if (resolvedSchemaLocation == null) {
                if (doneSchemas.containsKey(start)) continue;
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    if (doneSchemas.put(start, included) != null) continue;
                    this.updateSchemaImports(included.getReferencedSchema(), doneSchemas, base);
                }
                continue;
            }
            if (doneSchemas.containsKey(start) && doneSchemas.containsKey(resolvedSchemaLocation)) continue;
            doneSchemas.put(start, included);
            doneSchemas.put(resolvedSchemaLocation, included);
            this.updateSchemaImports(included.getReferencedSchema(), doneSchemas, base);
        }
    }

    @Override
    public boolean isRecognizedQuery(String baseUri, String ctx, EndpointInfo endpointInfo) {
        return this.isRecognizedQuery(baseUri, ctx, endpointInfo, false);
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }
}

