/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.AsyncCallbackFuture;
import org.apache.cxf.jaxws.AsyncResponse;
import org.apache.cxf.jaxws.BindingProviderImpl;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.JAXWSAsyncCallable;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsClientProxy
extends ClientProxy
implements InvocationHandler,
BindingProvider {
    public static final String THREAD_LOCAL_REQUEST_CONTEXT = "thread.local.request.context";
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsClientProxy.class);
    protected Map<String, Object> currentRequestContext = new ConcurrentHashMap<String, Object>();
    protected ThreadLocal<EchoContext> requestContext = new ThreadLocal();
    protected ThreadLocal<Map<String, Object>> responseContext = new ThreadLocal();
    private final Binding binding;
    private final EndpointReferenceBuilder builder;

    public JaxWsClientProxy(Client c, Binding b) {
        super(c);
        this.binding = b;
        this.setupEndpointAddressContext(this.getClient().getEndpoint());
        this.builder = new EndpointReferenceBuilder((JaxWsEndpointImpl)this.getClient().getEndpoint());
    }

    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            this.currentRequestContext.put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        BindingOperationInfo oi;
        Endpoint endpoint = this.getClient().getEndpoint();
        String address = endpoint.getEndpointInfo().getAddress();
        MethodDispatcher dispatcher = (MethodDispatcher)endpoint.getService().get(MethodDispatcher.class.getName());
        Object[] params = args;
        if (null == params) {
            params = new Object[]{};
        }
        if ((oi = dispatcher.getBindingOperation(method, endpoint)) == null) {
            if (method.getDeclaringClass().equals(BindingProvider.class) || method.getDeclaringClass().equals(BindingProviderImpl.class) || method.getDeclaringClass().equals(Object.class)) {
                try {
                    return method.invoke((Object)this, params);
                }
                catch (InvocationTargetException e) {
                    throw e.fillInStackTrace().getCause();
                }
            }
            Message msg = new Message("NO_BINDING_OPERATION_INFO", LOG, method.getName());
            throw new WebServiceException(msg.toString());
        }
        Map<String, Object> reqContext = this.getRequestContextCopy();
        Map<String, Object> respContext = this.getResponseContext();
        respContext.clear();
        HashMap<String, Object> context = new HashMap<String, Object>();
        ContextPropertiesMapping.mapRequestfromJaxws2Cxf(reqContext);
        context.put("RequestContext", reqContext);
        context.put("ResponseContext", respContext);
        reqContext.put(Method.class.getName(), method);
        reqContext.put("RequestMethod", method);
        boolean isAsync = method.getName().endsWith("Async");
        Object result = null;
        try {
            result = isAsync ? this.invokeAsync(method, oi, params, context) : this.invokeSync(method, oi, params, context);
        }
        catch (WebServiceException wex) {
            throw wex.fillInStackTrace();
        }
        catch (Exception ex) {
            for (Class<?> excls : method.getExceptionTypes()) {
                if (!excls.isInstance(ex)) continue;
                throw ex.fillInStackTrace();
            }
            if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)ex);
                throw exception;
            }
            if (this.getBinding() instanceof SOAPBinding) {
                SOAPFault soapFault = this.createSoapFault(ex);
                if (soapFault == null) {
                    throw new WebServiceException((Throwable)ex);
                }
                SOAPFaultException exception = new SOAPFaultException(soapFault);
                exception.initCause((Throwable)ex);
                throw exception;
            }
            throw new WebServiceException((Throwable)ex);
        }
        finally {
            if (this.addressChanged(address)) {
                this.setupEndpointAddressContext(this.getClient().getEndpoint());
            }
        }
        ContextPropertiesMapping.mapResponsefromCxf2Jaxws(respContext);
        Map scopes = CastUtils.cast((Map)respContext.get(WrappedMessageContext.SCOPES));
        if (scopes != null) {
            for (Map.Entry scope : scopes.entrySet()) {
                if (scope.getValue() != MessageContext.Scope.HANDLER) continue;
                respContext.remove(scope.getKey());
            }
        }
        return result;
    }

    private SOAPFault createSoapFault(Exception ex) throws SOAPException {
        SOAPFault soapFault;
        try {
            soapFault = ((SOAPBinding)this.getBinding()).getSOAPFactory().createFault();
        }
        catch (Throwable t) {
            try {
                soapFault = ((SOAPBinding)this.getBinding()).getMessageFactory().createMessage().getSOAPBody().addFault();
            }
            catch (Throwable t2) {
                return null;
            }
        }
        if (ex instanceof SoapFault) {
            soapFault.setFaultString(((SoapFault)ex).getReason());
            soapFault.setFaultCode(((SoapFault)ex).getFaultCode());
            soapFault.setFaultActor(((SoapFault)ex).getRole());
            Node nd = soapFault.getOwnerDocument().importNode(((SoapFault)ex).getOrCreateDetail(), true);
            nd = nd.getFirstChild();
            soapFault.addDetail();
            while (nd != null) {
                Node next = nd.getNextSibling();
                soapFault.getDetail().appendChild(nd);
                nd = next;
            }
        } else {
            soapFault.setFaultCode(new QName("http://cxf.apache.org/faultcode", "HandlerFault"));
            String msg = ex.getMessage();
            if (msg != null) {
                soapFault.setFaultString(msg);
            }
        }
        return soapFault;
    }

    private boolean addressChanged(String address) {
        return address != null && this.getClient().getEndpoint().getEndpointInfo() != null && !address.equals(this.getClient().getEndpoint().getEndpointInfo().getAddress());
    }

    private Object invokeAsync(Method method, BindingOperationInfo oi, Object[] params, Map<String, Object> context) {
        FutureTask<Object> f = new FutureTask<Object>(new JAXWSAsyncCallable(this, method, oi, params, context));
        Endpoint endpoint = this.getClient().getEndpoint();
        endpoint.getExecutor().execute(f);
        AsyncResponse<Object> r = new AsyncResponse<Object>(f, Object.class);
        if (params.length > 0 && params[params.length - 1] instanceof AsyncHandler) {
            AsyncCallbackFuture callback = new AsyncCallbackFuture(r, (AsyncHandler)params[params.length - 1]);
            endpoint.getExecutor().execute(callback);
            return callback;
        }
        return r;
    }

    public boolean isThreadLocalRequestContext() {
        if (this.currentRequestContext.containsKey(THREAD_LOCAL_REQUEST_CONTEXT)) {
            Object o = this.currentRequestContext.get(THREAD_LOCAL_REQUEST_CONTEXT);
            boolean local = false;
            local = o instanceof Boolean ? (Boolean)o : Boolean.parseBoolean(o.toString());
            return local;
        }
        return false;
    }

    public void setThreadLocalRequestContext(boolean b) {
        this.currentRequestContext.put(THREAD_LOCAL_REQUEST_CONTEXT, b);
    }

    private Map<String, Object> getRequestContextCopy() {
        HashMap<String, Object> realMap = new HashMap<String, Object>();
        WrappedMessageContext ctx = new WrappedMessageContext(realMap, MessageContext.Scope.APPLICATION);
        if (this.isThreadLocalRequestContext() && null != this.requestContext.get()) {
            ctx.putAll(this.requestContext.get());
        } else {
            ctx.putAll(this.currentRequestContext);
        }
        return realMap;
    }

    public Map<String, Object> getRequestContext() {
        if (this.isThreadLocalRequestContext()) {
            if (null == this.requestContext.get()) {
                this.requestContext.set(new EchoContext(this.currentRequestContext));
            }
            return this.requestContext.get();
        }
        return this.currentRequestContext;
    }

    public Map<String, Object> getResponseContext() {
        if (null == this.responseContext.get()) {
            this.responseContext.set(new HashMap());
        }
        return this.responseContext.get();
    }

    public Binding getBinding() {
        return this.binding;
    }

    public EndpointReference getEndpointReference() {
        return this.builder.getEndpointReference();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        return this.builder.getEndpointReference(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EchoContext
    extends HashMap<String, Object> {
        final Map<String, Object> shared;

        public EchoContext(Map<String, Object> sharedMap) {
            super(sharedMap);
            this.shared = sharedMap;
        }

        @Override
        public Object put(String key, Object value) {
            this.shared.put(key, value);
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> t) {
            this.shared.putAll(t);
            super.putAll(t);
        }

        @Override
        public Object remove(Object key) {
            this.shared.remove(key);
            return super.remove(key);
        }

        public void reload() {
            super.clear();
            super.putAll(this.shared);
        }
    }
}

