/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheControlHeaderProvider
implements RuntimeDelegate.HeaderDelegate<CacheControl> {
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String NO_CACHE = "no-cache";
    private static final String NO_STORE = "no-store";
    private static final String NO_TRANSFORM = "no-transform";
    private static final String MUST_REVALIDATE = "must-revalidate";
    private static final String PROXY_REVALIDATE = "proxy-revalidate";
    private static final String MAX_AGE = "max-age";
    private static final String SMAX_AGE = "s-maxage";

    public CacheControl fromString(String c) {
        String[] tokens;
        boolean isPublic = true;
        boolean isPrivate = false;
        ArrayList<String> privateFields = new ArrayList<String>();
        boolean noCache = false;
        ArrayList<String> noCacheFields = new ArrayList<String>();
        boolean noStore = false;
        boolean noTransform = false;
        boolean mustRevalidate = false;
        boolean proxyRevalidate = false;
        int maxAge = -1;
        int sMaxAge = -1;
        for (String token : tokens = c.split(";")) {
            if (token.startsWith(MAX_AGE)) {
                maxAge = Integer.parseInt(token.substring(MAX_AGE.length() + 1));
                continue;
            }
            if (token.startsWith(SMAX_AGE)) {
                sMaxAge = Integer.parseInt(token.substring(SMAX_AGE.length() + 1));
                continue;
            }
            if (token.startsWith(PUBLIC)) continue;
            if (token.startsWith(NO_STORE)) {
                noStore = true;
                continue;
            }
            if (token.startsWith(NO_TRANSFORM)) {
                noTransform = true;
                continue;
            }
            if (token.startsWith(MUST_REVALIDATE)) {
                mustRevalidate = true;
                continue;
            }
            if (token.startsWith(PROXY_REVALIDATE)) {
                proxyRevalidate = true;
                continue;
            }
            if (token.startsWith(PRIVATE)) {
                isPublic = false;
                isPrivate = true;
                CacheControlHeaderProvider.addFields(privateFields, token);
                continue;
            }
            if (!token.startsWith(NO_CACHE)) continue;
            noCache = true;
            CacheControlHeaderProvider.addFields(noCacheFields, token);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(maxAge);
        cc.setSMaxAge(sMaxAge);
        cc.setPublic(isPublic);
        cc.setPrivate(isPrivate);
        cc.getPrivateFields().addAll(privateFields);
        cc.setMustRevalidate(mustRevalidate);
        cc.setProxyRevalidate(proxyRevalidate);
        cc.setNoCache(noCache);
        cc.getNoCacheFields().addAll(noCacheFields);
        cc.setNoStore(noStore);
        cc.setNoTransform(noTransform);
        return cc;
    }

    public String toString(CacheControl c) {
        String s;
        Iterator it;
        StringBuilder sb = new StringBuilder();
        if (c.isPublic()) {
            sb.append(PUBLIC).append(';');
        } else {
            sb.append(PRIVATE).append('=');
            it = c.getPrivateFields().iterator();
            while (it.hasNext()) {
                sb.append('\"').append((String)it.next()).append('\"');
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            sb.append(';');
        }
        if (c.isNoCache()) {
            sb.append(NO_CACHE).append('=');
            it = c.getNoCacheFields().iterator();
            while (it.hasNext()) {
                sb.append('\"').append((String)it.next()).append('\"');
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            sb.append(';');
        }
        if (c.isNoStore()) {
            sb.append(NO_STORE).append(';');
        }
        if (c.isNoTransform()) {
            sb.append(NO_TRANSFORM).append(';');
        }
        if (c.isMustRevalidate()) {
            sb.append(MUST_REVALIDATE).append(';');
        }
        if (c.isProxyRevalidate()) {
            sb.append(PROXY_REVALIDATE).append(';');
        }
        if (c.getMaxAge() != -1) {
            sb.append(MAX_AGE).append('=').append(c.getMaxAge()).append(';');
        }
        if (c.getSMaxAge() != -1) {
            sb.append(SMAX_AGE).append('=').append(c.getSMaxAge()).append(';');
        }
        return (s = sb.toString()).endsWith(";") ? s.substring(0, s.length() - 1) : s;
    }

    private static void addFields(List<String> fields, String token) {
        String f = null;
        int i = token.indexOf(61);
        if (i != -1) {
            String string = f = i == token.length() + 1 ? "" : token.substring(i + 1);
            if (f.length() < 2 || !f.startsWith("\"") || !f.endsWith("\"")) {
                f = "";
            } else {
                String string2 = f = f.length() == 2 ? "" : f.substring(1, f.length() - 1);
            }
        }
        if (f != null) {
            fields.add(f);
        }
    }
}

