/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.jaxrs.JAXRSUtils;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSOutInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSOutInterceptor.class);

    public JAXRSOutInterceptor() {
        super("marshal");
    }

    @Override
    public void handleMessage(Message message) {
        Exchange exchange = message.getExchange();
        OperationResourceInfo operation = (OperationResourceInfo)exchange.get(OperationResourceInfo.class.getName());
        if (operation == null) {
            return;
        }
        MessageContentsList objs = MessageContentsList.getContentsList(message);
        if (objs == null || objs.size() == 0) {
            return;
        }
        OutputStream out = message.getContent(OutputStream.class);
        if (objs.get(0) != null) {
            Object responseObj = objs.get(0);
            if (objs.get(0) instanceof Response) {
                Response response = (Response)responseObj;
                message.put(Message.RESPONSE_CODE, response.getStatus());
                message.put(Message.PROTOCOL_HEADERS, response.getMetadata());
                responseObj = response.getEntity();
                if (responseObj == null) {
                    return;
                }
            }
            Class<?> targetType = responseObj.getClass();
            List<MediaType> availableContentTypes = this.computeAvailableContentTypes(message);
            MessageBodyWriter<?> writer = null;
            for (MediaType type : availableContentTypes) {
                writer = ProviderFactory.getInstance().createMessageBodyWriter(targetType, type);
                if (writer == null) continue;
                break;
            }
            if (writer == null) {
                message.put(Message.RESPONSE_CODE, 406);
                this.writeResponseErrorMessage(out, "NO_MSG_WRITER", responseObj.getClass().getSimpleName());
                return;
            }
            try {
                LOG.fine("Response EntityProvider is: " + writer.getClass().getName());
                MediaType mt = this.computeFinalContentTypes(availableContentTypes, writer);
                LOG.fine("Response content type is: " + mt.toString());
                message.put("Content-Type", mt.toString());
                writer.writeTo(responseObj, mt, null, out);
            }
            catch (IOException e) {
                e.printStackTrace();
                message.put(Message.RESPONSE_CODE, 500);
                this.writeResponseErrorMessage(out, "SERIALIZE_ERROR", responseObj.getClass().getSimpleName());
            }
        }
    }

    private void writeResponseErrorMessage(OutputStream out, String errorString, String parameter) {
        try {
            out.write(new org.apache.cxf.common.i18n.Message(errorString, BUNDLE, parameter).toString().getBytes("UTF-8"));
        }
        catch (IOException another) {
            // empty catch block
        }
    }

    private List<MediaType> computeAvailableContentTypes(Message message) {
        Exchange exchange = message.getExchange();
        List<MediaType> methodMimeTypes = exchange.get(OperationResourceInfo.class).getProduceTypes();
        String acceptContentTypes = (String)exchange.get("Accept");
        List<MediaType> acceptValues = JAXRSUtils.parseMediaTypes(acceptContentTypes);
        return JAXRSUtils.intersectMimeTypes(methodMimeTypes, acceptValues);
    }

    private MediaType computeFinalContentTypes(List<MediaType> produceContentTypes, MessageBodyWriter provider) {
        List<MediaType> providerMimeTypes = JAXRSUtils.getProduceTypes(provider.getClass().getAnnotation(ProduceMime.class));
        List<MediaType> list = JAXRSUtils.intersectMimeTypes(produceContentTypes, providerMimeTypes);
        return list.get(0);
    }
}

