/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import com.sun.xml.bind.api.TypeReference;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.jaxb.JAXBDataBase;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.ws.commons.schema.XmlSchemaElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataWriterImpl<T>
extends JAXBDataBase
implements DataWriter<T> {
    private Set<Class<?>> contextClasses;
    private Map<String, Object> marshallerProperties = Collections.emptyMap();

    public DataWriterImpl(JAXBContext ctx, Set<Class<?>> contextClasses) {
        super(ctx);
        this.contextClasses = contextClasses;
    }

    public DataWriterImpl(JAXBContext ctx, Map<String, Object> marshallerProperties, Set<Class<?>> contextClasses) {
        super(ctx);
        this.marshallerProperties = marshallerProperties;
        this.contextClasses = contextClasses;
    }

    @Override
    public void write(Object obj, T output) {
        this.write(obj, null, output);
    }

    @Override
    public void write(Object obj, MessagePartInfo part, T output) {
        boolean honorJaxbAnnotation = false;
        if (part != null && part.getProperty("honor.jaxb.annotations") != null) {
            honorJaxbAnnotation = (Boolean)part.getProperty("honor.jaxb.annotations");
        }
        if (obj != null || !(part.getXmlSchema() instanceof XmlSchemaElement)) {
            if (obj instanceof Exception && part != null && Boolean.TRUE.equals(part.getProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION"))) {
                JAXBEncoderDecoder.marshallException(this.getJAXBContext(), this.getSchema(), (Exception)obj, part, output, this.getAttachmentMarshaller(), this.marshallerProperties);
            } else {
                Annotation[] anns = this.getJAXBAnnotation(part);
                if (!honorJaxbAnnotation || anns.length == 0) {
                    JAXBEncoderDecoder.marshall(this.getJAXBContext(), this.getSchema(), obj, part, output, this.getAttachmentMarshaller(), this.marshallerProperties);
                } else if (honorJaxbAnnotation && anns.length > 0) {
                    QName qname = new QName(null, part.getConcreteName().getLocalPart());
                    TypeReference typeReference = new TypeReference(qname, part.getTypeClass(), anns);
                    JAXBEncoderDecoder.marshalWithBridge(typeReference, this.contextClasses, obj, output, this.getAttachmentMarshaller());
                }
            }
        } else if (obj == null && this.needToRender(obj, part)) {
            JAXBEncoderDecoder.marshallNullElement(this.getJAXBContext(), this.getSchema(), output, part, this.marshallerProperties);
        }
    }

    private boolean needToRender(Object obj, MessagePartInfo part) {
        if (part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)part.getXmlSchema();
            return element.isNillable() && element.getMinOccurs() > 0L;
        }
        return false;
    }

    public Map<String, Object> getMarshallerProperties() {
        return this.marshallerProperties;
    }

    public void setMarshallerProperties(Map<String, Object> marshallerProperties) {
        this.marshallerProperties = marshallerProperties;
    }
}

