/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.AbstractTwoStageCache;
import org.apache.cxf.transport.jms.JMSTransport;
import org.apache.cxf.transport.jms.PooledSession;
import org.apache.cxf.transport.jms.ServerBehaviorPolicyType;
import org.apache.cxf.transport.jms.SessionPoolType;

public class JMSSessionFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSSessionFactory.class);
    private int lowWaterMark;
    private int highWaterMark;
    private final Context initialContext;
    private final Connection theConnection;
    private AbstractTwoStageCache<PooledSession> replyCapableSessionCache;
    private AbstractTwoStageCache<PooledSession> sendOnlySessionCache;
    private final Destination theReplyDestination;
    private final JMSTransport jmsTransport;
    private final ServerBehaviorPolicyType runtimePolicy;

    public JMSSessionFactory(Connection connection, Destination replyDestination, Context context, JMSTransport tbb, ServerBehaviorPolicyType runtimePolicy) {
        this.theConnection = connection;
        this.theReplyDestination = replyDestination;
        this.initialContext = context;
        this.jmsTransport = tbb;
        this.runtimePolicy = runtimePolicy;
        SessionPoolType sessionPoolConfig = this.jmsTransport.getSessionPool();
        this.lowWaterMark = sessionPoolConfig.getLowWaterMark();
        this.highWaterMark = sessionPoolConfig.getHighWaterMark();
        if (this.isDestinationStyleQueue()) {
            this.replyCapableSessionCache = new AbstractTwoStageCache<PooledSession>(this.lowWaterMark, this.highWaterMark, 0, (Object)this){

                @Override
                public final PooledSession create() throws JMSException {
                    return JMSSessionFactory.this.createPointToPointReplyCapableSession();
                }
            };
            try {
                this.replyCapableSessionCache.populateCache();
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "JMS Session cache populate failed: " + t);
            }
            this.sendOnlySessionCache = new AbstractTwoStageCache<PooledSession>(this.lowWaterMark, this.highWaterMark, 0, (Object)this){

                @Override
                public final PooledSession create() throws JMSException {
                    return JMSSessionFactory.this.createPointToPointSendOnlySession();
                }
            };
            try {
                this.sendOnlySessionCache.populateCache();
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "JMS Session cache populate failed: " + t);
            }
        } else {
            this.sendOnlySessionCache = new AbstractTwoStageCache<PooledSession>(this.lowWaterMark, this.highWaterMark, 0, (Object)this){

                @Override
                public final PooledSession create() throws JMSException {
                    return JMSSessionFactory.this.createPubSubSession(true, false, null);
                }
            };
            try {
                this.sendOnlySessionCache.populateCache();
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "JMS Session cache populate failed: " + t);
            }
        }
    }

    public String toString() {
        return "JMSSessionFactory";
    }

    protected Connection getConnection() {
        return this.theConnection;
    }

    public Queue getQueueFromInitialContext(String queueName) throws NamingException {
        return (Queue)this.initialContext.lookup(queueName);
    }

    public PooledSession get(boolean replyCapable) throws JMSException {
        return this.get(null, replyCapable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledSession get(Destination replyDest, boolean replyCapable) throws JMSException {
        PooledSession ret = null;
        JMSSessionFactory jMSSessionFactory = this;
        synchronized (jMSSessionFactory) {
            if (replyCapable) {
                ret = this.replyCapableSessionCache.poll();
                if (ret == null) {
                    ret = this.sendOnlySessionCache.poll();
                    if (ret != null) {
                        QueueSession session = (QueueSession)ret.session();
                        Queue destination = null;
                        String selector = null;
                        if (null != this.theReplyDestination || null != replyDest) {
                            destination = null != replyDest ? (Queue)replyDest : (Queue)this.theReplyDestination;
                            selector = "JMSCorrelationID = '" + this.generateUniqueSelector(ret) + "'";
                        }
                        if (destination == null) {
                            destination = session.createTemporaryQueue();
                            selector = "JMSCorrelationID = '" + this.generateUniqueSelector(ret) + "'";
                        }
                        ret.destination((Destination)destination);
                        QueueReceiver consumer = session.createReceiver(destination, selector);
                        ret.consumer((MessageConsumer)consumer);
                    } else {
                        try {
                            ret = this.replyCapableSessionCache.get();
                        }
                        catch (Throwable t) {
                            throw (JMSException)t;
                        }
                    }
                }
            } else {
                ret = this.sendOnlySessionCache.poll();
                if (ret == null) {
                    if (this.replyCapableSessionCache != null) {
                        ret = this.replyCapableSessionCache.poll();
                    }
                    if (ret == null) {
                        try {
                            ret = this.sendOnlySessionCache.get();
                        }
                        catch (Throwable t) {
                            throw (JMSException)t;
                        }
                    }
                }
            }
        }
        return ret;
    }

    public PooledSession get(Destination destination) throws JMSException {
        PooledSession ret = null;
        ret = this.isDestinationStyleQueue() ? this.createPointToPointServerSession(destination) : this.createPubSubSession(false, true, destination);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle(PooledSession pooledSession) {
        boolean replyCapable = pooledSession.destination() != null;
        boolean discard = false;
        JMSSessionFactory jMSSessionFactory = this;
        synchronized (jMSSessionFactory) {
            discard = replyCapable ? !this.replyCapableSessionCache.recycle(pooledSession) : !this.sendOnlySessionCache.recycle(pooledSession);
        }
        if (discard) {
            try {
                pooledSession.close();
            }
            catch (JMSException e) {
                LOG.log(Level.WARNING, "JMS Session discard failed: " + (Object)((Object)e));
            }
        }
    }

    public void shutdown() {
        try {
            PooledSession curr;
            if (this.replyCapableSessionCache != null) {
                curr = this.replyCapableSessionCache.poll();
                while (curr != null) {
                    curr.close();
                    curr = this.replyCapableSessionCache.poll();
                }
            }
            if (this.sendOnlySessionCache != null) {
                curr = this.sendOnlySessionCache.poll();
                while (curr != null) {
                    curr.close();
                    curr = this.sendOnlySessionCache.poll();
                }
            }
            this.theConnection.close();
        }
        catch (JMSException e) {
            LOG.log(Level.WARNING, "queue connection close failed: " + (Object)((Object)e));
        }
        this.replyCapableSessionCache = null;
        this.sendOnlySessionCache = null;
    }

    PooledSession createPointToPointReplyCapableSession() throws JMSException {
        QueueSession session = ((QueueConnection)this.theConnection).createQueueSession(false, 1);
        Destination destination = null;
        String selector = null;
        if (null != this.theReplyDestination) {
            destination = this.theReplyDestination;
            selector = "JMSCorrelationID = '" + this.generateUniqueSelector(session) + "'";
        } else {
            destination = session.createTemporaryQueue();
        }
        QueueReceiver consumer = session.createReceiver((Queue)destination, selector);
        return new PooledSession((Session)session, destination, (MessageProducer)session.createSender(null), (MessageConsumer)consumer);
    }

    PooledSession createPointToPointSendOnlySession() throws JMSException {
        QueueSession session = ((QueueConnection)this.theConnection).createQueueSession(false, 1);
        return new PooledSession((Session)session, null, (MessageProducer)session.createSender(null), null);
    }

    private PooledSession createPointToPointServerSession(Destination destination) throws JMSException {
        QueueSession session = ((QueueConnection)this.theConnection).createQueueSession(false, 1);
        return new PooledSession((Session)session, destination, (MessageProducer)session.createSender(null), (MessageConsumer)session.createReceiver((Queue)destination, this.runtimePolicy.getMessageSelector()));
    }

    PooledSession createPubSubSession(boolean producer, boolean consumer, Destination destination) throws JMSException {
        TopicSession session = ((TopicConnection)this.theConnection).createTopicSession(false, 1);
        TopicSubscriber sub = null;
        if (consumer) {
            String messageSelector = this.runtimePolicy.getMessageSelector();
            String durableName = this.runtimePolicy.getDurableSubscriberName();
            sub = durableName != null ? session.createDurableSubscriber((Topic)destination, durableName, messageSelector, false) : session.createSubscriber((Topic)destination, messageSelector, false);
        }
        return new PooledSession((Session)session, null, (MessageProducer)(producer ? session.createPublisher(null) : null), (MessageConsumer)sub);
    }

    private String generateUniqueSelector(Object obj) {
        String host = "localhost";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            host = addr.getHostName();
        }
        catch (UnknownHostException ukex) {
            // empty catch block
        }
        long time = Calendar.getInstance().getTimeInMillis();
        return host + "_" + System.getProperty("user.name") + "_" + obj + time;
    }

    private boolean isDestinationStyleQueue() {
        return "queue".equals(this.jmsTransport.getJMSAddress().getDestinationStyle().value());
    }
}

