/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.workqueue;

import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedAttribute;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.workqueue.AutomaticWorkQueueImpl;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.workqueue.WorkQueueManagerImpl;

@ManagedResource(componentName="WorkQueue", description="The CXF internal thread pool for manangement ", currencyTimeLimit=15, persistPolicy="OnUpdate", persistPeriod=200)
public class WorkQueueManagerImplMBeanWrapper
implements ManagedComponent {
    private static final String NAME_VALUE = "Bus.WorkQueue";
    private static final String TYPE_VALUE = "WorkQueueMBean";
    private WorkQueueManagerImpl wqManager;
    private AutomaticWorkQueueImpl aWorkQueue;
    private Bus bus;

    public WorkQueueManagerImplMBeanWrapper(WorkQueueManagerImpl wq) {
        this.wqManager = wq;
        this.bus = wq.getBus();
        if (this.wqManager.autoQueue != null && AutomaticWorkQueueImpl.class.isAssignableFrom(this.wqManager.autoQueue.getClass())) {
            this.aWorkQueue = (AutomaticWorkQueueImpl)this.wqManager.autoQueue;
        }
    }

    @ManagedOperation(currencyTimeLimit=30)
    public void shutdown(boolean processRemainingWorkItems) {
        this.wqManager.shutdown(processRemainingWorkItems);
    }

    @ManagedAttribute(description="The thread pool work model", defaultValue="SINGLE_THREADED", persistPolicy="OnUpdate")
    public String getThreadingModel() {
        return this.wqManager.getThreadingModel().toString();
    }

    public void setThreadingModel(String model) {
        if (model.compareTo("SINGLE_THREADED") == 0) {
            this.wqManager.setThreadingModel(WorkQueueManager.ThreadingModel.SINGLE_THREADED);
        }
        if (model.compareTo("MULTI_THREADED") == 0) {
            this.wqManager.setThreadingModel(WorkQueueManager.ThreadingModel.MULTI_THREADED);
        }
    }

    @ManagedAttribute(description="The WorkQueueMaxSize", persistPolicy="OnUpdate")
    public long getWorkQueueMaxSize() {
        return this.aWorkQueue.getMaxSize();
    }

    @ManagedAttribute(description="The WorkQueue Current size", persistPolicy="OnUpdate")
    public long getWorkQueueSize() {
        return this.aWorkQueue.getSize();
    }

    @ManagedAttribute(description="The WorkQueue has nothing to do", persistPolicy="OnUpdate")
    public boolean isEmpty() {
        return this.aWorkQueue.isEmpty();
    }

    @ManagedAttribute(description="The WorkQueue is very busy")
    public boolean isFull() {
        return this.aWorkQueue.isFull();
    }

    @ManagedAttribute(description="The WorkQueue HighWaterMark", persistPolicy="OnUpdate")
    public int getHighWaterMark() {
        return this.aWorkQueue.getHighWaterMark();
    }

    public void setHighWaterMark(int hwm) {
        this.aWorkQueue.setHighWaterMark(hwm);
    }

    @ManagedAttribute(description="The WorkQueue LowWaterMark", persistPolicy="OnUpdate")
    public int getLowWaterMark() {
        return this.aWorkQueue.getLowWaterMark();
    }

    public void setLowWaterMark(int lwm) {
        this.aWorkQueue.setLowWaterMark(lwm);
    }

    public ObjectName getObjectName() throws JMException {
        String busId = this.bus.getId();
        StringBuffer buffer = new StringBuffer();
        buffer.append("org.apache.cxf:");
        buffer.append("bus.id=" + busId + ",");
        buffer.append("type=WorkQueueMBean,");
        buffer.append("name=Bus.WorkQueue");
        return new ObjectName(buffer.toString());
    }
}

