/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.mtom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataHandler;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.type.mtom.AbstractXOPType;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Attachment;

public class DataHandlerType
extends AbstractXOPType {
    protected Object readAttachment(Attachment att, Context context) {
        return att.getDataHandler();
    }

    protected Attachment createAttachment(Object object, String id) {
        DataHandler handler = (DataHandler)object;
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(true);
        return att;
    }

    protected String getContentType(Object object, Context context) {
        return ((DataHandler)object).getContentType();
    }

    protected Object wrapBytes(byte[] bareBytes, String contentType) {
        String charset = null;
        if (contentType != null && contentType.indexOf("text/") != -1 && contentType.indexOf("charset") != -1 && (charset = contentType.substring(contentType.indexOf("charset") + 8)).indexOf(";") != -1) {
            charset = charset.substring(0, charset.indexOf(";"));
        }
        String normalizedEncoding = HttpHeaderHelper.mapCharset(charset, "UTF-8");
        try {
            String stringData = new String(bareBytes, normalizedEncoding);
            return new DataHandler((Object)stringData, contentType);
        }
        catch (UnsupportedEncodingException e) {
            return new DataHandler((Object)bareBytes, contentType);
        }
    }

    protected byte[] getBytes(Object object) {
        DataHandler handler = (DataHandler)object;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            InputStream stream = handler.getInputStream();
            IOUtils.copy(stream, baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }
}

