/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xmlbeans;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.cxf.databinding.AbstractWrapperHelper;
import org.apache.xmlbeans.XmlOptions;

public class XmlBeansWrapperHelper
extends AbstractWrapperHelper {
    public XmlBeansWrapperHelper(Class<?> wt, Method[] sets, Method[] gets, Field[] f) {
        super(wt, sets, gets, f);
    }

    @Override
    protected Object createWrapperObject(Class<?> typeClass) throws Exception {
        Class<?>[] cls = typeClass.getDeclaredClasses();
        Method newType = null;
        for (Method method : typeClass.getMethods()) {
            if (!method.getName().startsWith("addNew")) continue;
            newType = method;
            break;
        }
        Object obj = null;
        for (Class<?> c : cls) {
            if (!"Factory".equals(c.getSimpleName())) continue;
            if (this.validate) {
                Method method = c.getMethod("newInstance", XmlOptions.class);
                XmlOptions options = new XmlOptions();
                options.setValidateOnSet();
                obj = method.invoke(null, options);
            } else {
                Method method = c.getMethod("newInstance", NO_CLASSES);
                obj = method.invoke(null, NO_PARAMS);
            }
            obj = newType.invoke(obj, NO_PARAMS);
            break;
        }
        return obj;
    }

    @Override
    protected Object getWrapperObject(Object object) throws Exception {
        Method m = XmlBeansWrapperHelper.getXMLBeansValueMethod(this.wrapperType);
        Method method = null;
        if (m == null) {
            Class<?> valueClass = XmlBeansWrapperHelper.getXMLBeansValueType(this.wrapperType);
            method = this.wrapperType.getMethod("get" + valueClass.getSimpleName(), NO_CLASSES);
        } else {
            method = this.wrapperType.getMethod("get" + m.getName().substring(6), NO_CLASSES);
        }
        return method.invoke(object, NO_PARAMS);
    }

    public static Method getXMLBeansValueMethod(Class<?> wrapperType) {
        for (Method method : wrapperType.getMethods()) {
            if (!method.getName().startsWith("addNew")) continue;
            return method;
        }
        return null;
    }

    public static Class<?> getXMLBeansValueType(Class<?> wrapperType) {
        Class<?> result = wrapperType;
        for (Method method : wrapperType.getMethods()) {
            if (!method.getName().startsWith("addNew")) continue;
            result = method.getReturnType();
            break;
        }
        return result;
    }
}

