/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.transform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DelegatingNamespaceContext
implements NamespaceContext {
    private NamespaceContext nc;
    private Map<String, String> nsMap;
    private List<Map<String, String>> namespaces;
    private List<Map<String, String>> prefixes;

    public DelegatingNamespaceContext(NamespaceContext nc, Map<String, String> nsMap) {
        this.nc = nc;
        this.nsMap = nsMap;
        this.namespaces = new LinkedList<Map<String, String>>();
        this.prefixes = new LinkedList<Map<String, String>>();
    }

    public void down() {
        ((LinkedList)this.namespaces).addFirst(new HashMap(8));
        ((LinkedList)this.prefixes).addFirst(new HashMap(8));
    }

    public void up() {
        ((LinkedList)this.namespaces).removeFirst();
        ((LinkedList)this.prefixes).removeFirst();
    }

    public void addPrefix(String prefix, String ns) {
        ((Map)((LinkedList)this.namespaces).getFirst()).put(prefix, ns);
        ((Map)((LinkedList)this.prefixes).getFirst()).put(ns, prefix);
    }

    public String findUniquePrefix(String ns) {
        String prefix;
        if (ns.length() == 0) {
            return null;
        }
        String existingPrefix = this.getPrefix(ns);
        if (existingPrefix != null) {
            return existingPrefix;
        }
        int i = 0;
        while (this.getNamespaceURI(prefix = "ps" + ++i) != null) {
        }
        this.addPrefix(prefix, ns);
        return prefix;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (!this.namespaces.isEmpty()) {
            Map cache = (Map)((LinkedList)this.namespaces).getFirst();
            for (Map<String, String> nss : this.namespaces) {
                String ns = nss.get(prefix);
                if (ns == null) continue;
                cache.put(prefix, ns);
                return ns;
            }
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String ns = this.nc.getNamespaceURI(prefix);
        if (ns != null && ns.length() > 0) {
            this.addPrefix(prefix, ns);
        }
        return ns;
    }

    @Override
    public String getPrefix(String ns) {
        if (ns.length() == 0) {
            return null;
        }
        String value = this.nsMap.get(ns);
        if (value != null && value.length() == 0) {
            return null;
        }
        if (value != null) {
            ns = value;
        }
        if (!this.prefixes.isEmpty()) {
            Map cache = (Map)((LinkedList)this.prefixes).getFirst();
            for (Map<String, String> pfs : this.prefixes) {
                String prefix = pfs.get(ns);
                if (prefix == null || !ns.equals(this.getNamespaceURI(prefix))) continue;
                cache.put(ns, prefix);
                return prefix;
            }
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(ns)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(ns)) {
            return "xmlns";
        }
        String prefix = this.nc.getPrefix(ns);
        if (prefix != null) {
            this.addPrefix(prefix, ns);
        }
        return prefix;
    }

    @Override
    public Iterator<String> getPrefixes(String ns) {
        LinkedList<String> pl = new LinkedList<String>();
        for (Map<String, String> pfs : this.prefixes) {
            String pf = pfs.get(ns);
            if (pf == null || !ns.equals(this.getNamespaceURI(pf))) continue;
            pl.add(pf);
        }
        return pl.iterator();
    }
}

