/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.sql.SQLPrinterVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchUtils {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_FORMAT_PROPERTY = "search.date-format";
    public static final String TIMEZONE_SUPPORT_PROPERTY = "search.timezone.support";
    public static final String LAX_PROPERTY_MATCH = "search.lax.property.match";
    public static final String BEAN_PROPERTY_MAP = "search.bean.property.map";
    public static final String SEARCH_VISITOR_PROPERTY = "search.visitor";

    private SearchUtils() {
    }

    public static SimpleDateFormat getDateFormat(Map<String, String> properties) {
        String dfProperty = properties.get(DATE_FORMAT_PROPERTY);
        return new SimpleDateFormat(dfProperty == null ? DEFAULT_DATE_FORMAT : dfProperty);
    }

    public static boolean isTimeZoneSupported(Map<String, String> properties, Boolean defaultValue) {
        String tzProperty = properties.get(TIMEZONE_SUPPORT_PROPERTY);
        return tzProperty == null ? defaultValue : Boolean.valueOf(tzProperty);
    }

    public static <T> String toSQL(SearchCondition<T> sc, String table, String ... columns) {
        SQLPrinterVisitor visitor = new SQLPrinterVisitor(table, columns);
        sc.accept(visitor);
        return visitor.getQuery();
    }

    public static void startSqlQuery(StringBuilder sb, String table, String tableAlias, List<String> columns) {
        sb.append("SELECT ");
        if (columns != null && columns.size() > 0) {
            for (int i = 0; i < columns.size(); ++i) {
                sb.append(columns.get(i));
                if (i + 1 >= columns.size()) continue;
                sb.append(",");
            }
        } else {
            sb.append("*");
        }
        sb.append(" FROM ").append(table);
        if (tableAlias != null) {
            sb.append(" " + tableAlias);
        }
        sb.append(" WHERE ");
    }

    public static String conditionTypeToSqlOperator(ConditionType ct, String value) {
        String op;
        switch (ct) {
            case EQUALS: {
                op = value.contains("%") ? "LIKE" : "=";
                break;
            }
            case NOT_EQUALS: {
                op = value.contains("%") ? "NOT LIKE" : "<>";
                break;
            }
            case GREATER_THAN: {
                op = ">";
                break;
            }
            case GREATER_OR_EQUALS: {
                op = ">=";
                break;
            }
            case LESS_THAN: {
                op = "<";
                break;
            }
            case LESS_OR_EQUALS: {
                op = "<=";
                break;
            }
            default: {
                String msg = String.format("Condition type %s is not supported", ct.name());
                throw new RuntimeException(msg);
            }
        }
        return op;
    }
}

