/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.managers;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.management.JMException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.managers.WorkQueueImplMBeanWrapper;
import org.apache.cxf.bus.managers.WorkQueueManagerImplMBeanWrapper;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.AutomaticWorkQueueImpl;
import org.apache.cxf.workqueue.WorkQueueManager;

@NoJSR250Annotations(unlessNull={"bus"})
public class WorkQueueManagerImpl
implements WorkQueueManager {
    private static final Logger LOG = LogUtils.getL7dLogger(WorkQueueManagerImpl.class);
    Map<String, AutomaticWorkQueue> namedQueues = new ConcurrentHashMap<String, AutomaticWorkQueue>();
    boolean inShutdown;
    InstrumentationManager imanager;
    Bus bus;

    public WorkQueueManagerImpl() {
    }

    public WorkQueueManagerImpl(Bus b) {
        this.setBus(b);
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public final void setBus(Bus bus) {
        this.bus = bus;
        if (null != bus) {
            AutomaticWorkQueue defaultQueue;
            ConfiguredBeanLocator locator;
            Collection<AutomaticWorkQueue> q;
            bus.setExtension(this, WorkQueueManager.class);
            this.imanager = bus.getExtension(InstrumentationManager.class);
            if (null != this.imanager) {
                try {
                    this.imanager.register(new WorkQueueManagerImplMBeanWrapper(this));
                }
                catch (JMException jmex) {
                    LOG.log(Level.WARNING, jmex.getMessage(), jmex);
                }
            }
            if ((q = (locator = bus.getExtension(ConfiguredBeanLocator.class)).getBeansOfType(AutomaticWorkQueue.class)) != null) {
                for (AutomaticWorkQueue awq : q) {
                    this.addNamedWorkQueue(awq.getName(), awq);
                }
            }
            if (!this.namedQueues.containsKey("default") && (defaultQueue = locator.getBeanOfType("cxf.default.workqueue", AutomaticWorkQueue.class)) != null) {
                this.addNamedWorkQueue("default", defaultQueue);
            }
            bus.getExtension(BusLifeCycleManager.class).registerLifeCycleListener(new WQLifecycleListener());
        }
    }

    public synchronized AutomaticWorkQueue getAutomaticWorkQueue() {
        AutomaticWorkQueue defaultQueue = this.getNamedWorkQueue("default");
        if (defaultQueue == null) {
            defaultQueue = this.createAutomaticWorkQueue();
        }
        return defaultQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean processRemainingTasks) {
        this.inShutdown = true;
        for (AutomaticWorkQueue q : this.namedQueues.values()) {
            if (q instanceof AutomaticWorkQueueImpl) {
                AutomaticWorkQueueImpl impl = (AutomaticWorkQueueImpl)q;
                if (impl.isShared()) {
                    AutomaticWorkQueueImpl automaticWorkQueueImpl = impl;
                    synchronized (automaticWorkQueueImpl) {
                        impl.removeSharedUser();
                        if (impl.getShareCount() == 0 && this.imanager != null && this.imanager.getMBeanServer() != null) {
                            try {
                                this.imanager.unregister(new WorkQueueImplMBeanWrapper(impl, this));
                            }
                            catch (JMException jmex) {
                                LOG.log(Level.WARNING, jmex.getMessage(), jmex);
                            }
                        }
                        continue;
                    }
                }
                q.shutdown(processRemainingTasks);
                continue;
            }
            q.shutdown(processRemainingTasks);
        }
        WorkQueueManagerImpl workQueueManagerImpl = this;
        synchronized (workQueueManagerImpl) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        WorkQueueManagerImpl workQueueManagerImpl = this;
        synchronized (workQueueManagerImpl) {
            while (!this.inShutdown) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            for (AutomaticWorkQueue q : this.namedQueues.values()) {
                while (!q.isShutdown()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        for (Handler h : LOG.getHandlers()) {
            h.flush();
        }
    }

    public AutomaticWorkQueue getNamedWorkQueue(String name) {
        return this.namedQueues.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addNamedWorkQueue(String name, AutomaticWorkQueue q) {
        this.namedQueues.put(name, q);
        if (q instanceof AutomaticWorkQueueImpl) {
            AutomaticWorkQueueImpl impl = (AutomaticWorkQueueImpl)q;
            if (impl.isShared()) {
                AutomaticWorkQueueImpl automaticWorkQueueImpl = impl;
                synchronized (automaticWorkQueueImpl) {
                    if (impl.getShareCount() == 0 && this.imanager != null && this.imanager.getMBeanServer() != null) {
                        try {
                            this.imanager.register(new WorkQueueImplMBeanWrapper((AutomaticWorkQueueImpl)q, this));
                        }
                        catch (JMException jmex) {
                            LOG.log(Level.WARNING, jmex.getMessage(), jmex);
                        }
                    }
                    impl.addSharedUser();
                }
            }
            if (this.imanager != null) {
                try {
                    this.imanager.register(new WorkQueueImplMBeanWrapper((AutomaticWorkQueueImpl)q, this));
                }
                catch (JMException jmex) {
                    LOG.log(Level.WARNING, jmex.getMessage(), jmex);
                }
            }
        }
    }

    private AutomaticWorkQueue createAutomaticWorkQueue() {
        AutomaticWorkQueueImpl q = new AutomaticWorkQueueImpl("default");
        this.addNamedWorkQueue("default", q);
        return q;
    }

    class WQLifecycleListener
    implements BusLifeCycleListener {
        WQLifecycleListener() {
        }

        public void initComplete() {
        }

        public void preShutdown() {
            WorkQueueManagerImpl.this.shutdown(true);
        }

        public void postShutdown() {
        }
    }
}

