/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.io.CacheSizeExceededException;
import org.apache.cxf.io.CachedOutputStreamCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedOutputStream
extends OutputStream {
    private static final File DEFAULT_TEMP_DIR;
    private static int defaultThreshold;
    private static long defaultMaxSize;
    protected boolean outputLocked;
    protected OutputStream currentStream;
    private long threshold = defaultThreshold;
    private long maxSize = defaultMaxSize;
    private long totalLength;
    private boolean inmem;
    private boolean tempFileFailed;
    private File tempFile;
    private File outputDir = DEFAULT_TEMP_DIR;
    private boolean allowDeleteOfFile = true;
    private List<CachedOutputStreamCallback> callbacks;
    private List<Object> streamList = new ArrayList<Object>();

    public CachedOutputStream(PipedInputStream stream) throws IOException {
        this.currentStream = new PipedOutputStream(stream);
        this.inmem = true;
    }

    public CachedOutputStream() {
        this.currentStream = new LoadingByteArrayOutputStream(2048);
        this.inmem = true;
    }

    public CachedOutputStream(long threshold) {
        this.threshold = threshold;
        this.currentStream = new LoadingByteArrayOutputStream(2048);
        this.inmem = true;
    }

    public void holdTempFile() {
        this.allowDeleteOfFile = false;
    }

    public void releaseTempFileHold() {
        this.allowDeleteOfFile = true;
    }

    public void registerCallback(CachedOutputStreamCallback cb) {
        if (null == this.callbacks) {
            this.callbacks = new ArrayList<CachedOutputStreamCallback>();
        }
        this.callbacks.add(cb);
    }

    public void deregisterCallback(CachedOutputStreamCallback cb) {
        if (null != this.callbacks) {
            this.callbacks.remove(cb);
        }
    }

    public List<CachedOutputStreamCallback> getCallbacks() {
        return this.callbacks == null ? null : Collections.unmodifiableList(this.callbacks);
    }

    protected void doFlush() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.currentStream.flush();
        if (null != this.callbacks) {
            for (CachedOutputStreamCallback cb : this.callbacks) {
                cb.onFlush(this);
            }
        }
        this.doFlush();
    }

    protected void doClose() throws IOException {
    }

    protected void postClose() throws IOException {
    }

    public void lockOutputStream() throws IOException {
        if (this.outputLocked) {
            return;
        }
        this.currentStream.flush();
        this.outputLocked = true;
        if (null != this.callbacks) {
            for (CachedOutputStreamCallback cb : this.callbacks) {
                cb.onClose(this);
            }
        }
        this.doClose();
        this.streamList.remove(this.currentStream);
    }

    @Override
    public void close() throws IOException {
        this.currentStream.flush();
        this.outputLocked = true;
        if (null != this.callbacks) {
            for (CachedOutputStreamCallback cb : this.callbacks) {
                cb.onClose(this);
            }
        }
        this.doClose();
        this.currentStream.close();
        this.maybeDeleteTempFile(this.currentStream);
        this.postClose();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CachedOutputStream) {
            return this.currentStream.equals(((CachedOutputStream)obj).currentStream);
        }
        return this.currentStream.equals(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetOut(OutputStream out, boolean copyOldContent) throws IOException {
        if (out == null) {
            out = new ByteArrayOutputStream();
        }
        if (this.currentStream instanceof CachedOutputStream) {
            CachedOutputStream ac = (CachedOutputStream)this.currentStream;
            InputStream in = ac.getInputStream();
            IOUtils.copyAndCloseInput((InputStream)in, (OutputStream)out);
        } else if (this.inmem) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteOut = (ByteArrayOutputStream)this.currentStream;
                if (copyOldContent && byteOut.size() > 0) {
                    byteOut.writeTo(out);
                }
            } else {
                if (!(this.currentStream instanceof PipedOutputStream)) throw new IOException("Unknown format of currentStream");
                PipedOutputStream pipeOut = (PipedOutputStream)this.currentStream;
                IOUtils.copyAndCloseInput((InputStream)new PipedInputStream(pipeOut), (OutputStream)out);
            }
        } else {
            this.currentStream.close();
            if (copyOldContent) {
                FileInputStream fin = new FileInputStream(this.tempFile);
                IOUtils.copyAndCloseInput((InputStream)fin, (OutputStream)out);
            }
            this.streamList.remove(this.currentStream);
            this.deleteTempFile();
            this.inmem = true;
        }
        this.currentStream = out;
        this.outputLocked = false;
    }

    public static void copyStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        IOUtils.copyAndCloseInput((InputStream)in, (OutputStream)out, (int)bufferSize);
    }

    public long size() {
        return this.totalLength;
    }

    public byte[] getBytes() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return ((ByteArrayOutputStream)this.currentStream).toByteArray();
            }
            throw new IOException("Unknown format of currentStream");
        }
        FileInputStream fin = new FileInputStream(this.tempFile);
        return IOUtils.readBytesFromStream((InputStream)fin);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(OutputStream out) throws IOException {
        this.flush();
        if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            ((ByteArrayOutputStream)this.currentStream).writeTo(out);
            return;
        } else {
            FileInputStream fin = new FileInputStream(this.tempFile);
            IOUtils.copyAndCloseInput((InputStream)fin, (OutputStream)out);
        }
    }

    public void writeCacheTo(StringBuilder out, long limit) throws IOException {
        this.writeCacheTo(out, "UTF-8", limit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(StringBuilder out, String charsetName, long limit) throws IOException {
        this.flush();
        if (this.totalLength < limit || limit == -1L) {
            this.writeCacheTo(out, charsetName);
            return;
        }
        long count = 0L;
        if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            byte[] bytes = ((ByteArrayOutputStream)this.currentStream).toByteArray();
            out.append(IOUtils.newStringFromBytes((byte[])bytes, (String)charsetName, (int)0, (int)((int)limit)));
            return;
        } else {
            FileInputStream fin = new FileInputStream(this.tempFile);
            byte[] bytes = new byte[1024];
            long x = fin.read(bytes);
            while (x != -1L) {
                if (count + x > limit) {
                    x = limit - count;
                }
                out.append(IOUtils.newStringFromBytes((byte[])bytes, (String)charsetName, (int)0, (int)((int)x)));
                if ((count += x) >= limit) {
                    x = -1L;
                    continue;
                }
                x = fin.read(bytes);
            }
            fin.close();
        }
    }

    public void writeCacheTo(StringBuilder out) throws IOException {
        this.writeCacheTo(out, "UTF-8");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(StringBuilder out, String charsetName) throws IOException {
        this.flush();
        if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            byte[] bytes = ((ByteArrayOutputStream)this.currentStream).toByteArray();
            out.append(IOUtils.newStringFromBytes((byte[])bytes, (String)charsetName));
            return;
        } else {
            FileInputStream fin = new FileInputStream(this.tempFile);
            byte[] bytes = new byte[1024];
            int x = fin.read(bytes);
            while (x != -1) {
                out.append(IOUtils.newStringFromBytes((byte[])bytes, (String)charsetName, (int)0, (int)x));
                x = fin.read(bytes);
            }
            fin.close();
        }
    }

    public OutputStream getOut() {
        return this.currentStream;
    }

    public int hashCode() {
        return this.currentStream.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("[").append(CachedOutputStream.class.getName()).append(" Content: ");
        try {
            this.writeCacheTo(builder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.append("]").toString();
    }

    protected void onWrite() throws IOException {
    }

    private void enforceLimits() throws IOException {
        if (this.maxSize > 0L && this.totalLength > this.maxSize) {
            throw new CacheSizeExceededException();
        }
        if (this.inmem && this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.createFileOutputStream();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            this.totalLength += (long)len;
            this.enforceLimits();
            this.currentStream.write(b, off, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            this.totalLength += (long)b.length;
            this.enforceLimits();
            this.currentStream.write(b);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            ++this.totalLength;
            this.enforceLimits();
            this.currentStream.write(b);
        }
    }

    private void createFileOutputStream() throws IOException {
        if (this.tempFileFailed) {
            return;
        }
        ByteArrayOutputStream bout = (ByteArrayOutputStream)this.currentStream;
        try {
            this.tempFile = this.outputDir == null ? FileUtils.createTempFile((String)"cos", (String)"tmp") : FileUtils.createTempFile((String)"cos", (String)"tmp", (File)this.outputDir, (boolean)false);
            this.currentStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
            bout.writeTo(this.currentStream);
            this.inmem = false;
            this.streamList.add(this.currentStream);
        }
        catch (Exception ex) {
            this.tempFileFailed = true;
            if (this.currentStream != bout) {
                this.currentStream.close();
            }
            this.deleteTempFile();
            this.inmem = true;
            this.currentStream = bout;
        }
    }

    public File getTempFile() {
        return this.tempFile != null && this.tempFile.exists() ? this.tempFile : null;
    }

    public InputStream getInputStream() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof LoadingByteArrayOutputStream) {
                return ((LoadingByteArrayOutputStream)this.currentStream).createInputStream();
            }
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return new ByteArrayInputStream(((ByteArrayOutputStream)this.currentStream).toByteArray());
            }
            if (this.currentStream instanceof PipedOutputStream) {
                return new PipedInputStream((PipedOutputStream)this.currentStream);
            }
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.tempFile){
                boolean closed;

                public void close() throws IOException {
                    if (!this.closed) {
                        super.close();
                        CachedOutputStream.this.maybeDeleteTempFile(this);
                    }
                    this.closed = true;
                }
            };
            this.streamList.add(fileInputStream);
            return fileInputStream;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cached file was deleted, " + e.toString());
        }
    }

    private synchronized void deleteTempFile() {
        if (this.tempFile != null) {
            File file = this.tempFile;
            this.tempFile = null;
            FileUtils.delete((File)file);
        }
    }

    private void maybeDeleteTempFile(Object stream) {
        this.streamList.remove(stream);
        if (!this.inmem && this.tempFile != null && this.streamList.isEmpty() && this.allowDeleteOfFile) {
            if (this.currentStream != null) {
                try {
                    this.currentStream.close();
                    this.postClose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.deleteTempFile();
            this.currentStream = new LoadingByteArrayOutputStream(1024);
            this.inmem = true;
        }
    }

    public void setOutputDir(File outputDir) throws IOException {
        this.outputDir = outputDir;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public static void setDefaultMaxSize(long l) {
        if (l == -1L) {
            String s = System.getProperty("org.apache.cxf.io.CachedOutputStream.MaxSize", "-1");
            l = Long.parseLong(s);
        }
        defaultMaxSize = l;
    }

    public static void setDefaultThreshold(int i) {
        String s;
        if (i == -1 && (i = Integer.parseInt(s = SystemPropertyAction.getProperty((String)"org.apache.cxf.io.CachedOutputStream.Threshold", (String)"-1"))) <= 0) {
            i = 65536;
        }
        defaultThreshold = i;
    }

    static {
        File f;
        String s = SystemPropertyAction.getPropertyOrNull((String)"org.apache.cxf.io.CachedOutputStream.OutputDirectory");
        DEFAULT_TEMP_DIR = s != null ? ((f = new File(s)).exists() && f.isDirectory() ? f : null) : null;
        CachedOutputStream.setDefaultThreshold(-1);
        CachedOutputStream.setDefaultMaxSize(-1L);
    }
}

