/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws;

import java.lang.reflect.Method;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.ws.WebFault;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.model.JavaClass;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.annotator.WrapperBeanAnnotator;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.model.WrapperBeanClass;
import org.apache.cxf.tools.util.URIParserUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FaultBean {
    private static final String[] EXCLUDED_GETTER = new String[]{"getCause", "getLocalizedMessage", "getStackTrace", "getClass"};

    private String getWebFaultBean(Class<?> exceptionClass) {
        WebFault fault = exceptionClass.getAnnotation(WebFault.class);
        if (fault == null) {
            return null;
        }
        return fault.faultBean();
    }

    private boolean isWebFaultAbsent(Class exceptionClass) {
        return StringUtils.isEmpty((String)this.getWebFaultBean(exceptionClass));
    }

    public WrapperBeanClass transform(Class exceptionClass, String defaultPackage) {
        WrapperBeanClass jClass = new WrapperBeanClass();
        if (this.isWebFaultAbsent(exceptionClass)) {
            jClass.setName(exceptionClass.getSimpleName() + "Bean");
            jClass.setPackageName(defaultPackage);
        } else {
            jClass.setFullClassName(this.getWebFaultBean(exceptionClass));
        }
        this.buildBeanFields(exceptionClass, jClass);
        if (exceptionClass.getPackage() != null) {
            jClass.setElementName(new QName(URIParserUtil.getNamespace((String)exceptionClass.getPackage().getName()), exceptionClass.getSimpleName()));
        } else {
            jClass.setElementName(new QName(URIParserUtil.getNamespace((String)"defaultnamespace"), exceptionClass.getSimpleName()));
        }
        jClass.annotate(new WrapperBeanAnnotator());
        return jClass;
    }

    private String getFieldName(Method method) {
        String name = method.getName().substring(3);
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private boolean isIncludedGetter(Method method) {
        return method.getName().startsWith("get") && !Arrays.asList(EXCLUDED_GETTER).contains(method.getName());
    }

    private void buildBeanFields(Class exceptionClass, JavaClass jClass) {
        for (Method method : exceptionClass.getMethods()) {
            if (!this.isIncludedGetter(method)) continue;
            JavaField field = new JavaField(this.getFieldName(method), method.getReturnType().getName(), "");
            field.setOwner((JavaInterface)jClass);
            jClass.addField(field);
            jClass.appendGetter(field);
            jClass.appendSetter(field);
        }
    }
}

