/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.details;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.curator.x.discovery.InstanceFilter;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.InstanceProvider;

class FilteredInstanceProvider<T>
implements InstanceProvider<T> {
    private final InstanceProvider<T> instanceProvider;
    private final Predicate<ServiceInstance<T>> predicates;

    FilteredInstanceProvider(InstanceProvider<T> instanceProvider, List<InstanceFilter<T>> filters) {
        this.instanceProvider = instanceProvider;
        this.predicates = Predicates.and(filters);
    }

    @Override
    public List<ServiceInstance<T>> getInstances() throws Exception {
        Iterable filtered = Iterables.filter(this.instanceProvider.getInstances(), this.predicates);
        return ImmutableList.copyOf((Iterable)filtered);
    }
}

