/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.server.entity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceInstanceBuilder;
import org.apache.curator.x.discovery.ServiceType;
import org.apache.curator.x.discovery.server.rest.DiscoveryContext;

@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JsonServiceInstanceMarshaller<T>
implements MessageBodyReader<ServiceInstance<T>>,
MessageBodyWriter<ServiceInstance<T>> {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final DiscoveryContext<T> context;

    public JsonServiceInstanceMarshaller(DiscoveryContext<T> context) {
        this.context = context;
    }

    static <T> ServiceInstance<T> readInstance(JsonNode node, DiscoveryContext<T> context) throws Exception {
        ServiceInstanceBuilder builder = ServiceInstance.builder();
        builder.name(node.get("name").asText());
        builder.id(node.get("id").asText());
        builder.address(node.get("address").asText());
        builder.registrationTimeUTC(node.get("registrationTimeUTC").asLong());
        builder.serviceType(ServiceType.valueOf((String)node.get("serviceType").asText()));
        builder.payload(context.unMarshallJson(node.get("payload")));
        Integer port = JsonServiceInstanceMarshaller.getInteger(node, "port");
        Integer sslPort = JsonServiceInstanceMarshaller.getInteger(node, "sslPort");
        if (port != null) {
            builder.port(port.intValue());
        }
        if (sslPort != null) {
            builder.sslPort(sslPort.intValue());
        }
        return builder.build();
    }

    static <T> ObjectNode writeInstance(ObjectMapper mapper, ServiceInstance<T> instance, DiscoveryContext<T> context) {
        ObjectNode node = mapper.createObjectNode();
        node.put("name", instance.getName());
        node.put("id", instance.getId());
        node.put("address", instance.getAddress());
        JsonServiceInstanceMarshaller.putInteger(node, "port", instance.getPort());
        JsonServiceInstanceMarshaller.putInteger(node, "sslPort", instance.getSslPort());
        node.put("registrationTimeUTC", instance.getRegistrationTimeUTC());
        node.put("serviceType", instance.getServiceType().name());
        try {
            context.marshallJson(node, "payload", instance.getPayload());
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return node;
    }

    private static Integer getInteger(JsonNode node, String fieldName) {
        JsonNode intNode = node.get(fieldName);
        return intNode != null ? Integer.valueOf(intNode.asInt()) : null;
    }

    private static void putInteger(ObjectNode node, String fieldName, Integer value) {
        if (value != null) {
            node.put(fieldName, value);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isWriteable(type, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ServiceInstance.class.isAssignableFrom(type) && mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE);
    }

    public long getSize(ServiceInstance<T> serviceInstance, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public ServiceInstance<T> readFrom(Class<ServiceInstance<T>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            JsonNode node = mapper.readTree(entityStream);
            return JsonServiceInstanceMarshaller.readInstance(node, this.context);
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    public void writeTo(ServiceInstance<T> serviceInstance, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ObjectNode node = JsonServiceInstanceMarshaller.writeInstance(mapper, serviceInstance, this.context);
        mapper.writeValue(entityStream, (Object)node);
    }
}

