/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.server.rest;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceCleanup
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(InstanceCleanup.class);
    private final ServiceDiscovery<Object> discovery;
    private final int instanceRefreshMs;
    private final ScheduledExecutorService service = ThreadUtils.newSingleThreadScheduledExecutor((String)"InstanceCleanup");

    public InstanceCleanup(ServiceDiscovery<?> discovery, int instanceRefreshMs) {
        this.discovery = discovery;
        this.instanceRefreshMs = instanceRefreshMs;
    }

    public void start() {
        Preconditions.checkArgument((!this.service.isShutdown() ? 1 : 0) != 0, (Object)"already started");
        this.service.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                InstanceCleanup.this.doWork();
            }
        }, this.instanceRefreshMs, this.instanceRefreshMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkArgument((!this.service.isShutdown() ? 1 : 0) != 0, (Object)"not started");
        this.service.shutdownNow();
    }

    private void doWork() {
        try {
            for (String name : this.discovery.queryForNames()) {
                this.checkService(name);
            }
        }
        catch (Exception e) {
            log.error("GC for service names", (Throwable)e);
        }
    }

    private void checkService(String name) {
        try {
            Collection instances = this.discovery.queryForInstances(name);
            for (ServiceInstance instance : instances) {
                if (instance.getServiceType() != ServiceType.STATIC || System.currentTimeMillis() - instance.getRegistrationTimeUTC() <= (long)this.instanceRefreshMs) continue;
                this.discovery.unregisterService(instance);
            }
        }
        catch (Exception e) {
            log.error(String.format("GC for service: %s", name), (Throwable)e);
        }
    }
}

