/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.List;
import org.apache.curator.framework.imps.CuratorFrameworkBase;
import org.apache.curator.framework.imps.ReconfigBuilderImpl;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.api.AsyncEnsemblable;
import org.apache.curator.x.async.api.AsyncReconfigBuilder;
import org.apache.curator.x.async.details.BackgroundProcs;
import org.apache.curator.x.async.details.BuilderCommon;
import org.apache.curator.x.async.details.Filters;
import org.apache.zookeeper.data.Stat;

class AsyncReconfigBuilderImpl
implements AsyncReconfigBuilder,
AsyncEnsemblable<AsyncStage<Void>> {
    private final CuratorFrameworkBase client;
    private final Filters filters;
    private Stat stat = null;
    private long fromConfig = -1L;
    private List<String> newMembers = null;
    private List<String> joining = null;
    private List<String> leaving = null;

    AsyncReconfigBuilderImpl(CuratorFrameworkBase client, Filters filters) {
        this.client = client;
        this.filters = filters;
    }

    @Override
    public AsyncEnsemblable<AsyncStage<Void>> withNewMembers(List<String> servers) {
        this.newMembers = servers;
        return this;
    }

    @Override
    public AsyncEnsemblable<AsyncStage<Void>> withJoiningAndLeaving(List<String> joining, List<String> leaving) {
        this.joining = joining;
        this.leaving = leaving;
        return this;
    }

    @Override
    public AsyncEnsemblable<AsyncStage<Void>> withNewMembers(List<String> servers, Stat stat) {
        this.newMembers = servers;
        this.stat = stat;
        return this;
    }

    @Override
    public AsyncEnsemblable<AsyncStage<Void>> withJoiningAndLeaving(List<String> joining, List<String> leaving, Stat stat) {
        this.joining = joining;
        this.leaving = leaving;
        return this;
    }

    @Override
    public AsyncEnsemblable<AsyncStage<Void>> withNewMembers(List<String> servers, Stat stat, long fromConfig) {
        this.newMembers = servers;
        this.stat = stat;
        this.fromConfig = fromConfig;
        return this;
    }

    @Override
    public AsyncEnsemblable<AsyncStage<Void>> withJoiningAndLeaving(List<String> joining, List<String> leaving, Stat stat, long fromConfig) {
        this.joining = joining;
        this.leaving = leaving;
        this.stat = stat;
        this.fromConfig = fromConfig;
        return this;
    }

    @Override
    public AsyncEnsemblable<AsyncStage<Void>> withNewMembers(List<String> servers, long fromConfig) {
        this.newMembers = servers;
        this.fromConfig = fromConfig;
        return this;
    }

    @Override
    public AsyncEnsemblable<AsyncStage<Void>> withJoiningAndLeaving(List<String> joining, List<String> leaving, long fromConfig) {
        this.joining = joining;
        this.leaving = leaving;
        this.fromConfig = fromConfig;
        return this;
    }

    @Override
    public AsyncStage<Void> forEnsemble() {
        BuilderCommon<Void> common = new BuilderCommon<Void>(this.filters, BackgroundProcs.ignoredProc);
        ReconfigBuilderImpl builder = new ReconfigBuilderImpl(this.client, common.backgrounding, this.stat, this.fromConfig, this.newMembers, this.joining, this.leaving);
        return BackgroundProcs.safeCall(common.internalCallback, () -> {
            builder.forEnsemble();
            return null;
        });
    }
}

